/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.funbox;

import com.golden.gamedev.engine.BaseGraphics;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class ErrorNotificationDialog
extends JDialog
implements Runnable,
ActionListener,
WindowListener {
    private static final long serialVersionUID = 4446981217800668592L;
    protected Throwable error;
    protected BaseGraphics bsGraphics;
    protected String title;
    protected String emailAddress;
    protected JTextArea textArea;

    public ErrorNotificationDialog(Throwable error, BaseGraphics bsGraphics, String title, String emailAddress) {
        super((Frame)null, "Game Exception");
        error.printStackTrace();
        this.error = error;
        this.bsGraphics = bsGraphics;
        this.title = title;
        this.emailAddress = emailAddress;
        this.addWindowListener(this);
        if (bsGraphics instanceof Applet) {
            Thread action = new Thread(this);
            action.setDaemon(true);
            action.start();
        } else {
            this.initGUI();
        }
    }

    public void run() {
        try {
            Thread.sleep(1500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.initGUI();
    }

    protected void printStackTrace() {
        this.append(this.textArea, "Game Exception on " + this.title);
        String underline = "------------------";
        for (int i = 0; i < this.title.length(); ++i) {
            underline = underline + "-";
        }
        this.append(this.textArea, underline);
        StringWriter src = new StringWriter();
        PrintWriter writer = new PrintWriter(src);
        this.error.printStackTrace(writer);
        this.append(this.textArea, src.toString());
        try {
            this.append(this.textArea, "Game Environment");
            this.append(this.textArea, "----------------");
            SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy 'at' HH:mm");
            this.append2(this.textArea, "Date/Time         : ", format.format(Calendar.getInstance(TimeZone.getTimeZone("GMT+7")).getTime()));
            this.append2(this.textArea, "Java Version      : ", this.getSystemProperty(new String[]{"java.vm.version", "java.vendor"}));
            this.append2(this.textArea, "GTGE Version      : ", "0.2.4");
            this.append2(this.textArea, "Environment       : ", this.bsGraphics.getGraphicsDescription());
            this.append2(this.textArea, "Operating System  : ", this.getSystemProperty(new String[]{"os.name", "os.version", "sun.os.patch.level"}));
            this.append2(this.textArea, "User Name         : ", this.getSystemProperty(new String[]{"user.name"}));
            this.append2(this.textArea, "Working Directory : ", this.getSystemProperty(new String[]{"user.dir"}));
        }
        catch (Throwable e) {
            this.append(this.textArea, e.toString());
        }
    }

    protected void initGUI() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            Color color = new Color(236, 233, 216);
            this.textArea = new JTextArea();
            this.textArea.setEditable(false);
            this.textArea.setFont(new Font("Monospaced", 0, 11));
            this.textArea.setBackground(color);
            this.printStackTrace();
            JPanel panel = new JPanel();
            panel.setBackground(color);
            panel.setLayout(new BorderLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(10, 7, 10, 7));
            JPanel northPane = new JPanel();
            northPane.setLayout(new BoxLayout(northPane, 0));
            northPane.setBackground(color);
            northPane.setBorder(BorderFactory.createEmptyBorder(0, 2, 10, 0));
            JPanel leftPane = new JPanel();
            leftPane.setLayout(new BoxLayout(leftPane, 1));
            leftPane.setBackground(color);
            Font labelFont = new Font("SansSerif", 0, 12);
            JLabel lb1 = new JLabel("An unrecoverable error occured in the game.");
            lb1.setFont(labelFont);
            JLabel lb2 = new JLabel("Please mail below exception to:");
            lb2.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
            lb2.setFont(labelFont);
            JLabel lb3 = new JLabel(this.emailAddress);
            if (this.emailAddress == null || this.emailAddress.length() == 0) {
                lb3.setText("the game author");
            }
            lb3.setFont(labelFont.deriveFont(1));
            leftPane.add(lb1);
            leftPane.add(lb2);
            leftPane.add(lb3);
            JPanel rightPane = new JPanel();
            rightPane.setLayout(new FlowLayout(2));
            rightPane.setBackground(color);
            JPanel insideRightPane = new JPanel();
            insideRightPane.setLayout(new GridLayout(0, 1, 0, 9));
            insideRightPane.setOpaque(false);
            Color btnColor = new Color(252, 249, 232);
            Font btnFont = new Font("Dialog", 0, 11);
            ImageIcon[] icons = new ImageIcon[2];
            icons[0] = new ImageIcon(ErrorNotificationDialog.class.getResource("Icon1.png"));
            JButton btn1 = new JButton("copy to clipboard", icons[0]);
            btn1.setBackground(btnColor);
            btn1.setBorderPainted(false);
            btn1.setFocusPainted(false);
            btn1.setIconTextGap(9);
            btn1.setVerticalTextPosition(1);
            btn1.setHorizontalAlignment(2);
            btn1.setFont(btnFont);
            btn1.addActionListener(this);
            btn1.setPreferredSize(new Dimension(120, 22));
            btn1.setMargin(new Insets(0, 0, 0, 0));
            icons[1] = new ImageIcon(ErrorNotificationDialog.class.getResource("Icon2.png"));
            JButton btn2 = new JButton("close application", icons[1]);
            btn2.setBackground(btnColor);
            btn2.setBorderPainted(false);
            btn2.setFocusPainted(false);
            btn2.setIconTextGap(9);
            btn2.setVerticalTextPosition(1);
            btn2.setHorizontalAlignment(2);
            btn2.setFont(btnFont);
            btn2.addActionListener(this);
            btn2.setPreferredSize(new Dimension(120, 22));
            btn2.setMargin(new Insets(0, 0, 0, 0));
            insideRightPane.add(btn1);
            insideRightPane.add(btn2);
            rightPane.add(insideRightPane);
            northPane.add(leftPane);
            northPane.add(rightPane);
            JScrollPane scrollPane = new JScrollPane(this.textArea);
            scrollPane.setBackground(color);
            scrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(0), BorderFactory.createEmptyBorder(3, 4, 3, 4)));
            panel.add((Component)northPane, "North");
            panel.add((Component)scrollPane, "Center");
            this.setContentPane(panel);
            this.pack();
            this.setSize(475, 400);
            this.setLocationRelativeTo(null);
            try {
                Toolkit.getDefaultToolkit().beep();
            }
            catch (Throwable e) {
                // empty catch block
            }
            this.setResizable(false);
            this.setVisible(true);
            this.getRootPane().setDefaultButton(btn2);
            btn2.requestFocus();
            while (true) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (this.isFocused()) continue;
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (this.isFocused()) continue;
                this.textArea.selectAll();
                this.textArea.copy();
                this.closeDialog();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.closeDialog();
            return;
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.textArea.selectAll();
        this.textArea.copy();
        if (e.getActionCommand().equals("close application")) {
            this.closeDialog();
        }
    }

    public void closeDialog() {
        try {
            if (!(this.bsGraphics instanceof Applet)) {
                System.exit(0);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.dispose();
    }

    public void windowClosing(WindowEvent e) {
        this.closeDialog();
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    private void append(JTextArea text, String st) {
        text.append(st + "\n");
    }

    private void append2(JTextArea text, String st, String st2) {
        text.append(st);
        text.append(st2 + "\n");
    }

    private String getSystemProperty(String[] props) {
        StringBuffer results = new StringBuffer();
        for (int i = 0; i < props.length; ++i) {
            try {
                String prop = System.getProperty(props[i]);
                if (prop == null) continue;
                results.append(prop).append(" ");
                continue;
            }
            catch (Throwable e) {
                return e.toString();
            }
        }
        if (results.length() > 0) {
            results.deleteCharAt(results.length() - 1);
        }
        return results.toString();
    }
}

