/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.object;

import com.golden.gamedev.object.SpriteGroup;
import com.golden.gamedev.object.collision.CollisionRect;
import java.awt.image.BufferedImage;

public abstract class CollisionManager {
    private SpriteGroup group1;
    private SpriteGroup group2;
    private boolean active = true;
    private static final CollisionRect iRect = new CollisionRect();

    public void setCollisionGroup(SpriteGroup group1, SpriteGroup group2) {
        this.group1 = group1;
        this.group2 = group2;
    }

    public SpriteGroup getGroup1() {
        return this.group1;
    }

    public SpriteGroup getGroup2() {
        return this.group2;
    }

    public abstract void checkCollision();

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean b) {
        this.active = b;
    }

    public static boolean isPixelCollide(double x1, double y1, BufferedImage image1, double x2, double y2, BufferedImage image2) {
        double width1 = x1 + (double)image1.getWidth() - 1.0;
        double height1 = y1 + (double)image1.getHeight() - 1.0;
        double width2 = x2 + (double)image2.getWidth() - 1.0;
        double height2 = y2 + (double)image2.getHeight() - 1.0;
        int xstart = (int)Math.max(x1, x2);
        int ystart = (int)Math.max(y1, y2);
        int xend = (int)Math.min(width1, width2);
        int yend = (int)Math.min(height1, height2);
        int toty = Math.abs(yend - ystart);
        int totx = Math.abs(xend - xstart);
        for (int y = 1; y < toty - 1; ++y) {
            int ny = Math.abs(ystart - (int)y1) + y;
            int ny1 = Math.abs(ystart - (int)y2) + y;
            for (int x = 1; x < totx - 1; ++x) {
                int nx = Math.abs(xstart - (int)x1) + x;
                int nx1 = Math.abs(xstart - (int)x2) + x;
                try {
                    if ((image1.getRGB(nx, ny) & 0xFF000000) == 0 || (image2.getRGB(nx1, ny1) & 0xFF000000) == 0) continue;
                    return true;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public static CollisionRect getIntersectionRect(double x1, double y1, int width1, int height1, double x2, double y2, int width2, int height2) {
        double x12 = x1 + (double)width1;
        double y12 = y1 + (double)height1;
        double x22 = x2 + (double)width2;
        double y22 = y2 + (double)height2;
        if (x1 < x2) {
            x1 = x2;
        }
        if (y1 < y2) {
            y1 = y2;
        }
        if (x12 > x22) {
            x12 = x22;
        }
        if (y12 > y22) {
            y12 = y22;
        }
        iRect.setBounds(x1, y1, (int)(x12 -= x1), (int)(y12 -= y1));
        return iRect;
    }
}

