/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.object;

import com.golden.gamedev.object.GameFont;
import com.golden.gamedev.object.font.AdvanceBitmapFont;
import com.golden.gamedev.object.font.BitmapFont;
import com.golden.gamedev.object.font.SystemFont;
import com.golden.gamedev.util.ImageUtil;
import com.golden.gamedev.util.Utility;
import java.awt.Color;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;

public class GameFontManager {
    private final Map fontBank = new HashMap(5);

    public void clear() {
        this.fontBank.clear();
    }

    public Object removeFont(Object name) {
        return this.fontBank.remove(name);
    }

    public GameFont getFont(String name) {
        return (GameFont)this.fontBank.get(name);
    }

    public GameFont putFont(String name, GameFont font) {
        return this.fontBank.put(name, font);
    }

    public GameFont getFont(BufferedImage bitmap) {
        GameFont font = (GameFont)this.fontBank.get(bitmap);
        if (font == null) {
            font = new AdvanceBitmapFont(this.cutLetter(bitmap));
            this.fontBank.put(bitmap, font);
        }
        return font;
    }

    public GameFont getFont(BufferedImage bitmap, String letterSequence) {
        GameFont font = (GameFont)this.fontBank.get(bitmap);
        if (font == null) {
            font = new AdvanceBitmapFont(this.cutLetter(bitmap), letterSequence);
            this.fontBank.put(bitmap, font);
        }
        return font;
    }

    private BufferedImage[] cutLetter(BufferedImage bitmap) {
        int delimiter = bitmap.getRGB(0, 0);
        int[] width = new int[100];
        int ctr = 0;
        int last = 0;
        for (int i = 1; i < bitmap.getWidth(); ++i) {
            if (bitmap.getRGB(i, 0) != delimiter) continue;
            width[ctr++] = i - last;
            last = i;
            if (ctr < width.length) continue;
            width = (int[])Utility.expand(width, 50);
        }
        BufferedImage[] imagefont = new BufferedImage[ctr];
        Color backgr = new Color(bitmap.getRGB(1, 0));
        int height = bitmap.getHeight() - 1;
        int w = 0;
        for (int i = 0; i < imagefont.length; ++i) {
            imagefont[i] = ImageUtil.applyMask(bitmap.getSubimage(w, 1, width[i], height), backgr);
            w += width[i];
        }
        return imagefont;
    }

    public GameFont getFont(BufferedImage[] bitmap) {
        GameFont font = (GameFont)this.fontBank.get(bitmap);
        if (font == null) {
            font = new BitmapFont(bitmap);
            this.fontBank.put(bitmap, font);
        }
        return font;
    }

    public GameFont getFont(BufferedImage[] bitmap, String letterSequence) {
        GameFont font = (GameFont)this.fontBank.get(bitmap);
        if (font == null) {
            font = new BitmapFont(bitmap, letterSequence);
            this.fontBank.put(bitmap, font);
        }
        return font;
    }

    public GameFont getFont(Font f) {
        return this.getFont(f, null);
    }

    public GameFont getFont(Font f, Color col) {
        GameFont font = (GameFont)this.fontBank.get(f);
        if (font == null) {
            font = col == null ? new SystemFont(f) : new SystemFont(f, col);
            this.fontBank.put(f, font);
        }
        return font;
    }
}

