/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.object;

import Objects.MovingHelmetShell;
import Objects.MovingTurtelShell;
import com.golden.gamedev.object.Background;
import com.golden.gamedev.object.Sprite;
import com.golden.gamedev.object.Timer;
import com.golden.gamedev.util.Utility;
import java.awt.Graphics2D;
import java.util.Arrays;
import java.util.Comparator;

public class SpriteGroup {
    private int expandFactor = 20;
    private Timer scanFrequence = new Timer(15000);
    private String name;
    private boolean active = true;
    private Background background;
    private Comparator comparator;
    private Sprite[] sprites;
    private int size;

    public SpriteGroup(String name) {
        this.name = name;
        this.background = Background.getDefaultBackground();
        this.sprites = new Sprite[this.expandFactor];
    }

    public void add(Sprite member) {
        this.sprites[this.size] = member;
        member.setBackground(this.background);
        if (++this.size >= this.sprites.length) {
            this.sprites = (Sprite[])Utility.expand(this.sprites, this.expandFactor);
        }
    }

    public void add(int index, Sprite member) {
        if (index > this.size) {
            index = this.size;
        }
        if (index == this.size) {
            this.add(member);
        } else {
            System.arraycopy(this.sprites, index, this.sprites, index + 1, this.size - index);
            this.sprites[index] = member;
            member.setBackground(this.background);
            if (++this.size >= this.sprites.length) {
                this.sprites = (Sprite[])Utility.expand(this.sprites, this.expandFactor);
            }
        }
    }

    public Sprite remove(int index) {
        Sprite removedSprite = this.sprites[index];
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.sprites, index + 1, this.sprites, index, numMoved);
        }
        this.sprites[--this.size] = null;
        return removedSprite;
    }

    public boolean remove(Sprite s) {
        for (int i = 0; i < this.size; ++i) {
            if (this.sprites[i] != s) continue;
            this.remove(i);
            return true;
        }
        return false;
    }

    public void clear() {
        this.size = 0;
    }

    public void reset() {
        this.sprites = null;
        this.sprites = new Sprite[this.expandFactor];
        this.size = 0;
    }

    public void update(long elapsedTime) {
        for (int i = 0; i < this.size; ++i) {
            if (!this.sprites[i].isActive()) continue;
            if (this.sprites[i] instanceof MovingTurtelShell | this.sprites[i] instanceof MovingHelmetShell) {
                this.sprites[i].update(elapsedTime);
            } else if (this.sprites[i].getScreenX() > -500.0 && this.sprites[i].getScreenX() < 800.0) {
                this.sprites[i].update(elapsedTime);
            }
            if (!(this.sprites[i].getY() < -1000.0) && !(this.sprites[i].getY() > 1500.0)) continue;
            this.sprites[i].setActive(false);
        }
        if (this.scanFrequence.action(elapsedTime)) {
            this.removeInactiveSprites();
        }
    }

    public void removeInactiveSprites() {
        this.removeSprites(false);
    }

    public void removeImmutableSprites() {
        this.removeSprites(true);
    }

    private void removeSprites(boolean removeImmutable) {
        int removed = 0;
        for (int i = 0; i < this.size; ++i) {
            if (!removeImmutable) {
                while (i + removed < this.size && !this.sprites[i + removed].isActive() && !this.sprites[i + removed].isImmutable()) {
                    ++removed;
                }
            } else {
                while (i + removed < this.size && !this.sprites[i + removed].isActive()) {
                    ++removed;
                }
            }
            if (removed <= 0) continue;
            this.removeRange(i, i + removed);
            removed = 0;
        }
        if (this.sprites.length > this.size + this.expandFactor * 2) {
            Sprite[] dest = new Sprite[this.size + this.expandFactor];
            System.arraycopy(this.sprites, 0, dest, 0, this.size);
            this.sprites = dest;
        }
    }

    private void removeRange(int fromIndex, int toIndex) {
        int numMoved = this.size - toIndex;
        System.arraycopy(this.sprites, toIndex, this.sprites, fromIndex, numMoved);
        int newSize = this.size - (toIndex - fromIndex);
        while (this.size != newSize) {
            this.sprites[--this.size] = null;
        }
    }

    public void render(Graphics2D g) {
        if (this.comparator != null) {
            this.sort(this.comparator);
        }
        for (int i = 0; i < this.size; ++i) {
            if (!this.sprites[i].isActive()) continue;
            this.sprites[i].render(g);
        }
    }

    public void sort(Comparator c) {
        Arrays.sort(this.sprites, 0, this.size, c);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Background getBackground() {
        return this.background;
    }

    public void setBackground(Background backgr) {
        this.background = backgr;
        if (this.background == null) {
            this.background = Background.getDefaultBackground();
        }
        for (int i = 0; i < this.size; ++i) {
            this.sprites[i].setBackground(this.background);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean b) {
        this.active = b;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator c) {
        this.comparator = c;
    }

    public Sprite getActiveSprite() {
        for (int i = 0; i < this.size; ++i) {
            if (!this.sprites[i].isActive()) continue;
            return this.sprites[i];
        }
        return null;
    }

    public Sprite getInactiveSprite() {
        for (int i = 0; i < this.size; ++i) {
            if (this.sprites[i].isActive()) continue;
            this.sprites[i].setActive(true);
            return this.sprites[i];
        }
        return null;
    }

    public Sprite[] getSprites() {
        return this.sprites;
    }

    public int getSize() {
        return this.size;
    }

    public int getExpandFactor() {
        return this.expandFactor;
    }

    public void setExpandFactor(int factor) {
        this.expandFactor = factor;
    }

    public Timer getScanFrequence() {
        return this.scanFrequence;
    }

    public String toString() {
        return super.toString() + " " + "[name=" + this.name + ", active=" + this.getSize() + ", total=" + this.sprites.length + ", member=" + this.getActiveSprite() + ", background=" + this.background + "]";
    }
}

