/*
 * Decompiled with CFR 0.152.
 */
package biege;

import biege.Crystal;
import biege.Element;
import biege.Enemy;
import biege.GUI;
import biege.Position;
import biege.Projectile;
import biege.WarpHome;
import biege.WorldData;
import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;

public class BadEye
extends Enemy {
    private static String YOU_BEAT_IT_SONG = "file:sound/beat.wav";
    private static int RADIUS = 8;
    private int crystalId;
    private int numCrystals;
    private int waveCycleCount;
    private int WAVE_CYCLE_UP = 100;
    private Projectile[] wave = new Projectile[8];
    private boolean invincible = true;

    public BadEye(Position p, int id, int num) {
        super(p);
        this.crystalId = id;
        this.numCrystals = num;
        this.waveCycleCount = this.WAVE_CYCLE_UP;
        this.makeWave();
    }

    public void advance(GUI tempGui) {
        int i;
        ArrayList tempList = tempGui.getGameParts();
        for (i = 0; i < this.wave.length; ++i) {
            if (this.wave[i].shoulVanish()) continue;
            this.wave[i].advance(tempGui);
        }
        if (this.waveCycleCount >= this.WAVE_CYCLE_UP) {
            this.makeWave();
            this.waveCycleCount = 0;
        } else {
            ++this.waveCycleCount;
        }
        for (i = 0; i < tempList.size(); ++i) {
            Element e = (Element)tempList.get(i);
            if (!e.isBad() || e == this) continue;
            return;
        }
        this.invincible = false;
    }

    public void draw(Graphics g, int viewW, int viewH) {
        for (int i = 0; i < this.wave.length; ++i) {
            if (this.wave[i].shoulVanish()) continue;
            this.wave[i].draw(g, viewW, viewH);
        }
        if (this.invincible) {
            g.setColor(Color.gray);
        } else {
            g.setColor(Color.white);
        }
        g.fillOval(this.scaleX(viewW) - Element.scaleWidth(viewW, RADIUS), this.scaleY(viewH) - Element.scaleHeight(viewH, RADIUS), Element.scaleWidth(viewW, 2 * RADIUS), Element.scaleHeight(viewH, 2 * RADIUS));
        g.setColor(Color.black);
        g.fillOval(this.scaleX(viewW), this.scaleY(viewH), 3, 3);
        g.drawLine(this.scaleX(viewW) - Element.scaleWidth(viewW, RADIUS), this.scaleY(viewH) - Element.scaleHeight(viewH, RADIUS), this.scaleX(viewW) + Element.scaleWidth(viewW, RADIUS), this.scaleY(viewH) - Element.scaleHeight(viewH, RADIUS));
    }

    public void interact(Element e) {
        for (int i = 0; i < this.wave.length; ++i) {
            if (this.wave[i].shoulVanish()) continue;
            this.wave[i].interact(e);
        }
    }

    public double getGurth() {
        return RADIUS;
    }

    public void delete() {
        if (!this.invincible) {
            super.delete();
        }
    }

    public void onDeath(GUI tempGui) {
        super.onDeath(tempGui);
        ArrayList tempList = tempGui.getGameParts();
        int id = this.crystalId;
        for (int i = 0; i < this.numCrystals; ++i) {
            Position p = new Position(this.getPosition().getX() + (Math.random() - 0.5) * (double)2 * (double)RADIUS, this.getPosition().getY() + (Math.random() - 0.5) * (double)2 * (double)RADIUS);
            tempGui.getGameParts().add(new Crystal(p, id));
            ++id;
        }
        WorldData.stopSong();
        WorldData.playSong(YOU_BEAT_IT_SONG);
        tempGui.getGameParts().add(new WarpHome(new Position(0.0, 0.0), 10, 150));
        tempGui.getPlayer().increaseScore(990);
    }

    private void makeWave() {
        this.wave[0] = new Projectile(new Position(40.0, 10.0), 0.0, 3.6, 3.0, Color.black);
        this.wave[1] = new Projectile(new Position(80.0, 10.0), 0.0, 3.1, 4.0, Color.blue);
        this.wave[2] = new Projectile(new Position(120.0, 10.0), 0.0, 2.6, 5.0, Color.cyan);
        this.wave[3] = new Projectile(new Position(160.0, 10.0), 0.0, 2.1, 6.0, Color.white);
        this.wave[4] = new Projectile(new Position(180.0, 35.0), -3.6, 0.0, 3.0, Color.black);
        this.wave[5] = new Projectile(new Position(180.0, 70.0), -3.1, 0.0, 4.0, Color.blue);
        this.wave[6] = new Projectile(new Position(180.0, 105.0), -2.6, 0.0, 5.0, Color.cyan);
        this.wave[7] = new Projectile(new Position(180.0, 140.0), -2.1, 0.0, 6.0, Color.white);
    }

    public void talk(GUI tempGui) {
    }
}

