/*
 * Decompiled with CFR 0.152.
 */
package biege;

import biege.AdventureApp;
import biege.DummyObserver;
import biege.GUI;
import biege.Position;
import biege.TextBox;
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlException;

public abstract class Element {
    private Position location;
    private boolean shouldVanish = false;
    private static String IMAGE_PATH = "images/";
    private static int modelW = AdventureApp.RIGHT - AdventureApp.LEFT;
    private static int modelH = AdventureApp.BOTTOM - AdventureApp.TOP;

    public Element(Position p) {
        this.location = p;
    }

    public static AudioClip loadAudioClip(String soundLocation) {
        try {
            URL temp = new URL(soundLocation);
            AudioClip audioClip = Applet.newAudioClip(temp);
            return audioClip;
        }
        catch (MalformedURLException e) {
            AudioClip audioClip = null;
            return audioClip;
        }
    }

    public static Image loadImage(String imgName) {
        Image i;
        Toolkit tk = Toolkit.getDefaultToolkit();
        try {
            i = tk.getImage(String.valueOf(IMAGE_PATH).concat(String.valueOf(imgName)));
        }
        catch (AccessControlException e) {
            System.out.println(String.valueOf("Could not load image ").concat(String.valueOf(imgName)));
            Image image = null;
            return image;
        }
        return i;
    }

    public static void drawImage(Image i, Graphics g, int x, int y, int w, int h) {
        DummyObserver o = new DummyObserver();
        if (i != null) {
            g.drawImage(i, x, y, w, h, o);
        }
    }

    public void changePosition(Position p) {
        this.location = p = new Position(Position.boundX(p.getX()), Position.boundY(p.getY()));
    }

    public int countCrystals() {
        return 0;
    }

    public Position getPosition() {
        return this.location;
    }

    public int scaleX(int viewW) {
        int x = (int)this.location.getX();
        return x * viewW / modelW;
    }

    public static int scaleWidth(int viewW, int width) {
        return width * viewW / modelW;
    }

    public static int scaleHeight(int viewH, int height) {
        return height * viewH / modelH;
    }

    public static int scaleX(int viewW, double oldX) {
        int x = (int)oldX;
        return x * viewW / modelW;
    }

    public void playSound(int i) {
    }

    public static int scaleY(int viewH, double oldY) {
        int y = (int)oldY;
        return y * viewH / modelH;
    }

    public int scaleY(int viewH) {
        int y = (int)this.location.getY();
        return y * viewH / modelH;
    }

    public void delete() {
        this.shouldVanish = true;
    }

    public void undelete() {
        this.shouldVanish = false;
    }

    public void onDeath(GUI tempGui) {
    }

    public void talk(GUI tempGui) {
        tempGui.setTextBox(TextBox.defaultTextBox());
    }

    public boolean shoulVanish() {
        return this.shouldVanish;
    }

    public abstract void draw(Graphics var1, int var2, int var3);

    public abstract void interact(Element var1);

    public void advance(GUI tempGui) {
    }

    public void hurt() {
    }

    public void giveCrystal(int i) {
    }

    public boolean hasAllCrystals() {
        return false;
    }

    public boolean hasCystal(int i) {
        return false;
    }

    public double getGurth() {
        return 0.0;
    }

    public boolean isSolid() {
        return true;
    }

    public boolean isBad() {
        return false;
    }
}

