/*
 * Decompiled with CFR 0.152.
 */
package biege;

import biege.AdventureApp;
import biege.PlayAreaView;
import biege.Player;
import biege.Player2;
import biege.TextBox;
import biege.WorldData;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.Timer;

public class GUI
extends JFrame {
    private AdventureApp app;
    private PlayAreaView viewer;
    private static boolean pressingUp = false;
    private static boolean pressingDown = false;
    private static boolean pressingLeft = false;
    private static boolean pressingRight = false;
    private static boolean pressingControl = false;
    private static boolean pressingSpace = false;
    private static boolean pressingM = false;
    private static boolean pressingShift = false;
    private static boolean pressingW = false;
    private static boolean pressingS = false;
    private static boolean pressingA = false;
    private static boolean pressingD = false;
    private boolean mapMode = false;
    private static int FLOW_DELAY = 66;
    private Timer gameTimer;
    private TextBox dialogue = null;

    public GUI(boolean player2On) {
        super("Adventure Game Biege");
        ((Component)this).setLocation(100, 100);
        ((Component)this).setSize(640, 480);
        pressingUp = false;
        pressingDown = false;
        pressingLeft = false;
        pressingRight = false;
        pressingControl = false;
        pressingShift = false;
        pressingW = false;
        pressingS = false;
        pressingA = false;
        pressingD = false;
        pressingSpace = false;
        this.viewer = new PlayAreaView(this);
        this.app = new AdventureApp(this, player2On);
        Container contents = this.getContentPane();
        this.viewer.setSize(this.getSize());
        contents.add(this.viewer);
        this.addKeyListener(new KeyCapture());
        this.addWindowListener(new WindowCloser());
        this.gameTimer = new Timer(FLOW_DELAY, new Tick());
        this.gameTimer.start();
    }

    public void show() {
        this.setCursor(1);
        super.show();
    }

    public void loadBackgrounds() {
    }

    public boolean multiplayOn() {
        return this.app.twoPlayer();
    }

    public void setTextBox(TextBox t) {
        this.dialogue = t;
    }

    public TextBox getTextBox() {
        return this.dialogue;
    }

    public static boolean isUpPressed() {
        return pressingUp;
    }

    public static boolean isDownPressed() {
        return pressingDown;
    }

    public static boolean isLeftPressed() {
        return pressingLeft;
    }

    public static boolean isRightPressed() {
        return pressingRight;
    }

    public static boolean isControlPressed() {
        return pressingControl;
    }

    public static boolean isSpacePressed() {
        return pressingSpace;
    }

    public static boolean isShiftPressed() {
        return pressingShift;
    }

    public static boolean isWPressed() {
        return pressingW;
    }

    public static boolean isSPressed() {
        return pressingS;
    }

    public static boolean isAPressed() {
        return pressingA;
    }

    public static boolean isDPressed() {
        return pressingD;
    }

    public boolean isInMapMode() {
        return this.mapMode;
    }

    public int getXScreen() {
        return this.app.getXScreen();
    }

    public int getYScreen() {
        return this.app.getYScreen();
    }

    public int getPlayerHealth() {
        return this.app.getPlayerHealth();
    }

    public int getPlayer2Health() {
        return this.app.getPlayer2Health();
    }

    public ArrayList getGameParts() {
        return this.app.getGameParts();
    }

    public void showHealthDisplay(int health) {
    }

    public void setScreen(int x, int y) {
        this.app.setScreen(x, y);
    }

    public GUI getMe() {
        return this;
    }

    public void closeMe() {
        WorldData.stopSong();
        WorldData.changeSong("");
        this.gameTimer.stop();
        this.app.getPlayer().emptyPouch();
        this.dispose();
    }

    public PlayAreaView getView() {
        return this.viewer;
    }

    private JFrame me() {
        return this;
    }

    public Player getPlayer() {
        return this.app.getPlayer();
    }

    public Player2 getPlayer2() {
        return this.app.getPlayer2();
    }

    private class KeyCapture
    implements KeyListener {
        private KeyCapture() {
        }

        public void keyPressed(KeyEvent key) {
            int keyId = key.getKeyCode();
            if (keyId == 38) {
                pressingUp = true;
            } else if (keyId == 40) {
                pressingDown = true;
            } else if (keyId == 37) {
                pressingLeft = true;
            } else if (keyId == 39) {
                pressingRight = true;
            } else if (keyId == 17) {
                pressingControl = true;
            } else if (keyId == 32) {
                pressingSpace = true;
            } else if (keyId == 16) {
                pressingShift = true;
            } else if (keyId == 87) {
                pressingW = true;
            } else if (keyId == 83) {
                pressingS = true;
            } else if (keyId == 65) {
                pressingA = true;
            } else if (keyId == 68) {
                pressingD = true;
            } else if (keyId == 77) {
                if (!pressingM) {
                    GUI.this.mapMode = !GUI.this.mapMode;
                }
                pressingM = true;
            }
            if (keyId == 10) {
                GUI.this.mapMode = false;
                GUI.this.dialogue = null;
            }
        }

        public void keyTyped(KeyEvent key) {
        }

        public void keyReleased(KeyEvent key) {
            int keyId = key.getKeyCode();
            if (keyId == 38) {
                pressingUp = false;
            } else if (keyId == 40) {
                pressingDown = false;
            } else if (keyId == 37) {
                pressingLeft = false;
            } else if (keyId == 39) {
                pressingRight = false;
            }
            if (keyId == 16) {
                pressingShift = false;
                Player2.getReadyToSmite();
            } else if (keyId == 87) {
                pressingW = false;
            } else if (keyId == 83) {
                pressingS = false;
            } else if (keyId == 65) {
                pressingA = false;
            } else if (keyId == 68) {
                pressingD = false;
            } else if (keyId == 17) {
                pressingControl = false;
                Player.getReadyToSmite();
            } else if (keyId == 32) {
                pressingSpace = false;
            } else if (keyId == 77) {
                pressingM = false;
            }
        }
    }

    private class WindowCloser
    extends WindowAdapter {
        private WindowCloser() {
        }

        public void windowClosing(WindowEvent e) {
            System.out.print("Bye Bye!");
            GUI.this.getMe().closeMe();
        }
    }

    private class Tick
    implements ActionListener {
        private Tick() {
        }

        public void actionPerformed(ActionEvent e) {
            GUI.this.app.advance();
            GUI.this.repaint();
        }
    }
}

