/*
 * Decompiled with CFR 0.152.
 */
package biege;

import biege.Angle;
import biege.Element;
import biege.GUI;
import biege.Player2;
import biege.Position;
import biege.TextBox;
import java.applet.AudioClip;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;

public class Player
extends Element {
    private static double xStep = 2.8;
    private static double yStep = 2.4;
    private boolean smiting = false;
    private static boolean readyToSmite = true;
    private static double STRIKE_REACH = 4.8;
    public static int HURT_RECOVER = 18;
    public static int MAX_HEALTH = 3;
    public static int INC_MAX_HEALTH_SCORE = 250;
    private static String[] LEVEL_UP = new String[]{"Level Up!", "Max health increased", "Health restored"};
    public static AudioClip SWING_SOUND = Element.loadAudioClip("file:sound/slice.wav");
    public static AudioClip HURT_SOUND = Element.loadAudioClip("file:sound/hit.wav");
    private static Image[] sprites = new Image[16];
    private Image currentSprite;
    private static int STAB_FRAME = 3;
    private Angle frameCount = new Angle(0.0);
    private boolean controlsEngaged = true;
    private boolean showLevelUpMsg = false;
    private boolean[] crystalPouch;
    private static final boolean[] EMPTY_POUCH = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    private boolean finnished = false;
    private int health = MAX_HEALTH;
    private int score;
    private int invincibility = 0;
    private int direction = Position.DIRECTION_SOUTH;
    private double gurth = 2.83;
    private int width = 10;
    private int height = 13;
    private Position facing;

    public Player(Position p) {
        super(p);
        this.facing = p;
        this.loadAllSprites();
        this.emptyPouch();
        this.finnished = false;
        this.health = MAX_HEALTH = 3;
        INC_MAX_HEALTH_SCORE = 250;
        this.score = 0;
        this.invincibility = 0;
        this.direction = Position.DIRECTION_SOUTH;
    }

    public void emptyPouch() {
        this.crystalPouch = EMPTY_POUCH;
    }

    private void loadAllSprites() {
        Player.sprites[Position.DIRECTION_NORTH] = Element.loadImage("dwarf_north_2.gif");
        Player.sprites[1] = Element.loadImage("dwarf_north_1.gif");
        Player.sprites[2] = Element.loadImage("dwarf_north_3.gif");
        Player.sprites[3] = Element.loadImage("dwarf_north_4.gif");
        Player.sprites[Position.DIRECTION_SOUTH] = Element.loadImage("dwarf_south_2.gif");
        Player.sprites[5] = Element.loadImage("dwarf_south_1.gif");
        Player.sprites[6] = Element.loadImage("dwarf_south_3.gif");
        Player.sprites[7] = Element.loadImage("dwarf_south_4.gif");
        Player.sprites[Position.DIRECTION_EAST] = Element.loadImage("dwarf_east_2.gif");
        Player.sprites[9] = Element.loadImage("dwarf_east_1.gif");
        Player.sprites[10] = Element.loadImage("dwarf_east_3.gif");
        Player.sprites[11] = Element.loadImage("dwarf_east_4.gif");
        Player.sprites[Position.DIRECTION_WEST] = Element.loadImage("dwarf_west_2.gif");
        Player.sprites[13] = Element.loadImage("dwarf_west_1.gif");
        Player.sprites[14] = Element.loadImage("dwarf_west_3.gif");
        Player.sprites[15] = Element.loadImage("dwarf_west_4.gif");
        this.currentSprite = sprites[this.direction + 1];
    }

    public void draw(Graphics g, int viewW, int viewH) {
        if (this.invincibility % 2 == 1) {
            return;
        }
        int x = this.scaleX(viewW);
        int y = this.scaleY(viewH);
        g.setColor(Color.black);
        g.drawOval(x, y, 2, 2);
        if (this.currentSprite != null) {
            Element.drawImage(this.currentSprite, g, x - Element.scaleWidth(viewW, this.width / 2), y - Element.scaleHeight(viewH, this.height / 2), Element.scaleWidth(viewW, this.width), Element.scaleHeight(viewH, this.height));
        }
        if (this.smiting) {
            if (SWING_SOUND != null) {
                SWING_SOUND.play();
            }
            g.setColor(Color.gray);
            g.drawOval(Element.scaleX(viewW, this.facing.getX()) - Element.scaleWidth(viewW, (int)STRIKE_REACH), Element.scaleY(viewH, this.facing.getY()) - Element.scaleHeight(viewH, (int)STRIKE_REACH), Element.scaleWidth(viewW, (int)STRIKE_REACH * 2), Element.scaleHeight(viewH, (int)STRIKE_REACH * 2));
            g.setColor(Color.lightGray);
            g.drawOval(Element.scaleX(viewW, this.facing.getX()) - Element.scaleWidth(viewW, (int)STRIKE_REACH) + 1, Element.scaleY(viewH, this.facing.getY()) - Element.scaleHeight(viewH, (int)STRIKE_REACH) + 1, Element.scaleWidth(viewW, (int)STRIKE_REACH * 2), Element.scaleHeight(viewH, (int)STRIKE_REACH * 2));
        }
    }

    public double getGurth() {
        return this.height / 2;
    }

    public int getDirection() {
        return this.direction;
    }

    public static void getReadyToSmite() {
        readyToSmite = true;
    }

    public void advance(GUI tempGui) {
        if (this.showLevelUpMsg) {
            tempGui.setTextBox(new TextBox(LEVEL_UP));
            this.showLevelUpMsg = false;
        }
        if (!this.controlsEngaged) {
            return;
        }
        if (this.invincibility > 0) {
            --this.invincibility;
        }
        if (this.smiting) {
            this.smiting = false;
        }
        if (GUI.isControlPressed() && readyToSmite) {
            this.smite();
        }
        if (GUI.isControlPressed()) {
            this.currentSprite = sprites[this.direction + STAB_FRAME];
        } else {
            this.handleDirctions(tempGui);
            this.faceDirection();
        }
        Player2 p2 = tempGui.getPlayer2();
        if (this.smiting && Position.distance(this.facing, p2.getPosition()) < STRIKE_REACH + p2.getGurth()) {
            p2.hurt();
        }
    }

    public boolean hasAllCrystals() {
        for (int i = 0; i < this.crystalPouch.length; ++i) {
            if (this.crystalPouch[i]) continue;
            return false;
        }
        return true;
    }

    public boolean hasCystal(int i) {
        return this.crystalPouch[i];
    }

    public void giveCrystal(int i) {
        this.crystalPouch[i] = true;
        this.increaseScore(25);
    }

    public void faceDirection() {
        if (this.direction == Position.DIRECTION_NORTH) {
            this.facing = new Position(this.getPosition().getX(), this.getPosition().getY() - 8.5);
        }
        if (this.direction == Position.DIRECTION_SOUTH) {
            this.facing = new Position(this.getPosition().getX(), this.getPosition().getY() + 8.5);
        }
        if (this.direction == Position.DIRECTION_EAST) {
            this.facing = new Position(this.getPosition().getX() + 7.5, this.getPosition().getY());
        }
        if (this.direction == Position.DIRECTION_WEST) {
            this.facing = new Position(this.getPosition().getX() - 7.5, this.getPosition().getY());
        }
    }

    public Position directlyFacing() {
        return this.facing;
    }

    public int getHealth() {
        return this.health;
    }

    public void hurt() {
        if (this.invincibility <= 0) {
            if (HURT_SOUND != null) {
                HURT_SOUND.play();
            }
            --this.health;
            this.invincibility = HURT_RECOVER;
        }
    }

    public void increaseScore(int i) {
        this.score += i;
        if (this.score >= INC_MAX_HEALTH_SCORE && MAX_HEALTH < 7) {
            ++MAX_HEALTH;
            INC_MAX_HEALTH_SCORE = 2 * INC_MAX_HEALTH_SCORE;
            this.fullHeal();
            this.showLevelUpMsg = true;
        }
    }

    public int getScore() {
        return this.score;
    }

    public void fullHeal() {
        this.health = MAX_HEALTH;
    }

    public boolean isDead() {
        return this.health <= 0;
    }

    public boolean finnished() {
        return this.finnished;
    }

    public void beatGame() {
        this.finnished = true;
    }

    private void flipFrame() {
        int frame = 0;
        this.frameCount.increment(1.5707963267948966);
        frame = this.direction + (int)Math.sin(this.frameCount.get()) + 1;
        this.currentSprite = sprites[frame];
    }

    private void handleDirctions(GUI tempGui) {
        boolean shouldFlip = this.smiting;
        double dx = 0.0;
        double dy = 0.0;
        if (GUI.isUpPressed()) {
            dy = -yStep;
            this.direction = Position.DIRECTION_NORTH;
            shouldFlip = true;
        }
        if (GUI.isLeftPressed()) {
            dx = -xStep;
            this.direction = Position.DIRECTION_WEST;
            shouldFlip = true;
        }
        if (GUI.isRightPressed()) {
            dx = xStep;
            this.direction = Position.DIRECTION_EAST;
            shouldFlip = true;
        }
        if (GUI.isDownPressed()) {
            dy = yStep;
            this.direction = Position.DIRECTION_SOUTH;
            shouldFlip = true;
        }
        if (shouldFlip) {
            this.changePosition(new Position(this.getPosition().getX() + dx, this.getPosition().getY() + dy));
            this.flipFrame();
        } else {
            this.currentSprite = sprites[this.direction + 1];
        }
    }

    private void smite() {
        readyToSmite = false;
        this.smiting = true;
    }

    public void interact(Element e) {
        if (this.smiting && e.isBad() && Position.distance(this.facing, e.getPosition()) < STRIKE_REACH + e.getGurth()) {
            e.delete();
        }
    }

    public void disengageControls() {
        this.controlsEngaged = false;
    }

    public void engageControls() {
        this.controlsEngaged = true;
    }

    public int countCrystals() {
        int count = 0;
        for (int i = 0; i < this.crystalPouch.length; ++i) {
            if (!this.crystalPouch[i]) continue;
            ++count;
        }
        return count;
    }
}

