/*
 * Decompiled with CFR 0.152.
 */
package biege;

import biege.AdventureApp;
import biege.Element;
import biege.GUI;
import biege.Position;
import java.awt.Color;
import java.awt.Graphics;

public class Projectile
extends Element {
    private static int WIDTH = 1;
    private double dx;
    private double dy;
    private double r;
    private Color c;

    public Projectile(Position p, double deltax, double deltay, double radius, Color colour) {
        super(p);
        this.dx = deltax;
        this.dy = deltay;
        this.r = radius;
        this.c = colour;
    }

    public void draw(Graphics g, int viewW, int viewH) {
        g.setColor(this.c);
        g.fillOval(this.scaleX(viewW) - Element.scaleWidth(viewW, (int)this.r / 2), this.scaleY(viewH) - Element.scaleHeight(viewH, (int)this.r / 2), Element.scaleWidth(viewW, (int)this.r), Element.scaleHeight(viewH, (int)this.r));
    }

    public void interact(Element e) {
        if (Position.distance(this.getPosition(), e.getPosition()) < e.getGurth() + this.r) {
            e.hurt();
        }
    }

    public void advance(GUI tempGui) {
        Position current = this.getPosition();
        Position newPos = new Position(current.getX() + this.dx, current.getY() + this.dy);
        this.changePosition(newPos);
        if (this.getPosition().getX() <= (double)AdventureApp.LEFT || this.getPosition().getX() >= (double)AdventureApp.RIGHT || this.getPosition().getY() <= (double)AdventureApp.TOP || this.getPosition().getY() >= (double)AdventureApp.BOTTOM) {
            this.delete();
        }
    }

    public double getGurth() {
        return this.r;
    }

    public void talk(GUI tempGuip) {
    }

    public boolean isSolid() {
        return false;
    }
}

