/*
 * Decompiled with CFR 0.152.
 */
package biege;

import biege.Element;
import biege.GUI;
import biege.Position;
import java.awt.Color;
import java.awt.Graphics;

public class RectangleObstacle
extends Element {
    private int width;
    private int height;
    private Color colour;

    public RectangleObstacle(Position p, int w, int h, Color c) {
        super(p);
        this.width = w;
        this.height = h;
        this.colour = c;
    }

    public void draw(Graphics g, int viewW, int viewH) {
        if (this.colour != null) {
            g.setColor(this.colour);
            g.fillRect(this.scaleX(viewW), this.scaleY(viewH), Element.scaleWidth(viewW, this.width), Element.scaleHeight(viewH, this.height));
        }
    }

    public void interact(Element e) {
        double west = this.getPosition().getX() - e.getGurth();
        double east = this.getPosition().getX() + (double)this.width + e.getGurth();
        double north = this.getPosition().getY() - e.getGurth();
        double south = this.getPosition().getY() + (double)this.height + e.getGurth();
        if (e.isSolid() && Position.isInRectangle(e.getPosition(), new Position(west, north), new Position(east, south))) {
            e.changePosition(Position.closestRectangleIntersection(e.getPosition(), west, north, east, south));
        }
    }

    public void advance(GUI tempGui) {
    }

    public void talk(GUI tempGui) {
    }
}

