package biege;
import java.util.ArrayList;
import java.applet.AudioClip;
import java.awt.Image;

public class AdventureApp extends Object
{
  public static int LEFT = 0;
  public static int RIGHT = 200;
  public static int TOP = 0;
  public static int BOTTOM = 150;
  public static double TALK_RANGE = 8.2;

  private static String[] GAME_OVER = {"", "Game Over", "", ""};
  private static String GAME_OVER_THEME_LOCATION = "file:sound/gameover.wav";

  private static Position PLAYER_START_POSITION = new Position(100,120);

  private GUI theGui;

  private ArrayList content;
  private ArrayList newContent;

  private Player you;
  private Player2 friend;
  private boolean twoPlayer;

  private int xScreen = 0;
  private int yScreen = 1;

  private ToumbStone p1toumb = new ToumbStone(new Position());

  public AdventureApp(GUI caller, boolean player2On)
  {
    super();

     /**** Debug start
    xScreen = 5;
    yScreen = 0;
    //*/

    twoPlayer = player2On;

    System.out.println("Starting new Game...");

    WorldData load = new WorldData();

    theGui = caller;

    you = new Player(PLAYER_START_POSITION);
    friend = new Player2(PLAYER_START_POSITION);

    you.emptyPouch();

    content = WorldData.loadWorld(xScreen,yScreen,you, friend);

    String[] welcome = {"Welcome to Biege the Adventure Game",
                        "Press Ctrl to spear enemies",
                        "Press Space to Talk to the King here and other folk",
                        "Press M to view the world Map", "",
                        "              Press ENTER to close this box"};
    caller.setTextBox(new TextBox(welcome));

  }

  public Player2 getPlayer2()
  {
      return friend;
  }

  public boolean twoPlayer()
  {
    return twoPlayer;
  }

  public Player getPlayer()
  {
    return you;
  }

  public int getPlayerHealth()
  {
    return you.getHealth();
  }

  public int getPlayer2Health()
  {
    return friend.getHealth();
  }

  public void advance()
  {

    //Allocate space for the new list of elements
    newContent = new ArrayList();

    //Loop through all elements
    for (int i = 0; i < content.size(); i++)
    {
      Element temp = (Element)content.get(i);

      //Advance each element (including the player) one discrete step
      temp.advance(theGui);

      //Loop through everyone else
      for (int other = 0; other < content.size(); other++)
      {
        //If its not you then interact!
        if (content.get(other) != temp)
          temp.interact((Element)content.get(other));
      }

      //See if the player should talk to people
      if (theGui.isSpacePressed())
      {
        Element closest = whatPlayerFaces();
        if (closest != null)
          closest.talk(theGui);
      }


      //See if they should be eliminated from the game
      if (!temp.shoulVanish())
        //Then eliminate them
        newContent.add(temp);
      else
          //Call their on death conmmand
          temp.onDeath(theGui);

    }

    //Continue with the new list of contents
    content = newContent;

    //Check to see if you should load a new screen
    checkScreen();

    //Check to see if you should die
    if (you.isDead())
    {
      content.remove(you);
      p1toumb.changePosition(you.getPosition());
      if (!content.contains(p1toumb))
        content.add(p1toumb);
      theGui.setTextBox(new TextBox(GAME_OVER));
      WorldData.changeSong(GAME_OVER_THEME_LOCATION);
    }
  }

  public int getXScreen()
  {
    return xScreen;
  }

  public int getYScreen()
  {
    return yScreen;
  }

  public boolean gameIsOver()
  {
    return (you.isDead() || you.finnished());
  }

  private Element whatPlayerFaces()
  {
    Position centre = you.directlyFacing();
    Element closest = null;

    for (int i = 0; i < content.size(); i++)
    {
      Element temp = (Element)content.get(i);
      if (temp != you && Position.distance(centre, temp.getPosition()) < TALK_RANGE + temp.getGurth())
        closest = temp;
    }
    return closest;
  }//whatPlayerFaces

  private void checkScreen()
  {
    double yourX = you.getPosition().getX();
    double yourY = you.getPosition().getY();
    if (yourX >= RIGHT  && you.getDirection() == Position.DIRECTION_EAST)
    {
      xScreen++;
      you.changePosition(new Position(0, yourY));
      friend.changePosition(you.getPosition());
      Image off = theGui.getView().getBackgroundImage();
      content = WorldData.loadWorld(xScreen, yScreen, you, friend);
      theGui.setTextBox(null);
      if (!theGui.isInMapMode()) theGui.ScrollAround(off, 0, 0, RIGHT, 0, -40, 0, -RIGHT, 0);
    }

    if (yourX <= LEFT  && you.getDirection() == Position.DIRECTION_WEST)
    {
      xScreen--;
      you.changePosition(new Position(RIGHT, yourY));
      friend.changePosition(you.getPosition());
      Image off = theGui.getView().getBackgroundImage();
      content = WorldData.loadWorld(xScreen, yScreen, you, friend);
      theGui.setTextBox(null);
      if (!theGui.isInMapMode()) theGui.ScrollAround(off, 0, 0, -RIGHT, 0, 40, 0, RIGHT, 0);
    }

    if (yourY >= BOTTOM  && you.getDirection() == Position.DIRECTION_SOUTH)
    {
      yScreen++;
      you.changePosition(new Position(yourX, 0));
      friend.changePosition(you.getPosition());
      Image off = theGui.getView().getBackgroundImage();
      content = WorldData.loadWorld(xScreen, yScreen, you, friend);
      theGui.setTextBox(null);
      if (!theGui.isInMapMode()) theGui.ScrollAround(off, 0, 0, 0, BOTTOM, 0, -30, 0, -BOTTOM);
    }

    if (yourY <= TOP  && you.getDirection() == Position.DIRECTION_NORTH)
    {
      yScreen--;
      you.changePosition(new Position(yourX, BOTTOM));
      friend.changePosition(you.getPosition());
      Image off = theGui.getView().getBackgroundImage();
      content = WorldData.loadWorld(xScreen, yScreen, you, friend);
      theGui.setTextBox(null);
      if (!theGui.isInMapMode()) theGui.ScrollAround(off, 0, 0, 0, -BOTTOM, 0, 30, 0, BOTTOM);
    }
    if (!twoPlayer)
     content.remove(friend);

  }

  public ArrayList getGameParts()
  {
    return content;
  }

  public void setScreen(int xs, int ys)
  {
    xScreen = xs;
    yScreen = ys;
    content = WorldData.loadWorld(xScreen, yScreen, you, friend);
    newContent = new ArrayList();
    for (int i = 0; i < content.size(); i++)
      newContent.add(content.get(i));
  }

}
