package biege;
import java.awt.Graphics;
import java.awt.Color;
import java.util.ArrayList;


public class BadEye extends Enemy
{
    private static String YOU_BEAT_IT_SONG = "file:sound/beat.wav";

    private static int RADIUS = 8;
    private int crystalId;
    private int numCrystals;
    private int waveCycleCount;
    private int WAVE_CYCLE_UP = 100;
    private Projectile[] wave = new Projectile[8];

    private boolean invincible = true;

    public BadEye(Position p, int id, int num)
    {
      super(p);
      crystalId = id;
      numCrystals = num;
      waveCycleCount = WAVE_CYCLE_UP;
      makeWave();
    }

    public void advance (GUI tempGui)
    {
      ArrayList tempList = tempGui.getGameParts();
      Element e;

      for (int i = 0; i < wave.length; i++)
      {
        if (!wave[i].shoulVanish())
        wave[i].advance(tempGui);
      }

      if (waveCycleCount >= WAVE_CYCLE_UP)
      {
        makeWave();
        waveCycleCount = 0;
      }
      else
        waveCycleCount++;


      for (int i = 0; i < tempList.size(); i++)
      {
        e = (Element)tempList.get(i);
        if (e.isBad() && e != this)
          return;
      }


      invincible = false;
    }

    public void draw(Graphics g, int viewW, int viewH)
    {

      for (int i = 0; i < wave.length; i++)
      {
        if (!wave[i].shoulVanish())
        wave[i].draw(g, viewW, viewH);
      }

      if (invincible)
        g.setColor(Color.gray);
      else
        g.setColor(Color.white);

      g.fillOval(scaleX(viewW) - Element.scaleWidth(viewW, RADIUS),
                 scaleY(viewH) - Element.scaleHeight(viewH, RADIUS),
                 Element.scaleWidth(viewW, 2 * RADIUS ),Element.scaleHeight(viewH, 2 * RADIUS) );
      g.setColor(Color.black);
      g.fillOval(scaleX(viewW), scaleY(viewH), 3,3);
      g.drawLine(scaleX(viewW) - Element.scaleWidth(viewW, RADIUS),
                 scaleY(viewH) - Element.scaleHeight(viewH, RADIUS),
                 scaleX(viewW) + Element.scaleWidth(viewW, RADIUS ), scaleY(viewH) - Element.scaleHeight(viewH, RADIUS));
    }

    public void interact(Element e)
    {
      for (int i = 0; i < wave.length; i++)
      {
        if (!wave[i].shoulVanish())
        wave[i].interact(e);
      }
    }


    public double getGurth()
    {
      return (double)RADIUS;
    }

    public void delete()
    {
      if (!invincible)
        super.delete();
    }


    public void onDeath(GUI tempGui)
    {
      super.onDeath(tempGui);

      ArrayList tempList = tempGui.getGameParts();
      Element temp;

      int id = crystalId;
      Position p;
      for (int i = 0; i < numCrystals; i++)
      {

        p = new Position (getPosition().getX() + (Math.random() - .5) * 2 * RADIUS,
                          getPosition().getY() + (Math.random() - .5) * 2 * RADIUS);
        tempGui.getGameParts().add(new Crystal(p, id));
        id++;
      }


      WorldData.stopSong();
      WorldData.playSong(YOU_BEAT_IT_SONG);
      tempGui.getGameParts().add(new WarpHome(new Position(0, 0), 10, 150));

      tempGui.getPlayer().increaseScore(990);
    }

    private void makeWave()
    {
        wave[0] = new Projectile(new Position(40, 10), 0, 3.6, 3, Color.black);
        wave[1] = new Projectile(new Position(80, 10), 0, 3.1, 4, Color.blue);
        wave[2] = new Projectile(new Position(120, 10), 0, 2.6, 5, Color.cyan);
        wave[3] = new Projectile(new Position(160, 10), 0, 2.1, 6, Color.white);


        wave[4] = new Projectile(new Position(180, 35),-3.6, 0, 3, Color.black);
        wave[5] = new Projectile(new Position(180, 70), -3.1, 0, 4, Color.blue);
        wave[6] =new Projectile(new Position(180, 105),-2.6, 0, 5, Color.cyan);
        wave[7] =new Projectile(new Position(180, 140), -2.1, 0, 6, Color.white);

    }

    public void talk (GUI tempGui) { }
}