package biege;
import java.awt.Graphics;
import java.awt.Color;


public class DownSpike extends Element
{

    private static int WIDTH = 4;
    private static int HEIGHT = 4;
    private static double DASH_RATE = 14.5;
    private static double WALK_RATE = 8.5;

    private boolean canDash = true;

    public DownSpike(Position p)
    {
      super(p);
    }


    public void draw(Graphics g, int viewW, int viewH)
    {

      int[] xPts = new int[3];
        xPts[0] = scaleX(viewW) - Element.scaleWidth((int)WIDTH/2, viewW);
        xPts[1] = scaleX(viewW) + Element.scaleWidth((int)WIDTH/2, viewW);
        xPts[2] = scaleX(viewW);

      int[] yPts = new int[3];
        yPts[0] = scaleY(viewH) - Element.scaleHeight(HEIGHT, viewH);
        yPts[1] = scaleY(viewH) - Element.scaleHeight(HEIGHT, viewH);
        yPts[2] = scaleY(viewH);

      g.setColor(Color.white);
      g.fillPolygon(xPts, yPts, 3);
      g.setColor(Color.black);
      g.drawPolygon(xPts, yPts, 3);

    }

    public void interact (Element e)
    {
      if (Position.distance(getPosition(), e.getPosition()) < getGurth() + e.getGurth())
        e.hurt();
    }


    public void advance(GUI tempGui)
    {
      double playerX = tempGui.getPlayer().getPosition().getX();
      double playerY = tempGui.getPlayer().getPosition().getY();
      double gurth = tempGui.getPlayer().getGurth();

      if (Math.abs(getPosition().getX() - playerX) <= gurth && playerY > getPosition().getY() && canDash)
        changePosition(Position.calculateNewPosition(getPosition(), new Position(getPosition().getX(), playerY), DASH_RATE));
      else if (getPosition().getY() > HEIGHT)
      {
        changePosition(Position.calculateNewPosition(getPosition(), new Position(getPosition().getX(), HEIGHT), WALK_RATE));
        canDash = false;
      }
      else
        canDash = true;

    }

    public boolean isSolid()
    {
      return false;
    }



}
