package biege;
import java.awt.Graphics;
import java.awt.Color;
import java.applet.AudioClip;


public class Guard extends Folk
{

    private static int WIDTH = 9;
    private static int HEIGHT = 7;

    private int crystalMin;

    public Guard(Position p, int num)
    {
      super(new Position(p.getX() - WIDTH/2, p.getY()-HEIGHT/2), 0);
      crystalMin = num;
    }


    public void talk (GUI tempGui)
    {
      Player p = tempGui.getPlayer();

        String[] msg = {"I shall not let you pass",
                        "until you have at least ", "crystals.", "You only have "};
        msg[1] = msg[1] + crystalMin;
        msg[3] = msg[3] + p.countCrystals() + " crystals.";
        tempGui.setTextBox(new TextBox(msg));
    }


    public double getGurth()
    {
      return (double)WIDTH;
    }

    public void delete()
    {
      super.delete();
    }

    public void interact(Element e)
    {
      super.interact(e);
      if (e.countCrystals() >= crystalMin)
        this.delete();
    }


}