package biege;
import java.awt.*;
import javax.swing.*;
import java.util.ArrayList;

public class PlayAreaView extends JPanel
{
  Color BACKGROUND_COLOUR = new Color(255, 245, 235);
  GUI myGui;
  private static int CROSS_WIDTH = 20;
  private static int CROSS_HEIGHT = 20;
  private static int CROSS_THICK = 8;

  private static Image background;
  private static Image MAP = Element.loadImage("map.gif");

  public PlayAreaView(GUI caller)
  {
    super();
    setBackground(BACKGROUND_COLOUR);

    Toolkit tk = Toolkit.getDefaultToolkit();
    myGui = caller;

  }


  public void paintComponent(Graphics g)
  {

    super.paintComponent(g);
      Element.drawImage(background, g, 0, 0, this.getWidth(), this.getHeight());

      ArrayList everyThing = myGui.getGameParts();

      for (int i = 0; i < everyThing.size(); i++)
        ((Element)everyThing.get(i)).draw(g, this.getWidth(), this.getHeight());


      if (myGui.isInMapMode())
      {
        Element.drawImage(MAP, g, 0, 0, this.getWidth(), this.getHeight());
        double x = ((double)myGui.getXScreen() * 64  +
                    myGui.getPlayer().getPosition().getX() / 200.0 * 64.0) /480 * this.getWidth();
        double y = ((double)myGui.getYScreen() * 48  +
                    myGui.getPlayer().getPosition().getY() / 150.0 * 48.0) /285 * this.getHeight();
        g.setColor(Color.red);
        g.fillOval((int)x, (int)y, 10, 10);
        g.setColor(Color.black);
        g.drawOval((int)x, (int)y, 10, 10);
      }
      else
      {
        for (int cross = 0; cross < myGui.getPlayerHealth(); cross++)
          showRedCross (g, 5 + cross * (CROSS_WIDTH + 5));

        if (myGui.multiplayOn())
        {
          for (int cross = 0; cross < myGui.getPlayer2Health(); cross++)
            showBlueCross (g, 5 + cross * (CROSS_WIDTH + 5));
        }

        g.setColor(Color.black);
        g.drawString("Score: " + myGui.getPlayer().getScore(), 7, getHeight() - CROSS_HEIGHT - 21);
        g.setColor(Color.white);
        g.drawString("Score: " + myGui.getPlayer().getScore(), 8, getHeight() - CROSS_HEIGHT - 20);

        if (myGui.getTextBox() != null)
          myGui.getTextBox().draw(g, getWidth(), getHeight()/4);

      }

  }


  public void showRedCross (Graphics g, int x)
  {
    g.setColor(Color.red);
    int y = getHeight() - CROSS_HEIGHT - 5;
    g.fillRect(x, y + (int)(CROSS_HEIGHT - CROSS_THICK)/2, CROSS_WIDTH, CROSS_THICK);
    g.fillRect(x + (int)(CROSS_WIDTH - CROSS_THICK)/2, y, CROSS_THICK, CROSS_HEIGHT);

  }

  public void showBlueCross (Graphics g, int x)
  {
    g.setColor(Color.blue);
    int y = 5;
    g.fillRect(x, y + (int)(CROSS_HEIGHT - CROSS_THICK)/2, CROSS_WIDTH, CROSS_THICK);
    g.fillRect(x + (int)(CROSS_WIDTH - CROSS_THICK)/2, y, CROSS_THICK, CROSS_HEIGHT);

  }


  public static void setBackgroundImage (Image i)
  {
    background = i;
  }

  public static Image getBackgroundImage ()
  {
    return background;
  }

}
