package biege;
import java.awt.Graphics;
import java.awt.Color;
import java.applet.AudioClip;

public class Spiter extends Enemy
{

    private static int WIDTH = 6;
    private static Color SHOT_COLOUR = Color.orange;
    private static double SHOT_SPEED = 5.0;
    private static double SHOT_RADIUS = 4.2;
    private static AudioClip SPIT_SOUND = Element.loadAudioClip("file:sound/shoot.wav");

    private Projectile shot = null;

    public Spiter(Position p)
    {
      super(p);
    }

    public void draw(Graphics g, int viewW, int viewH)
    {

      g.setColor(Color.gray);
      g.fillOval(scaleX(viewW) - Element.scaleWidth(viewW, WIDTH / 2),
                 scaleY(viewH) - Element.scaleHeight(viewH, WIDTH/2),
                 Element.scaleWidth(viewW, WIDTH),Element.scaleHeight(viewH, WIDTH) );

      if (shot != null)
        shot.draw(g, viewW, viewH);
    }

    public void interact(Element e)
    {
      if (Position.distance(getPosition(), e.getPosition()) < WIDTH + e.getGurth())
        e.hurt();

      if (shot != null)
        shot.interact(e);
    }

    public void advance(GUI tempGui)
    {
       if (shot == null)
       {
        if (SPIT_SOUND != null)
          SPIT_SOUND.play();

        Position shotVector = Position.calculateDirectionVector(getPosition(), tempGui.getPlayer().getPosition());
        shotVector = Position.calculateVelocityVector(shotVector, SHOT_SPEED);
        shot = new Projectile (getPosition(), shotVector.getX(), shotVector.getY(), SHOT_RADIUS, SHOT_COLOUR);
       }
       else if (shot.shoulVanish())
        shot = null;
       else
        shot.advance(tempGui);


    }

    public double getGurth()
    {
      return WIDTH/2;
    }

    public void onDeath(GUI tempGui)
    {
      super.onDeath(tempGui);
      tempGui.getPlayer().increaseScore(15);
    }

    public void talk (GUI tempGui) { }
}
