/*
 * Decompiled with CFR 0.152.
 */
package marauroa.common.game;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.game.Definition;
import marauroa.common.game.DetailLevel;
import marauroa.common.game.LinkedRPObjectList;
import marauroa.common.game.RPClass;
import marauroa.common.game.RPObject;
import marauroa.common.game.SlotIsFullException;
import marauroa.common.game.SlotOwner;
import marauroa.common.net.InputSerializer;
import marauroa.common.net.OutputSerializer;
import marauroa.common.net.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RPSlot
implements Serializable,
Iterable<RPObject>,
Cloneable {
    private static final Logger logger = Log4J.getLogger(RPObject.class);
    private String name = null;
    private SlotOwner owner = null;
    private LinkedRPObjectList objects = new LinkedRPObjectList();
    private int capacity = -1;
    private LinkedRPObjectList added = new LinkedRPObjectList();
    private LinkedRPObjectList deleted = new LinkedRPObjectList();

    public RPSlot() {
    }

    public RPSlot(String string) {
        this();
        this.name = string;
    }

    void setOwner(SlotOwner slotOwner) {
        this.owner = slotOwner;
        if (this.name != null && this.capacity == -1) {
            this.capacity = slotOwner.getRPClass().getDefinition(Definition.DefinitionClass.RPSLOT, this.name).getCapacity();
        }
    }

    protected SlotOwner getOwner() {
        return this.owner;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public int add(RPObject rPObject) {
        return this.add(rPObject, true);
    }

    public int addPreservingId(RPObject rPObject) {
        rPObject.resetAddedAndDeleted();
        return this.add(rPObject, false);
    }

    protected int add(RPObject rPObject, boolean bl) {
        if (this.isFull()) {
            throw new SlotIsFullException(this.name);
        }
        if (bl) {
            this.owner.assignSlotID(rPObject);
        } else if (rPObject.has("id")) {
            this.owner.usedSlotID(rPObject.getInt("id"));
        }
        this.added.add(rPObject);
        this.deleted.remove(rPObject);
        rPObject.setContainer(this.owner, this);
        this.objects.add(rPObject);
        if (bl) {
            rPObject.resetAddedAndDeleted();
        }
        return rPObject.getInt("id");
    }

    public RPObject get(RPObject.ID iD) {
        return this.objects.getByIDIgnoringZone(iD);
    }

    public RPObject getFirst() {
        if (this.objects.isEmpty()) {
            return null;
        }
        return (RPObject)this.objects.get(0);
    }

    public RPObject remove(RPObject.ID iD) {
        if (iD == null) {
            return null;
        }
        int n = iD.getObjectID();
        Iterator iterator = this.objects.iterator();
        while (iterator.hasNext()) {
            RPObject rPObject = (RPObject)iterator.next();
            if (rPObject.getID().getObjectID() != n) continue;
            this.prepareRemove(rPObject);
            iterator.remove();
            return rPObject;
        }
        return null;
    }

    private void prepareRemove(RPObject rPObject) {
        RPObject rPObject2 = this.added.removeByIDIgnoringZone(rPObject.getID());
        if (rPObject2 == null) {
            RPObject rPObject3 = new RPObject();
            rPObject3.setRPClass(rPObject.getRPClass());
            rPObject3.put("id", rPObject.get("id"));
            this.deleted.add(rPObject3);
        }
        rPObject.setContainer(null, null);
    }

    public void clear() {
        Iterator iterator = this.objects.iterator();
        while (iterator.hasNext()) {
            RPObject rPObject = (RPObject)iterator.next();
            this.prepareRemove(rPObject);
            iterator.remove();
        }
        if (!this.added.isEmpty()) {
            throw new IllegalStateException("added list not empty after cleaing rpslot: " + this.toString());
        }
    }

    public boolean has(RPObject.ID iD) {
        return this.objects.hasByIDIgnoringZone(iD);
    }

    public boolean hasAsAncestor(RPObject rPObject) {
        return this.hasAsAncestor((SlotOwner)rPObject);
    }

    public boolean hasAsAncestor(SlotOwner slotOwner) {
        for (SlotOwner slotOwner2 = this.getOwner(); slotOwner2 != null; slotOwner2 = slotOwner2.getContainerOwner()) {
            if (slotOwner2 != slotOwner) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.objects.size();
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int n) {
        this.capacity = n;
    }

    public boolean isFull() {
        return this.size() == this.capacity;
    }

    public boolean isEmpty() {
        return this.objects.isEmpty();
    }

    @Override
    public Iterator<RPObject> iterator() {
        return Collections.unmodifiableList(this.objects).iterator();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof RPSlot) {
            RPSlot rPSlot = (RPSlot)object;
            return this.name.equals(rPSlot.name) && this.objects.equals(rPSlot.objects);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode() * this.objects.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append(" named(" + this.name + ") with capacity(" + this.capacity + ")");
        stringBuilder.append(this.objects);
        return stringBuilder.toString();
    }

    @Override
    public void writeObject(OutputSerializer outputSerializer) throws IOException {
        this.writeObject(outputSerializer, DetailLevel.NORMAL);
    }

    public void writeObject(OutputSerializer outputSerializer, DetailLevel detailLevel) throws IOException {
        RPClass rPClass = this.owner.getRPClass();
        Definition definition = rPClass.getDefinition(Definition.DefinitionClass.RPSLOT, this.name);
        short s = definition.getCode();
        if (detailLevel == DetailLevel.FULL) {
            s = -1;
        }
        outputSerializer.write(s);
        if (s == -1) {
            outputSerializer.write(this.name);
        }
        int n = 0;
        for (RPObject rPObject : this.objects) {
            if (rPObject.isHidden()) continue;
            ++n;
        }
        if (detailLevel == DetailLevel.FULL) {
            n = this.objects.size();
        }
        outputSerializer.write(n);
        for (RPObject rPObject : this.objects) {
            if (detailLevel != DetailLevel.FULL && rPObject.isHidden()) continue;
            rPObject.writeObject(outputSerializer, detailLevel);
        }
    }

    public void writeToJson(StringBuilder stringBuilder, DetailLevel detailLevel) {
        OutputSerializer.writeJson(stringBuilder, this.getName());
        stringBuilder.append(":[");
        boolean bl = true;
        for (RPObject rPObject : this) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(",");
            }
            stringBuilder.append("{");
            rPObject.writeToJson(stringBuilder, detailLevel);
            stringBuilder.append("}");
        }
        stringBuilder.append("]");
    }

    @Override
    public void readObject(InputSerializer inputSerializer) throws IOException {
        short s = inputSerializer.readShort();
        if (s == -1) {
            this.name = inputSerializer.readString();
        } else {
            RPClass rPClass = this.owner.getRPClass();
            this.name = rPClass.getName(Definition.DefinitionClass.RPSLOT, s);
        }
        this.capacity = this.owner.getRPClass().getDefinition(Definition.DefinitionClass.RPSLOT, this.name).getCapacity();
        int n = inputSerializer.readInt();
        if (n > 262144) {
            throw new IOException("Illegal request of an list of " + n + " size");
        }
        this.objects.clear();
        for (int i = 0; i < n; ++i) {
            RPObject rPObject = (RPObject)inputSerializer.readObject(new RPObject());
            rPObject.setContainer(this.owner, this);
            this.objects.add(rPObject);
        }
    }

    public Object clone() {
        RPObject rPObject;
        RPSlot rPSlot = null;
        try {
            rPSlot = (RPSlot)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            logger.error(cloneNotSupportedException, cloneNotSupportedException);
            return null;
        }
        rPSlot.name = this.name;
        rPSlot.owner = this.owner;
        rPSlot.capacity = this.capacity;
        rPSlot.objects = new LinkedRPObjectList();
        for (RPObject rPObject2 : this.objects) {
            rPObject = (RPObject)rPObject2.clone();
            rPObject.setContainer(this.owner, rPSlot);
            rPSlot.objects.addTrusted(rPObject);
        }
        rPSlot.added = new LinkedRPObjectList();
        for (RPObject rPObject2 : this.added) {
            rPObject = (RPObject)rPObject2.clone();
            rPObject.setContainer(this.owner, rPSlot);
            rPSlot.added.addTrusted(rPObject);
        }
        rPSlot.deleted = new LinkedRPObjectList();
        for (RPObject rPObject2 : this.deleted) {
            rPObject = (RPObject)rPObject2.clone();
            rPObject.setContainer(this.owner, rPSlot);
            rPSlot.deleted.addTrusted(rPObject);
        }
        return rPSlot;
    }

    public void resetAddedAndDeletedRPObjects() {
        this.added.clear();
        this.deleted.clear();
    }

    public boolean setAddedRPObject(RPSlot rPSlot) {
        boolean bl = false;
        for (RPObject rPObject : rPSlot.added) {
            RPObject rPObject2 = (RPObject)rPObject.clone();
            rPObject2.setContainer(this.owner, rPSlot);
            this.objects.add(rPObject2);
            bl = true;
        }
        return bl;
    }

    public boolean setDeletedRPObject(RPSlot rPSlot) {
        boolean bl = false;
        for (RPObject rPObject : rPSlot.deleted) {
            RPObject rPObject2 = (RPObject)rPObject.clone();
            rPObject2.setContainer(this.owner, rPSlot);
            this.objects.add(rPObject2);
            bl = true;
        }
        return bl;
    }

    public void clearVisible(boolean bl) {
        Definition definition = this.owner.getRPClass().getDefinition(Definition.DefinitionClass.RPSLOT, this.name);
        if (definition.isVisible()) {
            LinkedList<RPObject> linkedList = new LinkedList<RPObject>();
            for (RPObject rPObject : this.objects) {
                rPObject.clearVisible(bl);
                if (rPObject.size() != 1) continue;
                linkedList.add(rPObject);
            }
            for (RPObject rPObject : linkedList) {
                this.objects.remove(rPObject);
                this.added.remove(rPObject);
                this.deleted.removeByIDIgnoringZone(rPObject.getID());
            }
        }
    }
}

