/*
 * Decompiled with CFR 0.152.
 */
package marauroa.common.game;

import marauroa.common.i18n.I18N;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Result {
    OK_CREATED(true, "Account was created correctly."),
    FAILED_EMPTY_STRING(false, "Account was not created because one of the important parameters was missing."),
    FAILED_INVALID_CHARACTER_USED(false, "Account was not created because an invalid character (special letters, signs, numbers) was used."),
    FAILED_STRING_SIZE(false, "Account was not created because any of the parameters are either too long or too short."),
    FAILED_PLAYER_EXISTS(false, "Account was not created because this account already exists."),
    FAILED_EXCEPTION(false, "Account was not created because there was an unspecified exception."),
    FAILED_CHARACTER_EXISTS(false, "Character was not created because this Character already exists."),
    FAILED_INVALID_TEMPLATE(false, "The template passed to the create character method is not valid because it fails to pass the RP rules."),
    FAILED_STRING_TOO_SHORT(false, "Account was not created because at least one of the parameters was too short."),
    FAILED_STRING_TOO_LONG(false, "Account was not created because at least one of the parameters was too long."),
    FAILED_RESERVED_NAME(false, "Account was not created because the name is reserved (or contains a reserved name)."),
    FAILED_PASSWORD_TOO_CLOSE_TO_USERNAME(false, "Account was not created because the password is too close to the username."),
    FAILED_PASSWORD_TO_WEAK(false, "Account was not created because the password is too weak."),
    FAILED_TOO_MANY(false, "Account was not created because the account creation limit for your network was reached.\nPlease try again later."),
    FAILED_OFFLINE(false, "Creation failed because the server is temporary not available. Please try again later."),
    FAILED_CREATE_ON_MAIN_INSTEAD(false, "Accounts cannot be created on this server. Please create the account on the main server and wait a while.");

    private String text;
    private boolean created;

    private Result(boolean bl, String string2) {
        this.created = bl;
        this.text = string2;
    }

    public boolean failed() {
        return !this.created;
    }

    public String getText() {
        return I18N.translate(this.text, new Object[0]);
    }
}

