/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.db.adapter;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Properties;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.server.db.DatabaseConnectionException;
import marauroa.server.db.StringChecker;
import marauroa.server.db.adapter.AbstractDatabaseAdapter;
import marauroa.server.db.adapter.CreateIndexStatementParser;

public class PostgresDatabaseAdapter
extends AbstractDatabaseAdapter {
    private static Logger logger = Log4J.getLogger(PostgresDatabaseAdapter.class);

    public PostgresDatabaseAdapter(Properties properties) throws DatabaseConnectionException {
        super(properties);
    }

    protected PostgresDatabaseAdapter() throws DatabaseConnectionException {
    }

    protected Connection createConnection(Properties properties) throws SQLException, DatabaseConnectionException {
        Connection connection = super.createConnection(properties);
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        String string = databaseMetaData.getDatabaseProductName();
        if (string.toLowerCase(Locale.ENGLISH).indexOf("postgres") < 0) {
            logger.warn("Using PostgresqlDatabaseAdapter to connect to " + string);
        }
        return connection;
    }

    public boolean doesColumnExist(String string, String string2) throws SQLException {
        DatabaseMetaData databaseMetaData = this.connection.getMetaData();
        ResultSet resultSet = databaseMetaData.getColumns(this.connection.getCatalog(), "%", string.toLowerCase(Locale.ENGLISH), string2.toLowerCase(Locale.ENGLISH));
        boolean bl = resultSet.next();
        resultSet.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doesIndexExist(String string) throws SQLException {
        boolean bl = false;
        String string2 = "SELECT to_regclass('" + StringChecker.escapeSQLString(string) + "')";
        ResultSet resultSet = this.query(string2);
        try {
            resultSet.next();
            bl = resultSet.getString(1) != null;
        }
        finally {
            resultSet.close();
        }
        return bl;
    }

    public int getLastInsertId(String string, String string2) throws SQLException {
        return this.querySingleCellInt("SELECT currval('" + StringChecker.escapeSQLString(string + "_" + string2 + "_seq") + "')");
    }

    protected String rewriteSql(String string) throws SQLException {
        String string2 = string.trim();
        String string3 = string2.toLowerCase(Locale.ENGLISH);
        if (string3.startsWith("alter table")) {
            string2 = this.rewriteSqlAlterTable(string2);
        } else if (string3.startsWith("create table")) {
            string2 = this.rewriteSqlCreateTable(string2);
        } else if (string3.startsWith("create index") || string3.startsWith("create unique index")) {
            string2 = this.rewriteSqlCreateIndex(string2);
        }
        return string2;
    }

    private String rewriteSqlAlterTable(String string) {
        int n;
        String string2 = string;
        String string3 = string.toLowerCase(Locale.ENGLISH);
        if (string3.startsWith("alter table") && (n = string3.indexOf(" column")) > -1) {
            int n2 = string2.indexOf("(", n);
            int n3 = string2.lastIndexOf(")");
            string2 = string2.substring(0, n + 1) + string2.substring(n2 + 1, n3) + ";";
        }
        return string2;
    }

    private String rewriteSqlCreateIndex(String string) throws SQLException {
        CreateIndexStatementParser createIndexStatementParser = new CreateIndexStatementParser(string);
        boolean bl = this.doesIndexExist(createIndexStatementParser.getName());
        if (bl) {
            return "";
        }
        return createIndexStatementParser.toSqlWithoutIf();
    }

    private String rewriteSqlCreateTable(String string) {
        String string2 = "(?i) int(?:eger)?[ ]+auto_increment";
        return string.replaceAll(string2, " SERIAL ").replaceAll("(\\W)blob(\\W)", "$1bytea$2").replaceAll("(\\W)tinyint(\\W)", "$1integer$2");
    }
}

