/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.game.messagehandler;

import marauroa.common.Configuration;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.game.CharacterResult;
import marauroa.common.game.RPObject;
import marauroa.common.game.Result;
import marauroa.common.net.Channel;
import marauroa.common.net.message.Message;
import marauroa.common.net.message.MessageC2SCreateCharacter;
import marauroa.common.net.message.MessageP2SCreateCharacter;
import marauroa.common.net.message.MessageS2CCreateCharacterACK;
import marauroa.common.net.message.MessageS2CCreateCharacterNACK;
import marauroa.server.db.command.DBCommandQueue;
import marauroa.server.game.container.ClientState;
import marauroa.server.game.container.PlayerEntry;
import marauroa.server.game.dbcommand.LoadAllActiveCharactersCommand;
import marauroa.server.game.messagehandler.MessageHandler;
import marauroa.server.game.messagehandler.SendCharacterListHandler;

class CreateCharacterHandler
extends MessageHandler {
    private static final Logger logger = Log4J.getLogger(CreateCharacterHandler.class);

    CreateCharacterHandler() {
    }

    public void process(Message message) {
        try {
            int n = message.getClientID();
            int n2 = message.getProtocolVersion();
            Channel channel = message.getChannel();
            if (message instanceof MessageC2SCreateCharacter) {
                MessageC2SCreateCharacter messageC2SCreateCharacter = (MessageC2SCreateCharacter)message;
                RPObject rPObject = messageC2SCreateCharacter.getTemplate();
                String string = messageC2SCreateCharacter.getCharacter();
                PlayerEntry playerEntry = this.playerContainer.get(n);
                String string2 = messageC2SCreateCharacter.getAddress().getHostAddress();
                if (!this.isValidEvent(messageC2SCreateCharacter, playerEntry, ClientState.GAME_BEGIN, ClientState.LOGIN_COMPLETE)) {
                    logger.warn("invalid create character event (client unknown, not logged in or wrong ip-address)");
                    return;
                }
                int n3 = Configuration.getConfiguration().getInt("limit_characters_per_account", Integer.MAX_VALUE);
                if (playerEntry.characterCounter >= n3) {
                    Result result = Result.FAILED_TOO_MANY;
                    MessageS2CCreateCharacterNACK messageS2CCreateCharacterNACK = new MessageS2CCreateCharacterNACK(channel, string, result);
                    messageS2CCreateCharacterNACK.setClientID(n);
                    messageS2CCreateCharacterNACK.setProtocolVersion(n2);
                    this.netMan.sendMessage(messageS2CCreateCharacterNACK);
                    return;
                }
                this.createCharacter(playerEntry.username, string, rPObject, n, string2, channel, n2, true);
            } else {
                MessageP2SCreateCharacter messageP2SCreateCharacter = (MessageP2SCreateCharacter)message;
                RPObject rPObject = messageP2SCreateCharacter.getTemplate();
                String string = messageP2SCreateCharacter.getCharacter();
                String string3 = messageP2SCreateCharacter.getForwardedFor();
                if (messageP2SCreateCharacter.getCredentials() != null && messageP2SCreateCharacter.getCredentials().equals(Configuration.getConfiguration().get("proxy_credentials"))) {
                    this.createCharacter(messageP2SCreateCharacter.getUsername(), string, rPObject, n, string3, channel, n2, false);
                } else {
                    logger.warn("Invalid credentials for proxy method.");
                }
            }
        }
        catch (Exception exception) {
            logger.error("Unable to create a character", exception);
        }
    }

    private void createCharacter(String string, String string2, RPObject rPObject, int n, String string3, Channel channel, int n2, boolean bl) {
        CharacterResult characterResult = this.rpMan.createCharacter(string, string2, rPObject, string3);
        Result result = characterResult.getResult();
        if (result == Result.OK_CREATED) {
            logger.debug("Character (" + string2 + ") created for account " + string);
            MessageS2CCreateCharacterACK messageS2CCreateCharacterACK = new MessageS2CCreateCharacterACK(channel, characterResult.getCharacter(), characterResult.getTemplate());
            messageS2CCreateCharacterACK.setClientID(n);
            messageS2CCreateCharacterACK.setProtocolVersion(n2);
            this.netMan.sendMessage(messageS2CCreateCharacterACK);
            if (bl) {
                LoadAllActiveCharactersCommand loadAllActiveCharactersCommand = new LoadAllActiveCharactersCommand(string, new SendCharacterListHandler(this.netMan, n2), n, channel, n2);
                DBCommandQueue.get().enqueue(loadAllActiveCharactersCommand);
            }
        } else {
            MessageS2CCreateCharacterNACK messageS2CCreateCharacterNACK = new MessageS2CCreateCharacterNACK(channel, string2, result);
            messageS2CCreateCharacterNACK.setClientID(n);
            messageS2CCreateCharacterNACK.setProtocolVersion(n2);
            this.netMan.sendMessage(messageS2CCreateCharacterNACK);
        }
    }
}

