/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.game.messagehandler;

import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.net.Channel;
import marauroa.server.game.container.ClientState;
import marauroa.server.game.container.PlayerEntry;
import marauroa.server.game.container.PlayerEntryContainer;
import marauroa.server.game.messagehandler.DelayedEventHandler;
import marauroa.server.game.rp.RPServerManager;

public class DisconnectHandler
implements DelayedEventHandler {
    private static final Logger logger = Log4J.getLogger(DisconnectHandler.class);
    private PlayerEntryContainer playerContainer = PlayerEntryContainer.getContainer();

    public void handleDelayedEvent(RPServerManager rPServerManager, Object object) {
        Channel channel = (Channel)object;
        this.playerContainer.getLock().requestWriteLock();
        PlayerEntry playerEntry = this.playerContainer.get(channel);
        if (playerEntry != null) {
            if (this.playerContainer.remove(playerEntry.clientid) == null) {
                return;
            }
            if (playerEntry.state == ClientState.GAME_BEGIN) {
                try {
                    rPServerManager.onTimeout(playerEntry.object);
                    playerEntry.storeRPObject(playerEntry.object);
                }
                catch (Exception exception) {
                    logger.error("Error disconnecting player" + playerEntry, exception);
                }
            }
            playerEntry.state = ClientState.LOGOUT_ACCEPTED;
        } else {
            logger.debug("No player entry for channel: " + channel);
        }
        this.playerContainer.getLock().releaseLock();
    }
}

