/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.net.nio;

import java.io.IOException;
import java.util.Properties;
import marauroa.common.Configuration;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.server.net.INetworkServerManager;
import marauroa.server.net.flood.FloodMeasure;
import marauroa.server.net.flood.IFloodCheck;

public class FloodCheck
implements IFloodCheck {
    private static final Logger logger = Log4J.getLogger(FloodCheck.class);
    private INetworkServerManager netMan;
    private int allowedBytesPerSecond = 1024;
    private int allowedMessagesPerSecond = 20;

    public FloodCheck(INetworkServerManager iNetworkServerManager) {
        this.netMan = iNetworkServerManager;
        try {
            Properties properties = Configuration.getConfiguration().getAsProperties();
            this.allowedBytesPerSecond = Integer.parseInt(properties.getProperty("allowed_bytes_per_second", "1024"));
            this.allowedMessagesPerSecond = Integer.parseInt(properties.getProperty("allowed_messages_per_second", "20"));
        }
        catch (IOException iOException) {
            logger.error(iOException, iOException);
        }
    }

    public boolean isFlooding(FloodMeasure floodMeasure) {
        if (floodMeasure.getBytesPerSecond() > this.allowedBytesPerSecond || floodMeasure.getMessagesPerSecond() > this.allowedMessagesPerSecond) {
            floodMeasure.warning();
        }
        if (floodMeasure.sinceLastReset() > 60) {
            floodMeasure.resetPerSecondData();
        }
        return floodMeasure.getWarnings() >= 3;
    }

    public void onFlood(FloodMeasure floodMeasure) {
        if (floodMeasure.getBytesPerSecond() > 2048 || floodMeasure.getMessagesPerSecond() > 24) {
            logger.warn("Banning " + floodMeasure.channel + " for flooding server: " + floodMeasure);
            this.netMan.getValidator().addBan(floodMeasure.channel, 600);
        } else if (floodMeasure.getBytesPerSecond() > 1024) {
            logger.info("Disconnecting " + floodMeasure.channel + " for flooding server: " + floodMeasure);
            this.netMan.disconnectClient(floodMeasure.channel);
        } else {
            logger.info("Giving another chance to " + floodMeasure.channel + " for flooding server: " + floodMeasure);
            floodMeasure.resetWarnings();
        }
    }
}

