/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui;

import games.stendhal.client.GameObjects;
import games.stendhal.client.entity.ContentChangeListener;
import games.stendhal.client.entity.IEntity;
import games.stendhal.client.entity.Inspector;
import games.stendhal.client.entity.User;
import games.stendhal.client.entity.factory.EntityMap;
import games.stendhal.client.gui.Inspectable;
import games.stendhal.client.gui.InternalManagedWindow;
import games.stendhal.client.gui.ItemPanel;
import games.stendhal.client.gui.layout.SBoxLayout;
import games.stendhal.client.sprite.SpriteStore;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import marauroa.common.game.RPObject;
import marauroa.common.game.RPSlot;
import org.apache.log4j.Logger;

class Character
extends InternalManagedWindow
implements ContentChangeListener,
Inspectable {
    private static final long serialVersionUID = -5585214190674481472L;
    private static final int PADDING = 1;
    private static final int HAND_YSHIFT = 10;
    private static final Logger logger = Logger.getLogger(Character.class);
    private final Map<String, ItemPanel> slotPanels = new HashMap<String, ItemPanel>();
    private User player;
    private JComponent specialSlots;

    public Character() {
        super("character", "Character");
        this.createLayout();
        this.setCloseable(false);
    }

    public void setPlayer(User user) {
        this.player = user;
        user.addContentChangeListener(this);
        if (user.getRPObject().hasSlot("belt")) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Character.this.specialSlots.setVisible(true);
                }
            });
        }
        this.refreshContents();
    }

    private void createLayout() {
        JComponent jComponent = SBoxLayout.createContainer(false, 1);
        JComponent jComponent2 = SBoxLayout.createContainer(true, 1);
        JComponent jComponent3 = SBoxLayout.createContainer(false, 1);
        JComponent jComponent4 = SBoxLayout.createContainer(false, 1);
        JComponent jComponent5 = SBoxLayout.createContainer(false, 1);
        jComponent3.setAlignmentY(0.5f);
        jComponent5.setAlignmentY(0.5f);
        jComponent2.add(jComponent3);
        jComponent2.add(jComponent4);
        jComponent2.add(jComponent5);
        jComponent.add(jComponent2);
        Class<? extends IEntity> clazz = EntityMap.getClass("item", null, null);
        SpriteStore spriteStore = SpriteStore.get();
        jComponent3.add(Box.createVerticalStrut(20));
        ItemPanel itemPanel = this.createItemPanel(clazz, spriteStore, "rhand", "data/gui/weapon-slot.png");
        jComponent3.add(itemPanel);
        itemPanel = this.createItemPanel(clazz, spriteStore, "finger", "data/gui/ring-slot.png");
        jComponent3.add(itemPanel);
        itemPanel = this.createItemPanel(clazz, spriteStore, "head", "data/gui/helmet-slot.png");
        jComponent4.add(itemPanel);
        itemPanel = this.createItemPanel(clazz, spriteStore, "armor", "data/gui/armor-slot.png");
        jComponent4.add(itemPanel);
        itemPanel = this.createItemPanel(clazz, spriteStore, "legs", "data/gui/legs-slot.png");
        jComponent4.add(itemPanel);
        itemPanel = this.createItemPanel(clazz, spriteStore, "feet", "data/gui/boots-slot.png");
        jComponent4.add(itemPanel);
        jComponent5.add(Box.createVerticalStrut(20));
        itemPanel = this.createItemPanel(clazz, spriteStore, "lhand", "data/gui/shield-slot.png");
        jComponent5.add(itemPanel);
        itemPanel = this.createItemPanel(clazz, spriteStore, "cloak", "data/gui/cloak-slot.png");
        jComponent5.add(itemPanel);
        this.specialSlots = SBoxLayout.createContainer(true, 1);
        this.specialSlots.setAlignmentX(0.5f);
        this.specialSlots.setVisible(false);
        jComponent.add(this.specialSlots);
        itemPanel = this.createItemPanel(clazz, spriteStore, "back", "data/gui/bag-slot.png");
        this.specialSlots.add(itemPanel);
        itemPanel = this.createItemPanel(clazz, spriteStore, "belt", "data/gui/key-slot.png");
        this.specialSlots.add(itemPanel);
        this.setContent(jComponent);
    }

    private ItemPanel createItemPanel(Class<? extends IEntity> clazz, SpriteStore spriteStore, String string, String string2) {
        ItemPanel itemPanel = new ItemPanel(string, spriteStore.getSprite(string2));
        this.slotPanels.put(string, itemPanel);
        itemPanel.setAcceptedTypes(clazz);
        return itemPanel;
    }

    private void refreshContents() {
        for (Map.Entry<String, ItemPanel> entry : this.slotPanels.entrySet()) {
            ItemPanel itemPanel = entry.getValue();
            if (itemPanel == null) continue;
            itemPanel.setParent(this.player);
            RPSlot rPSlot = this.player.getSlot(entry.getKey());
            if (rPSlot == null) continue;
            Iterator iterator = rPSlot.iterator();
            if (iterator.hasNext()) {
                RPObject rPObject = (RPObject)iterator.next();
                IEntity iEntity = GameObjects.getInstance().get(rPObject);
                itemPanel.setEntity(iEntity);
                continue;
            }
            itemPanel.setEntity(null);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Character.this.setTitle(Character.this.player.getName());
            }
        });
    }

    @Override
    public void contentAdded(RPSlot rPSlot) {
        ItemPanel itemPanel = this.slotPanels.get(rPSlot.getName());
        if (itemPanel == null) {
            return;
        }
        String string = rPSlot.getName();
        if (("belt".equals(string) || "back".equals(string)) && !this.player.getRPObject().hasSlot(string)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Character.this.specialSlots.setVisible(true);
                }
            });
        }
        for (RPObject rPObject : rPSlot) {
            RPObject.ID iD = rPObject.getID();
            IEntity iEntity = itemPanel.getEntity();
            if (iEntity != null && iD.equals((Object)iEntity.getRPObject().getID())) {
                return;
            }
            iEntity = GameObjects.getInstance().get(rPObject);
            if (iEntity == null) {
                logger.error((Object)("Unable to find entity for: " + rPObject), new Throwable("here"));
                return;
            }
            itemPanel.setEntity(iEntity);
        }
    }

    @Override
    public void contentRemoved(RPSlot rPSlot) {
        ItemPanel itemPanel = this.slotPanels.get(rPSlot.getName());
        if (itemPanel == null) {
            return;
        }
        for (RPObject rPObject : rPSlot) {
            RPObject.ID iD = rPObject.getID();
            IEntity iEntity = itemPanel.getEntity();
            if (iEntity != null && iD.equals((Object)iEntity.getRPObject().getID())) {
                if (rPObject.size() != 1) continue;
                itemPanel.setEntity(null);
                continue;
            }
            logger.error((Object)("Tried removing wrong object from a panel. removing: " + rPObject + " , but panel contains: " + itemPanel.getEntity()), new Throwable());
        }
    }

    @Override
    public void setInspector(Inspector inspector) {
        for (ItemPanel itemPanel : this.slotPanels.values()) {
            itemPanel.setInspector(inspector);
        }
    }
}

