/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui;

import games.stendhal.client.GameScreen;
import games.stendhal.client.gui.j2d.BackgroundPainter;
import games.stendhal.client.gui.j2d.TextBoxFactory;
import games.stendhal.client.listener.PositionChangeListener;
import games.stendhal.client.sprite.Sprite;
import games.stendhal.common.NotificationType;
import java.awt.Color;
import javax.swing.SwingUtilities;

class ScreenController
implements PositionChangeListener {
    private static final int BUBBLE_TEXT_WIDTH = 240;
    private static final String TUTORIAL_BACKGROUND = "data/gui/tutorial_background.png";
    private static final int TUTORIAL_LEFT_TILE_WIDTH = 48;
    private static final int TUTORIAL_CENTER_TILE_WIDTH = 8;
    private static final int TUTORIAL_TOP_TILE_HEIGHT = 32;
    private static final int TUTORIAL_CENTER_TILE_HEIGHT = 8;
    private final GameScreen screen;
    private final Runnable nextFrameRunner = new NextFrameRunner();
    private TextBoxFactory textBoxFactory;

    ScreenController(GameScreen gameScreen) {
        this.screen = gameScreen;
    }

    void addText(final double d, final double d2, String string, NotificationType notificationType, boolean bl) {
        final Sprite sprite = this.createTextBox(string, notificationType, bl);
        final int n = string.length();
        if (!bl) {
            final int n2 = this.getPriority(notificationType);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ScreenController.this.screen.addStaticText(sprite, n, n2);
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ScreenController.this.screen.addTextBox(sprite, d, d2, n);
                }
            });
        }
    }

    private int getPriority(NotificationType notificationType) {
        switch (notificationType) {
            case TUTORIAL: {
                return 1;
            }
            case SUPPORT: {
                return 2;
            }
        }
        return 0;
    }

    void nextFrame() {
        SwingUtilities.invokeLater(this.nextFrameRunner);
    }

    void setOffline(final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ScreenController.this.screen.setOffline(bl);
            }
        });
    }

    @Override
    public void positionChanged(final double d, final double d2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ScreenController.this.screen.positionChanged(d, d2);
            }
        });
    }

    private Sprite createTextBox(String string, NotificationType notificationType, boolean bl) {
        if (notificationType == NotificationType.TUTORIAL) {
            BackgroundPainter backgroundPainter = new BackgroundPainter(TUTORIAL_BACKGROUND, 48, 8, 32, 8);
            return this.getTextFactory().createFancyTextBox(string, notificationType.getColor(), 240, 45, 6, 6, 6, backgroundPainter);
        }
        return this.getTextFactory().createTextBox(string, 240, notificationType.getColor(), Color.white, bl);
    }

    private TextBoxFactory getTextFactory() {
        if (this.textBoxFactory == null) {
            this.textBoxFactory = new TextBoxFactory();
        }
        return this.textBoxFactory;
    }

    private final class NextFrameRunner
    implements Runnable {
        private NextFrameRunner() {
        }

        @Override
        public void run() {
            ScreenController.this.screen.nextFrame();
        }
    }
}

