/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.buddies;

import games.stendhal.client.gui.buddies.Buddy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;
import org.apache.log4j.Logger;

class BuddyListModel
extends AbstractListModel<Buddy> {
    private final List<Buddy> buddyList = new ArrayList<Buddy>();
    private final Map<String, Buddy> buddyMap = new HashMap<String, Buddy>();

    BuddyListModel() {
    }

    @Override
    public Buddy getElementAt(int n) {
        return this.buddyList.get(n);
    }

    @Override
    public int getSize() {
        return this.buddyList.size();
    }

    void setOnline(String string, boolean bl) {
        if (string == null) {
            Logger.getLogger(BuddyListModel.class).error((Object)("Buddy with no name set " + (bl ? "online" : "offline")));
            return;
        }
        Buddy buddy = this.buddyMap.get(string);
        if (buddy == null) {
            buddy = new Buddy(string);
            buddy.setOnline(bl);
            this.buddyList.add(buddy);
            this.buddyMap.put(string, buddy);
            Collections.sort(this.buddyList);
            int n = this.buddyList.indexOf(buddy);
            this.fireIntervalAdded(this, n, n);
        } else {
            int n = this.buddyList.indexOf(buddy);
            boolean bl2 = buddy.setOnline(bl);
            Collections.sort(this.buddyList);
            int n2 = this.buddyList.indexOf(buddy);
            if (bl2) {
                this.fireContentsChanged(this, n, n2);
            }
        }
    }

    void removeBuddy(String string) {
        Buddy buddy = this.buddyMap.get(string);
        if (buddy != null) {
            this.buddyMap.remove(string);
            int n = this.buddyList.indexOf(buddy);
            this.buddyList.remove(buddy);
            this.fireIntervalRemoved(this, n, n);
        }
    }
}

