/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.j2d.entity;

import games.stendhal.client.ZoneInfo;
import games.stendhal.client.entity.ActionType;
import games.stendhal.client.entity.ActiveEntity;
import games.stendhal.client.entity.DomesticAnimal;
import games.stendhal.client.gui.j2d.entity.NPC2DView;
import games.stendhal.client.sprite.Sprite;
import games.stendhal.client.sprite.SpriteStore;
import games.stendhal.common.Direction;
import java.util.Map;

abstract class DomesticAnimal2DView<T extends DomesticAnimal>
extends NPC2DView<T> {
    private static final String STATE_BIG_DOWN = "big:move_down";
    private static final String STATE_BIG_UP = "big:move_up";
    private static final String STATE_BIG_LEFT = "big:move_left";
    private static final String STATE_BIG_RIGHT = "big:move_right";

    DomesticAnimal2DView() {
    }

    @Override
    protected Sprite getSprite(Object object) {
        if (((DomesticAnimal)this.entity).getWeight() < this.getBigWeight()) {
            return super.getSprite(object);
        }
        switch (((ActiveEntity)this.entity).getDirection()) {
            case LEFT: {
                return (Sprite)this.sprites.get(STATE_BIG_LEFT);
            }
            case RIGHT: {
                return (Sprite)this.sprites.get(STATE_BIG_RIGHT);
            }
            case UP: {
                return (Sprite)this.sprites.get(STATE_BIG_UP);
            }
            case DOWN: {
                return (Sprite)this.sprites.get(STATE_BIG_DOWN);
            }
        }
        return (Sprite)this.sprites.get(STATE_BIG_DOWN);
    }

    protected abstract int getBigWeight();

    @Override
    protected void buildSprites(Map<Object, Sprite> map, Sprite sprite, int n, int n2) {
        int n3 = 0;
        map.put((Object)Direction.UP, this.createWalkSprite(sprite, n3, n, n2));
        map.put((Object)Direction.RIGHT, this.createWalkSprite(sprite, n3 += n2, n, n2));
        map.put((Object)Direction.DOWN, this.createWalkSprite(sprite, n3 += n2, n, n2));
        map.put((Object)Direction.LEFT, this.createWalkSprite(sprite, n3 += n2, n, n2));
        map.put(STATE_BIG_UP, this.createWalkSprite(sprite, n3 += n2, n, n2));
        map.put(STATE_BIG_RIGHT, this.createWalkSprite(sprite, n3 += n2, n, n2));
        map.put(STATE_BIG_DOWN, this.createWalkSprite(sprite, n3 += n2, n, n2));
        map.put(STATE_BIG_LEFT, this.createWalkSprite(sprite, n3 += n2, n, n2));
    }

    @Override
    protected Sprite getAnimationSprite() {
        ZoneInfo zoneInfo = ZoneInfo.get();
        return SpriteStore.get().getModifiedSprite(this.translate(((DomesticAnimal)this.entity).getType()), zoneInfo.getZoneColor(), zoneInfo.getColorMethod());
    }

    @Override
    protected int getTilesY() {
        return 8;
    }

    @Override
    void entityChanged(Object object) {
        super.entityChanged(object);
        if (object == DomesticAnimal.PROP_WEIGHT) {
            this.proceedChangedState(this.entity);
        }
    }

    @Override
    public void onAction(ActionType actionType) {
        if (this.isReleased()) {
            return;
        }
        switch (actionType) {
            case OWN: {
                actionType.send(actionType.fillTargetInfo(this.entity));
                break;
            }
            default: {
                super.onAction(actionType);
            }
        }
    }
}

