/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.j2d.entity;

import games.stendhal.client.ZoneInfo;
import games.stendhal.client.entity.ActionType;
import games.stendhal.client.entity.Door;
import games.stendhal.client.entity.IEntity;
import games.stendhal.client.gui.j2d.entity.StateEntity2DView;
import games.stendhal.client.gui.styled.cursor.StendhalCursor;
import games.stendhal.client.sprite.Sprite;
import games.stendhal.client.sprite.SpriteStore;
import java.util.List;
import java.util.Map;

class Door2DView
extends StateEntity2DView<Door> {
    private static final String STATE_CLOSED = "close";
    private static final String STATE_OPEN = "open";
    private int width = 32;
    private int height = 32;

    @Override
    protected void buildSprites(Door door, Map<Object, Sprite> map) {
        String string = door.getEntityClass();
        SpriteStore spriteStore = SpriteStore.get();
        if (string == null) {
            this.width = 32;
            this.height = 32;
            Sprite sprite = spriteStore.getEmptySprite(this.width, this.height);
            map.put(STATE_OPEN, sprite);
            map.put(STATE_CLOSED, sprite);
        } else {
            ZoneInfo zoneInfo = ZoneInfo.get();
            Sprite sprite = spriteStore.getModifiedSprite(this.translate(string), zoneInfo.getZoneColor(), zoneInfo.getColorMethod());
            this.width = sprite.getWidth();
            this.height = sprite.getHeight() / 2;
            map.put(STATE_OPEN, spriteStore.getTile(sprite, 0, 0, this.width, this.height));
            map.put(STATE_CLOSED, spriteStore.getTile(sprite, 0, this.height, this.width, this.height));
        }
        this.calculateOffset(door, this.width, this.height);
    }

    @Override
    protected Object getState(Door door) {
        if (door.isOpen()) {
            return STATE_OPEN;
        }
        return STATE_CLOSED;
    }

    @Override
    protected void buildActions(List<String> list) {
        super.buildActions(list);
        list.add(ActionType.USE.getRepresentation());
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getZIndex() {
        return 5000;
    }

    @Override
    protected String translate(String string) {
        return "data/sprites/doors/" + string + ".png";
    }

    @Override
    void entityChanged(Object object) {
        super.entityChanged(object);
        if (object == IEntity.PROP_CLASS) {
            this.representationChanged = true;
        } else if (object == Door.PROP_OPEN) {
            this.proceedChangedState(this.entity);
        }
    }

    @Override
    public void onAction(ActionType actionType) {
        if (this.isReleased()) {
            return;
        }
        switch (actionType) {
            case USE: {
                actionType.send(actionType.fillTargetInfo(this.entity));
                break;
            }
            default: {
                super.onAction(actionType);
            }
        }
    }

    @Override
    public boolean isInteractive() {
        return ((Door)this.entity).isUseable();
    }

    @Override
    public StendhalCursor getCursor() {
        if (this.isInteractive()) {
            return StendhalCursor.ACTIVITY;
        }
        return StendhalCursor.PORTAL;
    }
}

