/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.sound.system;

import games.stendhal.client.sound.facade.Time;
import games.stendhal.client.sound.system.SignalProcessor;
import games.stendhal.common.math.Dsp;
import games.stendhal.common.memory.Field;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import org.apache.log4j.Logger;

public class SoundSystem
extends Thread {
    private static final int STATE_EXITING = 0;
    private static final int STATE_RUNNING = 1;
    private static final int STATE_PAUSING = 2;
    private static final Time ZERO_DURATION = new Time();
    private static final Logger logger = Logger.getLogger(SoundSystem.class);
    private final LinkedList<SystemOutput> mSystemOutputs = new LinkedList();
    private final LinkedList<MixerOutput> mMixerOutputs = new LinkedList();
    private SystemOutput mMixSystemOutput = null;
    private Mixer mSystemMixer = null;
    private Time mBufferDuration = null;
    private final AtomicBoolean mUseDynamicLoadScaling = new AtomicBoolean(false);
    private final AtomicReference<Time> mStateChangeDelay = new AtomicReference<Time>(ZERO_DURATION);
    private final AtomicInteger mTargetSystemState = new AtomicInteger(0);
    private int mCurrentSystemState = 0;
    private int mMaxNumLines = 0;
    private float[] mMixBuffer = null;

    public SoundSystem(Mixer mixer, AudioFormat audioFormat, Time time, int n) {
        if (audioFormat == null) {
            throw new IllegalArgumentException("audioFormat argument must not be null");
        }
        if (time == null) {
            throw new IllegalArgumentException("bufferDuration argument must not be null");
        }
        if (mixer == null) {
            logger.info((Object)"opening sound system and trying to find optimal system mixer device / output line");
            mixer = SoundSystem.tryToFindMixer(audioFormat);
        } else {
            logger.info((Object)"opening sound system using specified system mixer device");
        }
        this.init(mixer, audioFormat, time, n);
    }

    public SoundSystem(SourceDataLine sourceDataLine, Time time) {
        if (sourceDataLine == null) {
            throw new IllegalArgumentException("outputLine argument must not be null");
        }
        if (time == null) {
            throw new IllegalArgumentException("bufferDuration argument must not be null");
        }
        logger.info((Object)"opening sound system with only manual mixing enabled");
        this.mBufferDuration = time;
        this.mMaxNumLines = 0;
        if (!sourceDataLine.isOpen()) {
            try {
                sourceDataLine.open();
            }
            catch (LineUnavailableException lineUnavailableException) {
                logger.warn((Object)("cannot open output line for manual mixing of audio data: \"" + lineUnavailableException + "\""));
                return;
            }
            catch (SecurityException securityException) {
                logger.warn((Object)("cannot open output line for manual mixing of audio data: \"" + securityException + "\""));
                return;
            }
        }
        this.mMixSystemOutput = new SystemOutput(sourceDataLine);
    }

    public void suspend(Time time) {
        this.changeSystemState(2, time);
    }

    public void proceed(Time time) {
        this.changeSystemState(1, time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Output openOutput(AudioFormat audioFormat) {
        if (audioFormat == null) {
            throw new IllegalArgumentException("audioFormat argument must not be null");
        }
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat, -1);
        if (this.mSystemMixer != null && this.mSystemMixer.isLineSupported(info) && this.mSystemOutputs.size() < this.mMaxNumLines) {
            try {
                SourceDataLine sourceDataLine = (SourceDataLine)this.mSystemMixer.getLine(info);
                sourceDataLine.open();
                SystemOutput systemOutput = new SystemOutput(sourceDataLine);
                LinkedList<SystemOutput> linkedList = this.mSystemOutputs;
                synchronized (linkedList) {
                    this.mSystemOutputs.add(systemOutput);
                }
                logger.debug((Object)"opening a system output (using a system mixer device)");
                return systemOutput;
            }
            catch (LineUnavailableException lineUnavailableException) {
                // empty catch block
            }
        }
        if (this.mMixSystemOutput != null) {
            MixerOutput mixerOutput = new MixerOutput(this.mMixSystemOutput.getAudioFormat());
            LinkedList<MixerOutput> linkedList = this.mMixerOutputs;
            synchronized (linkedList) {
                this.mMixerOutputs.add(mixerOutput);
            }
            logger.debug((Object)"opening a mixer output (using manual mixing)");
            return mixerOutput;
        }
        logger.debug((Object)"opening a dummy output (no output line could be received)");
        return new DummyOutput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeOutput(Output output) {
        if (output != null) {
            Output output2;
            output.disconnect();
            LinkedList<Output> linkedList = this.mSystemOutputs;
            synchronized (linkedList) {
                if (output instanceof SystemOutput) {
                    logger.debug((Object)"closing a system output");
                    output2 = (SystemOutput)output;
                    output2.close();
                    this.mSystemOutputs.remove(output2);
                }
            }
            linkedList = this.mMixerOutputs;
            synchronized (linkedList) {
                if (output instanceof MixerOutput) {
                    logger.debug((Object)"closing a mixer output");
                    output2 = (MixerOutput)output;
                    this.mMixerOutputs.remove(output2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllOutputs() {
        logger.debug((Object)"closing all outputs excluding the output for manual mixing");
        LinkedList<Output> linkedList = this.mSystemOutputs;
        synchronized (linkedList) {
            for (SystemOutput systemOutput : this.mSystemOutputs) {
                systemOutput.close();
            }
            this.mSystemOutputs.clear();
        }
        linkedList = this.mMixerOutputs;
        synchronized (linkedList) {
            this.mMixerOutputs.clear();
        }
    }

    public void exit(Time time) {
        logger.info((Object)"stopping sound system");
        this.changeSystemState(0, time);
    }

    @Override
    public void run() {
        double d = 0.0;
        double d2 = 0.995;
        class StateChanger {
            long mSystemTime = 0L;
            boolean mChangeState = false;

            StateChanger() {
            }

            void processStateChange() {
                if (!this.mChangeState) {
                    if (SoundSystem.this.mCurrentSystemState != SoundSystem.this.mTargetSystemState.get()) {
                        if (((Time)SoundSystem.this.mStateChangeDelay.get()).getInNanoSeconds() <= 0L) {
                            SoundSystem.this.mCurrentSystemState = SoundSystem.this.mTargetSystemState.get();
                            return;
                        }
                        this.mSystemTime = System.nanoTime();
                        this.mChangeState = true;
                    }
                } else if (System.nanoTime() - this.mSystemTime >= ((Time)SoundSystem.this.mStateChangeDelay.get()).getInNanoSeconds()) {
                    SoundSystem.this.mCurrentSystemState = SoundSystem.this.mTargetSystemState.get();
                    this.mChangeState = false;
                }
            }
        }
        StateChanger stateChanger = new StateChanger();
        this.mCurrentSystemState = 1;
        this.mTargetSystemState.set(1);
        this.mStateChangeDelay.set(ZERO_DURATION);
        block4: while (this.mCurrentSystemState != 0) {
            stateChanger.processStateChange();
            switch (this.mCurrentSystemState) {
                case 1: {
                    long l = System.nanoTime();
                    this.processOutputs();
                    if (!this.mUseDynamicLoadScaling.get()) continue block4;
                    l = System.nanoTime() - l;
                    if ((d = (d + (double)l) / 2.0) > (double)this.mBufferDuration.getInNanoSeconds()) {
                        d = this.mBufferDuration.getInNanoSeconds();
                    }
                    long l2 = (long)(((double)this.mBufferDuration.getInNanoSeconds() - d) * d2);
                    this.suspendThread(l2);
                    break;
                }
                case 2: {
                    this.suspendThread(50L);
                }
            }
        }
        this.closeAllOutputs();
        this.closeOutput(this.mMixSystemOutput);
    }

    private void changeSystemState(int n, Time time) {
        time = time == null ? ZERO_DURATION : time.clone();
        this.mStateChangeDelay.set(time);
        this.mTargetSystemState.set(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processOutputs() {
        LinkedList linkedList;
        LinkedList linkedList2;
        Object object = this.mSystemOutputs;
        synchronized (object) {
            linkedList2 = (LinkedList)this.mSystemOutputs.clone();
        }
        object = this.mMixerOutputs;
        synchronized (object) {
            linkedList = (LinkedList)this.mMixerOutputs.clone();
        }
        if (this.mMixSystemOutput != null) {
            linkedList2.add(this.mMixSystemOutput);
        }
        for (Iterator iterator : linkedList2) {
            int n = ((SystemOutput)((Object)iterator)).getSampleRate();
            int n2 = ((SystemOutput)((Object)iterator)).getAudioFormat().getSampleSizeInBits() / 8;
            int n3 = ((SystemOutput)((Object)iterator)).getNumChannels();
            int n4 = (int)(this.mBufferDuration.getInSamples(n) * (double)n3 * (double)n2);
            ((SystemOutput)((Object)iterator)).setNumBytesToWrite(n4);
        }
        if (this.mMixSystemOutput != null) {
            int n = this.mMixSystemOutput.getNumBytesToWrite() / this.mMixSystemOutput.getNumBytesPerSample();
            this.mMixBuffer = Field.expand(this.mMixBuffer, n, false);
            Arrays.fill(this.mMixBuffer, 0, n, 0.0f);
            for (MixerOutput mixerOutput : linkedList) {
                mixerOutput.mix(this.mMixBuffer, n);
            }
            this.mMixSystemOutput.setBuffer(this.mMixBuffer, n);
        }
        while (!linkedList2.isEmpty()) {
            Iterator iterator;
            boolean bl = true;
            iterator = linkedList2.iterator();
            while (iterator.hasNext()) {
                SystemOutput systemOutput = (SystemOutput)iterator.next();
                if (systemOutput.isOpen()) {
                    if (!systemOutput.receivedData()) {
                        systemOutput.request();
                    }
                    if (systemOutput.receivedData()) {
                        if (!systemOutput.isConverted()) {
                            systemOutput.convert();
                        }
                        boolean bl2 = bl = bl && systemOutput.available() == 0;
                        if (systemOutput.write(1000)) continue;
                    }
                }
                iterator.remove();
            }
            if (!bl || this.mUseDynamicLoadScaling.get()) continue;
            this.suspendThread(50L);
        }
    }

    private void init(Mixer mixer, AudioFormat audioFormat, Time time, int n) {
        SourceDataLine sourceDataLine;
        DataLine.Info info;
        this.mSystemMixer = mixer;
        this.mBufferDuration = time;
        this.mMixSystemOutput = null;
        if (this.mSystemMixer != null) {
            info = new DataLine.Info(SourceDataLine.class, audioFormat, -1);
            try {
                sourceDataLine = (SourceDataLine)this.mSystemMixer.getLine(info);
                sourceDataLine.open();
                this.mMixSystemOutput = new SystemOutput(sourceDataLine);
                this.mMaxNumLines = this.mSystemMixer.getMaxLines(info);
                this.mMaxNumLines = this.mMaxNumLines == -1 ? Integer.MAX_VALUE : this.mMaxNumLines;
                this.mMaxNumLines = Math.min(n, this.mMaxNumLines - 1);
            }
            catch (LineUnavailableException lineUnavailableException) {
                logger.warn((Object)("cannot open output line of system mixer device: \"" + lineUnavailableException + "\""));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                logger.warn((Object)("cannot open output line of system mixer device: \"" + illegalArgumentException + "\""));
            }
            catch (SecurityException securityException) {
                logger.warn((Object)("cannot open output line of system mixer device: \"" + securityException + "\""));
            }
        }
        if (this.mSystemMixer == null) {
            logger.info((Object)"try to open a common output line");
            info = new DataLine.Info(SourceDataLine.class, audioFormat, -1);
            try {
                sourceDataLine = (SourceDataLine)AudioSystem.getLine(info);
                sourceDataLine.open();
                this.mMixSystemOutput = new SystemOutput(sourceDataLine);
                this.mMaxNumLines = 0;
            }
            catch (LineUnavailableException lineUnavailableException) {
                logger.warn((Object)("cannot open common output line for manual mixing of audio data: \"" + lineUnavailableException + "\""));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                logger.warn((Object)("cannot open common output line for manual mixing of audio data: \"" + illegalArgumentException + "\""));
            }
            catch (SecurityException securityException) {
                logger.warn((Object)("cannot open common output line for manual mixing of audio data: \"" + securityException + "\""));
            }
        }
        if (this.mSystemMixer == null && this.mMixSystemOutput == null) {
            this.mMaxNumLines = 0;
        }
    }

    private void suspendThread(long l) {
        try {
            long l2 = l / Time.Unit.MILLI.getNanos();
            SoundSystem.sleep(l2, (int)(l %= Time.Unit.MILLI.getNanos()));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static Mixer tryToFindMixer(AudioFormat audioFormat) {
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        Mixer[] mixerArray = new Mixer[infoArray.length];
        final DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
        if (mixerArray.length == 0) {
            return null;
        }
        for (int i = 0; i < infoArray.length; ++i) {
            mixerArray[i] = AudioSystem.getMixer(infoArray[i]);
        }
        Arrays.sort(mixerArray, new Comparator<Mixer>(){

            @Override
            public int compare(Mixer mixer, Mixer mixer2) {
                int n = mixer.getMaxLines(info);
                int n2 = mixer2.getMaxLines(info);
                if (n == -1 || n > n2) {
                    return -1;
                }
                return 1;
            }
        });
        if (mixerArray[0].getMaxLines(info) == 0) {
            return null;
        }
        return mixerArray[0];
    }

    private static class MixerOutput
    extends Output {
        AudioFormat mAudioFormat;
        float[] mAudioBuffer = null;
        int mNumSamples = 0;
        int mNumSamplesMixed = 0;

        MixerOutput(AudioFormat audioFormat) {
            assert (audioFormat != null);
            this.mAudioFormat = audioFormat;
        }

        boolean receivedData() {
            return this.mNumSamples > 0;
        }

        int getNumChannels() {
            return this.mAudioFormat.getChannels();
        }

        int getSampleRate() {
            return (int)this.mAudioFormat.getSampleRate();
        }

        void reset() {
            this.mNumSamples = 0;
            this.mNumSamplesMixed = 0;
        }

        void setBuffer(float[] fArray, int n) {
            assert (fArray == null || n <= fArray.length);
            assert (n % this.getNumChannels() == 0);
            this.mAudioBuffer = fArray;
            this.mNumSamples = n;
        }

        boolean mix(float[] fArray, int n) {
            int n2;
            int n3 = 0;
            for (int i = n; i > 0; i -= n2) {
                if (!this.receivedData()) {
                    this.request();
                }
                if (!this.receivedData()) {
                    return false;
                }
                n2 = this.mNumSamples - this.mNumSamplesMixed;
                n2 = Math.min(n2, i);
                Dsp.mixAudioData(fArray, n3, this.mAudioBuffer, this.mNumSamplesMixed, n2, 1.0f);
                n3 += n2;
                this.mNumSamplesMixed += n2;
                if (this.mNumSamples != this.mNumSamplesMixed) continue;
                this.reset();
            }
            return true;
        }

        @Override
        protected void modify(float[] fArray, int n, int n2, int n3) {
            if (fArray != null && n > 0 && n2 > 0 && n3 > 0) {
                assert (n * n2 <= fArray.length);
                fArray = Dsp.convertChannels(fArray, n, n2, this.getNumChannels());
                this.setBuffer(fArray, n * this.getNumChannels());
                fArray = Dsp.convertSampleRate(fArray, n * n2, n2, n3, this.getSampleRate());
                float f = (float)n / (float)n3;
                this.setBuffer(fArray, (int)(f * (float)this.getSampleRate() * (float)n2));
            } else {
                this.setBuffer(null, 0);
            }
        }
    }

    private static class SystemOutput
    extends Output {
        final SourceDataLine mLine;
        final AudioFormat mFormat;
        float[] mAudioBuffer = null;
        int mNumSamples = 0;
        byte[] mPCMBuffer = null;
        int mPCMBufferSize = 0;
        int mNumBytesWritten = 0;
        int mNumBytesToWrite = 0;

        SystemOutput(SourceDataLine sourceDataLine) {
            assert (sourceDataLine != null);
            assert (sourceDataLine.isOpen());
            this.mLine = sourceDataLine;
            this.mFormat = sourceDataLine.getFormat();
            this.mLine.start();
        }

        boolean isOpen() {
            return this.mLine.isOpen();
        }

        boolean receivedData() {
            return this.mNumSamples > 0;
        }

        boolean isConverted() {
            return this.mPCMBufferSize > 0;
        }

        AudioFormat getAudioFormat() {
            return this.mFormat;
        }

        int getNumChannels() {
            return this.mFormat.getChannels();
        }

        int getSampleRate() {
            return (int)this.mFormat.getSampleRate();
        }

        int getNumBytesPerSample() {
            return this.mFormat.getSampleSizeInBits() / 8;
        }

        int available() {
            return this.mLine.available();
        }

        int getNumBytesToWrite() {
            return this.mNumBytesToWrite;
        }

        void close() {
            this.mLine.close();
            this.mAudioBuffer = null;
            this.mPCMBuffer = null;
            this.reset();
        }

        void reset() {
            this.mNumBytesWritten = 0;
            this.mNumSamples = 0;
            this.mPCMBufferSize = 0;
        }

        void setBuffer(float[] fArray, int n) {
            assert (fArray == null || n <= fArray.length);
            assert (n % this.getNumChannels() == 0);
            this.mAudioBuffer = fArray;
            this.mNumSamples = n;
        }

        void setNumBytesToWrite(int n) {
            int n2 = this.getNumBytesPerSample() * this.getNumChannels();
            this.mNumBytesToWrite = n;
            this.mNumBytesToWrite /= n2;
            this.mNumBytesToWrite *= n2;
        }

        void convert() {
            assert (this.mLine.getFormat().getSampleSizeInBits() % 8 == 0);
            int n = this.getNumBytesPerSample();
            int n2 = n * this.mNumSamples;
            this.mPCMBuffer = Field.expand(this.mPCMBuffer, n2, false);
            this.mPCMBuffer = Dsp.convertUniformPCM(this.mPCMBuffer, this.mAudioBuffer, this.mNumSamples, n);
            this.mPCMBufferSize = n2;
        }

        boolean write(int n) {
            int n2 = this.getNumBytesPerSample() * this.getNumChannels();
            int n3 = this.mPCMBufferSize - this.mNumBytesWritten;
            n = Math.min(n, n3);
            n = Math.min(n, this.mNumBytesToWrite);
            n = Math.min(n, this.mLine.available());
            n /= n2;
            n *= n2;
            n = this.mLine.write(this.mPCMBuffer, this.mNumBytesWritten, n);
            this.mNumBytesWritten += n;
            this.mNumBytesToWrite -= n;
            if ((n3 -= n) < n2) {
                this.reset();
            }
            return this.mNumBytesToWrite >= n2;
        }

        @Override
        protected void modify(float[] fArray, int n, int n2, int n3) {
            if (fArray != null && n > 0 && n2 > 0 && n3 > 0) {
                assert (n * n2 <= fArray.length);
                fArray = Dsp.convertChannels(fArray, n, n2, this.getNumChannels());
                this.setBuffer(fArray, n * this.getNumChannels());
                fArray = Dsp.convertSampleRate(fArray, n * n2, n2, n3, this.getSampleRate());
                float f = (float)n / (float)n3;
                this.setBuffer(fArray, (int)(f * (float)this.getSampleRate() * (float)n2));
            } else {
                this.setBuffer(null, 0);
            }
        }
    }

    private static class DummyOutput
    extends Output {
        private DummyOutput() {
        }
    }

    public static abstract class Output
    extends SignalProcessor {
    }
}

