/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.common.parser;

import games.stendhal.common.ErrorDrain;
import games.stendhal.common.parser.ExpressionMatcher;
import games.stendhal.common.parser.ExpressionType;
import games.stendhal.common.parser.SimilarExprMatcher;
import java.util.regex.Pattern;

public final class Expression {
    public static final Expression EMPTY_EXPRESSION = new Expression("", "");
    public static final String JOKER = "*";
    private String original;
    private ExpressionType type;
    private String normalized = "";
    private String mainWord;
    private Integer amount;
    private boolean breakFlag = false;
    private ExpressionMatcher matcher = null;

    Expression(String string) {
        this.original = string;
    }

    public Expression(String string, String string2) {
        this.original = string;
        this.normalized = string;
        this.mainWord = string;
        this.type = new ExpressionType(string2);
    }

    public void parseAmount(String string, ErrorDrain errorDrain) {
        try {
            String string2 = string.replace(',', '.');
            this.setAmount((int)Math.round(Double.parseDouble(string2)));
            this.setType(new ExpressionType("NUM"));
            this.normalized = this.amount.toString();
        }
        catch (NumberFormatException numberFormatException) {
            errorDrain.setError("illegal number format: '" + string + "'");
        }
    }

    public void mergeSimple(Expression expression) {
        this.mergeType(expression.getType());
        this.setAmount(Expression.mergeAmount(expression.amount, this.amount));
    }

    public void mergeLeft(Expression expression, boolean bl) {
        this.original = expression.getOriginal() + ' ' + this.original;
        if (bl) {
            this.normalized = expression.getNormalized() + ' ' + this.normalized;
        }
        this.mergeType(expression.getType());
        this.setAmount(Expression.mergeAmount(expression.amount, this.amount));
    }

    public void mergeRight(Expression expression, boolean bl) {
        this.original = this.original + ' ' + expression.getOriginal();
        if (bl) {
            this.normalized = this.normalized + ' ' + expression.getNormalized();
        }
        this.mergeType(expression.getType());
        this.setAmount(Expression.mergeAmount(this.amount, expression.amount));
        this.breakFlag = expression.getBreakFlag();
    }

    private static Integer mergeAmount(Integer n, Integer n2) {
        if (n != null) {
            if (n2 != null) {
                if (n <= n2) {
                    return n * n2;
                }
                return n + n2;
            }
            return n;
        }
        return n2;
    }

    public void mergeName(Expression expression, ExpressionType expressionType) {
        this.original = this.original + ' ' + expression.getOriginal();
        if (expressionType.isName()) {
            this.setNormalized(this.original.toLowerCase());
        } else {
            this.setNormalized(this.normalized + ' ' + expression.getNormalized());
        }
        this.setType(expressionType);
        this.setAmount(Expression.mergeAmount(this.amount, expression.amount));
        this.breakFlag = expression.getBreakFlag();
    }

    public void setAmount(Integer n) {
        this.amount = n;
    }

    public int getAmount() {
        if (this.amount == null) {
            return 1;
        }
        return this.amount;
    }

    public boolean hasAmount() {
        return this.amount != null;
    }

    public long getAmountLong() {
        if (this.amount == null) {
            return 1L;
        }
        return this.amount.intValue();
    }

    public void setBreakFlag() {
        this.breakFlag = true;
    }

    public void setMatcher(ExpressionMatcher expressionMatcher) {
        this.matcher = expressionMatcher;
    }

    public ExpressionMatcher getMatcher() {
        return this.matcher;
    }

    public String getOriginal() {
        return this.original;
    }

    public void setNormalized(String string) {
        this.normalized = string;
        this.mainWord = string;
    }

    public String getNormalized() {
        return this.normalized;
    }

    public String getMainWord() {
        if (this.mainWord == null) {
            return "";
        }
        return this.mainWord;
    }

    public boolean getBreakFlag() {
        return this.breakFlag;
    }

    public void setType(ExpressionType expressionType) {
        this.type = expressionType;
    }

    public ExpressionType getType() {
        return this.type;
    }

    public String getTypeString() {
        if (this.type == null) {
            return "";
        }
        return this.type.getTypeString();
    }

    public boolean isVerb() {
        return this.type != null && this.type.isVerb();
    }

    public boolean isObject() {
        return this.type != null && this.type.isObject();
    }

    public boolean isSubject() {
        return this.type != null && this.type.isSubject();
    }

    public boolean isNegated() {
        return this.type != null && this.type.isNegated();
    }

    public boolean isIgnore() {
        return this.type != null && this.type.isIgnore();
    }

    public boolean isQuestion() {
        return this.type != null && this.type.isQuestion();
    }

    public boolean isPreposition() {
        return this.type != null && this.type.isPreposition();
    }

    public boolean isNumeral() {
        return this.type != null && this.type.isNumeral();
    }

    public boolean isDynamic() {
        return this.type != null && this.type.isDynamic();
    }

    public void mergeType(ExpressionType expressionType) {
        if (this.type != null) {
            if (expressionType != null) {
                this.type = this.type.merge(expressionType);
                if (expressionType.isNegated()) {
                    this.negateStrings();
                }
            }
        } else {
            this.type = expressionType;
        }
    }

    public String getNormalizedWithTypeString() {
        return this.normalized + "/" + this.getTypeString();
    }

    public boolean matches(Expression expression) {
        if (expression != null) {
            if (expression.matcher == null) {
                if (this.original.equals(expression.original)) {
                    return true;
                }
            } else {
                if (this.matcher != null && !this.matcher.equals(expression.matcher)) {
                    return false;
                }
                return expression.matcher.match(this, expression);
            }
        }
        return false;
    }

    public boolean matchesNormalized(Expression expression) {
        if (expression != null) {
            if (expression.matcher == null) {
                if (this.getNormalized().equals(expression.getNormalized())) {
                    return true;
                }
            } else {
                if (this.matcher != null && !this.matcher.equals(expression.matcher)) {
                    return false;
                }
                return expression.matcher.match(this, expression);
            }
        }
        return false;
    }

    public boolean matchesNormalizedSimilar(Expression expression) {
        if (expression != null && expression.matcher == null) {
            if (SimilarExprMatcher.isSimilar(this.getNormalized(), expression.getNormalized(), 0.1)) {
                return true;
            }
            if (SimilarExprMatcher.isSimilar(this.getMainWord(), expression.getMainWord(), 0.1)) {
                return true;
            }
        }
        return false;
    }

    boolean sentenceMatchExpression(Expression expression) {
        String string = expression.getNormalized();
        if (string.contains(JOKER)) {
            if (string.equals(JOKER) ? !Expression.matchesJokerString(this.getTypeString(), expression.getTypeString()) : !Expression.matchesJokerString(this.getNormalized(), string)) {
                return false;
            }
        } else {
            if (expression.getMatcher() != null) {
                return this.original.equals(expression.original);
            }
            if (!this.matchesNormalized(expression)) {
                return false;
            }
        }
        return true;
    }

    public static boolean matchesJokerString(String string, String string2) {
        if (string.equals(JOKER)) {
            return string.length() > 0;
        }
        return Pattern.compile(string2.replace(JOKER, ".*")).matcher(string).find();
    }

    public void negate() {
        this.type = this.getType().negate();
        this.negateStrings();
    }

    private void negateStrings() {
        if (this.type.isNegated()) {
            this.original = this.original + " not";
            this.normalized = this.normalized + " not";
        } else {
            this.original = this.original.replaceFirst(" not", "");
            this.normalized = this.normalized.replaceFirst(" not", "");
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() == Expression.class) {
            Expression expression = (Expression)object;
            if (this.matcher != null ? expression.matcher == null || !this.matcher.equals(expression.matcher) : expression.matcher != null) {
                return false;
            }
            if (this.normalized.length() > 0) {
                return this.normalized.equals(expression.normalized);
            }
            return this.original.equals(expression.original);
        }
        return false;
    }

    public int hashCode() {
        int n = this.normalized.length() > 0 ? this.normalized.hashCode() : this.original.hashCode();
        if (this.matcher != null) {
            n ^= this.matcher.hashCode();
        }
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.matcher != null) {
            stringBuilder.append(this.matcher.toString());
            stringBuilder.append("|");
        }
        if (this.normalized.length() > 0) {
            stringBuilder.append(this.normalized);
        } else {
            stringBuilder.append(this.original);
        }
        return stringBuilder.toString();
    }
}

