/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.common.parser;

import games.stendhal.common.ErrorBuffer;
import games.stendhal.common.parser.ConvCtxForMatchingSource;
import games.stendhal.common.parser.ConversationContext;
import games.stendhal.common.parser.ConversationParser;
import games.stendhal.common.parser.Expression;
import games.stendhal.common.parser.ExpressionMatcher;
import games.stendhal.common.parser.NameSearch;
import games.stendhal.common.parser.SentenceBuilder;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class Sentence
extends ErrorBuffer
implements Iterable<Expression> {
    protected String originalText;
    protected final ConversationContext context;
    protected SentenceType sentenceType = SentenceType.UNDEFINED;
    protected AbstractList<Expression> expressions = new ArrayList<Expression>();

    protected Sentence(ConversationContext conversationContext) {
        this.context = conversationContext;
    }

    void setType(SentenceType sentenceType) {
        this.sentenceType = sentenceType;
    }

    public SentenceType getType() {
        return this.sentenceType;
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    protected Expression[] getExpressionsArrayList() {
        return this.expressions.toArray(new Expression[this.expressions.size()]);
    }

    @Override
    public Iterator<Expression> iterator() {
        return this.expressions.iterator();
    }

    private int countExpressions(String string) {
        int n = 0;
        for (Expression expression : this.expressions) {
            if (!expression.getTypeString().startsWith(string)) continue;
            ++n;
        }
        return n;
    }

    public Expression getExpression(int n, String string) {
        int n2 = 0;
        for (Expression expression : this.expressions) {
            if (!expression.getTypeString().startsWith(string)) continue;
            if (n2 == n) {
                return expression;
            }
            ++n2;
        }
        return null;
    }

    public int getUnknownTypeCount() {
        int n = 0;
        for (Expression expression : this.expressions) {
            if (expression.getTypeString().length() != 0) continue;
            ++n;
        }
        return n;
    }

    public Expression getUnknownTypeExpression(int n) {
        int n2 = 0;
        for (Expression expression : this.expressions) {
            if (expression.getTypeString().length() != 0) continue;
            if (n2 == n) {
                return expression;
            }
            ++n2;
        }
        return null;
    }

    public Expression getTriggerExpression() {
        if (this.expressions.isEmpty()) {
            return Expression.EMPTY_EXPRESSION;
        }
        if (this.expressions.size() > 1) {
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            for (Expression expression : this.expressions) {
                if (!expression.isObject() || expression.getAmount() != 1) break;
                if (n > 0) {
                    stringBuilder.append(" and ");
                }
                stringBuilder.append(expression.getNormalized());
                ++n;
            }
            if (n == this.expressions.size()) {
                return new Expression(stringBuilder.toString(), "OBJ");
            }
        }
        return this.expressions.get(0);
    }

    public int getVerbCount() {
        return this.countExpressions("VER");
    }

    public Expression getVerb(int n) {
        return this.getExpression(n, "VER");
    }

    public Expression getVerb() {
        Expression expression = null;
        for (Expression expression2 : this.expressions) {
            if (!expression2.isVerb()) continue;
            if (expression == null) {
                expression = expression2;
                continue;
            }
            return null;
        }
        return expression;
    }

    public String getVerbString() {
        String string = null;
        for (Expression expression : this.expressions) {
            if (!expression.isVerb()) continue;
            if (string == null) {
                string = expression.getNormalized();
                continue;
            }
            return null;
        }
        return string;
    }

    public int getSubjectCount() {
        return this.countExpressions("SUB");
    }

    public Expression getSubject(int n) {
        return this.getExpression(n, "SUB");
    }

    public String getSubjectName() {
        String string = null;
        for (Expression expression : this.expressions) {
            if (!expression.isSubject()) continue;
            if (string == null) {
                string = expression.getNormalized();
                continue;
            }
            return null;
        }
        return string;
    }

    public int getObjectCount() {
        return this.countExpressions("OBJ");
    }

    public Expression getObject(int n) {
        return this.getExpression(n, "OBJ");
    }

    public String getObjectName() {
        String string = null;
        for (Expression expression : this.expressions) {
            if (!expression.isObject()) continue;
            if (string == null) {
                string = expression.getNormalized();
                continue;
            }
            return null;
        }
        return string;
    }

    public String getObjectName(int n) {
        return this.getObject(n).getNormalized();
    }

    public int getPrepositionCount() {
        return this.countExpressions("PRE");
    }

    public Expression getPreposition(int n) {
        return this.getExpression(n, "PRE");
    }

    public int getNumeralCount() {
        return this.countExpressions("NUM");
    }

    public Expression getNumeral(int n) {
        return this.getExpression(n, "NUM");
    }

    public Expression getNumeral() {
        Expression expression = null;
        for (Expression expression2 : this.expressions) {
            if (!expression2.isNumeral()) continue;
            if (expression == null) {
                expression = expression2;
                continue;
            }
            return null;
        }
        return expression;
    }

    public boolean isEmpty() {
        return this.sentenceType == SentenceType.UNDEFINED && this.expressions.isEmpty();
    }

    public String getTrimmedText() {
        SentenceBuilder sentenceBuilder = new SentenceBuilder();
        for (Expression expression : this.expressions) {
            sentenceBuilder.append(expression.getOriginal());
        }
        this.appendPunctation(sentenceBuilder);
        return sentenceBuilder.toString();
    }

    public String getOriginalText() {
        return this.originalText;
    }

    public String getNormalized() {
        SentenceBuilder sentenceBuilder = new SentenceBuilder();
        for (Expression expression : this.expressions) {
            if (expression.getType() != null && this.isIgnorable(expression)) continue;
            sentenceBuilder.append(expression.getNormalized());
        }
        this.appendPunctation(sentenceBuilder);
        return sentenceBuilder.toString();
    }

    public ExpressionMatcher getMatcher() {
        if (!this.expressions.isEmpty()) {
            return this.expressions.get(0).getMatcher();
        }
        return null;
    }

    public Sentence parse(ConversationContext conversationContext) {
        if (this.context.equals(conversationContext)) {
            return this;
        }
        return ConversationParser.parse(this.originalText, conversationContext);
    }

    public Sentence parseAsMatchingSource() {
        return this.parse(new ConvCtxForMatchingSource());
    }

    protected boolean isIgnorable(Expression expression) {
        return this.context.getIgnoreIgnorable() && expression.isIgnore();
    }

    public String toString() {
        SentenceBuilder sentenceBuilder = new SentenceBuilder();
        for (Expression object2 : this.expressions) {
            if (object2.getType() != null) {
                if (!this.isIgnorable(object2)) {
                    sentenceBuilder.append(object2.getNormalizedWithTypeString());
                }
            } else {
                sentenceBuilder.append(object2.getOriginal());
            }
            if (!object2.getBreakFlag()) continue;
            sentenceBuilder.append(',');
        }
        this.appendPunctation(sentenceBuilder);
        Object object3 = sentenceBuilder.toString();
        ExpressionMatcher expressionMatcher = this.getMatcher();
        if (expressionMatcher != null) {
            object3 = expressionMatcher.toString() + "|" + (String)object3;
        }
        return object3;
    }

    protected void appendPunctation(SentenceBuilder sentenceBuilder) {
        if (this.sentenceType == SentenceType.STATEMENT) {
            sentenceBuilder.append('.');
        } else if (this.sentenceType == SentenceType.IMPERATIVE) {
            sentenceBuilder.append('!');
        } else if (this.sentenceType == SentenceType.QUESTION) {
            sentenceBuilder.append('?');
        }
    }

    public boolean equalsNormalized(Sentence sentence) {
        if (sentence == this) {
            return true;
        }
        if (sentence == null) {
            return false;
        }
        if (this.expressions.size() != sentence.expressions.size()) {
            return false;
        }
        Iterator<Expression> iterator = this.expressions.iterator();
        Iterator<Expression> iterator2 = sentence.expressions.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            Expression expression;
            Expression expression2 = iterator.next();
            if (expression2.matchesNormalized(expression = iterator2.next())) continue;
            return false;
        }
        return !iterator.hasNext() && !iterator2.hasNext();
    }

    public String diffNormalized(Sentence sentence) {
        SentenceBuilder sentenceBuilder = new SentenceBuilder();
        Iterator<Expression> iterator = this.expressions.iterator();
        Iterator<Expression> iterator2 = sentence.expressions.iterator();
        while (true) {
            Expression expression = this.nextValid(iterator);
            Expression expression2 = this.nextValid(iterator2);
            if (expression == null && expression2 == null) break;
            if (expression != null && expression2 != null) {
                if (expression.matchesNormalized(expression2)) continue;
                sentenceBuilder.append("-[" + expression.getNormalized() + "]");
                sentenceBuilder.append("+[" + expression2.getNormalized() + "]");
                continue;
            }
            if (expression != null) {
                sentenceBuilder.append("-[" + expression.getNormalized() + "]");
                continue;
            }
            sentenceBuilder.append("+[" + expression2.getNormalized() + "]");
        }
        return sentenceBuilder.toString();
    }

    public Expression nextValid(Iterator<Expression> iterator) {
        while (iterator.hasNext()) {
            Expression expression = iterator.next();
            if (this.isIgnorable(expression)) continue;
            return expression;
        }
        return null;
    }

    public boolean matchesNormalized(String string) {
        return this.matchesFull(ConversationParser.parseAsMatcher(string));
    }

    public boolean matchesNormalizedStart(String string) {
        return this.matchesStart(ConversationParser.parseAsMatcher(string));
    }

    public boolean matchesStartNormalized(String string) {
        return ConversationParser.parseAsMatcher(string).matchesStart(this);
    }

    public boolean matchesFull(Sentence sentence) {
        return this.matches(sentence, false);
    }

    public boolean matchesStart(Sentence sentence) {
        return this.matches(sentence, true);
    }

    private boolean matches(Sentence sentence, boolean bl) {
        Expression expression;
        Expression expression2;
        block3: {
            if (sentence == null) {
                return false;
            }
            Iterator<Expression> iterator = this.expressions.iterator();
            Iterator<Expression> iterator2 = sentence.expressions.iterator();
            do {
                expression = this.nextValid(iterator);
                expression2 = this.nextValid(iterator2);
                if (expression == null || expression2 == null) break block3;
            } while (!(expression2.getMatcher() != null ? !expression2.getMatcher().match(expression, expression2) : !expression.sentenceMatchExpression(expression2)));
            return false;
        }
        if (expression == null && expression2 == null) {
            return true;
        }
        return bl && expression2 == null;
    }

    public NameSearch findMatchingName(Set<String> set) {
        NameSearch nameSearch = new NameSearch(set);
        Expression expression = this.getObject(0);
        if (expression != null && nameSearch.search(expression)) {
            return nameSearch;
        }
        if (!nameSearch.found() && (expression = this.getSubject(0)) != null && nameSearch.search(expression)) {
            return nameSearch;
        }
        if (!nameSearch.found() && (expression = this.getSubject(1)) != null && nameSearch.search(expression)) {
            return nameSearch;
        }
        if (!nameSearch.found() && (expression = this.getUnknownTypeExpression(0)) != null) {
            Expression expression2;
            if (!expression.hasAmount() && (expression2 = this.getNumeral(0)) != null) {
                expression.setAmount(expression2.getAmount());
            }
            if (nameSearch.search(expression)) {
                return nameSearch;
            }
        }
        return nameSearch;
    }

    public String getExpressionStringAfterVerb() {
        Expression expression;
        String string = null;
        int n = this.getUnknownTypeCount();
        int n2 = this.getVerbCount();
        if (n == 0) {
            string = this.getObjectName();
        }
        if (string == null && n2 == 1) {
            string = this.stringFromExpressionsAfter(this.getVerb());
        }
        if (string == null && n > 0 && (expression = this.getUnknownTypeExpression(0)) != null) {
            string = expression.getNormalized();
        }
        if (string == null && n2 > 1) {
            string = this.stringFromExpressionsAfter(this.getVerb(0));
        }
        return string;
    }

    private String stringFromExpressionsAfter(Expression expression) {
        Object object;
        if (expression == null) {
            return null;
        }
        Iterator<Expression> iterator = this.iteratorFromExpression(expression);
        Iterator<Expression> iterator2 = this.iteratorFromExpression(expression);
        if (iterator2.hasNext() && ((Expression)(object = iterator2.next())).isNumeral()) {
            iterator.next();
        }
        if (((SentenceBuilder)(object = new SentenceBuilder())).appendUntilBreak(iterator) > 0) {
            return ((SentenceBuilder)object).toString();
        }
        return null;
    }

    private Iterator<Expression> iteratorFromExpression(Expression expression) {
        Iterator<Expression> iterator = this.expressions.iterator();
        while (iterator.hasNext() && expression != iterator.next()) {
        }
        return iterator;
    }

    public static enum SentenceType {
        UNDEFINED,
        STATEMENT,
        IMPERATIVE,
        QUESTION;

    }
}

