/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import mikera.tyrant.AI;
import mikera.tyrant.Dungeon;
import mikera.tyrant.Fire;
import mikera.tyrant.Lib;
import mikera.tyrant.Map;
import mikera.tyrant.Point;
import mikera.tyrant.Portal;
import mikera.tyrant.RPG;
import mikera.tyrant.Thing;
import mikera.tyrant.Trap;

public class Caves {
    public static Map createCaves(int n, int n2, int n3) {
        Map map = new Map(n, n2);
        Caves.initCaves(map, n3, n3);
        map.set("Description", "Dark Caves");
        map.set("DungeonLevel", n3);
        return map;
    }

    public static Map createBigCave(int n, int n2, int n3) {
        int n4;
        int n5;
        Point point;
        int n6;
        Map map = new Map(n, n2);
        map.setTheme("caves");
        map.set("WanderingRate", 500);
        map.set("Description", "Sinister Cave");
        map.set("EnterMessage", "Your hear maniacal laughter...");
        map.setLevel(n3);
        map.fillArea(0, 0, n - 1, n2 - 1, map.wall());
        map.fillArea(n / 2 - 3, n2 / 2 - 3, n / 2 + 3, n2 / 2 + 3, map.floor());
        for (n6 = 0; n6 < (n + n2) / 3; ++n6) {
            point = map.findFreeSquare();
            n5 = RPG.rspread(1, n - 2);
            n4 = RPG.rspread(1, n2 - 2);
            map.makeRandomPath(point.x, point.y, n5, n4, 1, 1, n - 2, n2 - 2, map.floor(), false);
        }
        for (n6 = 0; n6 < n * n2 / 80; ++n6) {
            point = map.findFreeSquare();
            n5 = point.x - RPG.d(6);
            n4 = point.y - RPG.d(6);
            int n7 = point.x + RPG.d(6);
            int n8 = point.y + RPG.d(6);
            if (n5 < 1 || n7 > n - 2 || n4 < 1 || n8 > n2 - 2) continue;
            map.fillOval(n5, n4, n7, n8, map.floor());
        }
        Thing thing = Lib.create("Borrok");
        thing.addThing(Lib.createArtifact(10));
        map.addThing(thing);
        map.addEntrance("stairs up");
        return map;
    }

    public static void initCaves(Map map, int n, int n2) {
        map.setTheme("caves");
        map.setLevel(2 * n2 + 4);
        switch (n) {
            case 1: {
                map.set("MonsterType", "IsBeast");
                map.fillArea(0, 0, 64, 64, map.wall());
                map.fillArea(1, 1, 63, 63, 0);
                map.fillArea(30, 30, 32, 32, map.floor());
                Caves.makeCaves(map);
                Thing thing = Lib.create("ladder down");
                thing.set("ComplexName", "caves");
                thing.set("DestinationLevel", 2);
                map.addThing(thing);
                break;
            }
            case 2: {
                map.set("MonsterType", "IsBeast");
                map.fillArea(0, 0, 64, 64, map.wall());
                map.fillArea(1, 1, 63, 63, 0);
                map.fillArea(30, 30, 32, 32, map.floor());
                Caves.makeCaves(map);
                Thing thing = Lib.create("ladder down");
                thing.set("ComplexName", "caves");
                thing.set("DestinationLevel", 3);
                map.addThing(thing);
                map.addThing(Portal.create("mysterious dungeon"));
                break;
            }
            case 3: {
                map.set("MonsterType", "IsBandit");
                map.fillArea(0, 0, 64, 64, map.wall());
                map.fillArea(1, 1, 63, 63, 0);
                map.fillArea(27, 27, 35, 35, map.floor());
                map.addThing(Fire.create(5), 27, 27, 35, 35);
                map.addThing(Fire.create(5), 27, 27, 35, 35);
                Thing thing = Lib.create("swordsman");
                AI.name(thing, "Graam the Terrible");
                thing.addThing(Lib.createArtifact(10));
                map.addThing(thing, 27, 27, 35, 35);
                Caves.makeCaves(map);
                break;
            }
        }
        map.setEntrance(Portal.create("ladder up"));
        map.addThing(map.entrance());
    }

    public static void makeCaves(Map map) {
        int n;
        block12: for (n = 0; n < 200; ++n) {
            int n2 = 0;
            int n3 = 0;
            switch (RPG.d(4)) {
                case 1: {
                    n2 = 1;
                    break;
                }
                case 2: {
                    n2 = -1;
                    break;
                }
                case 3: {
                    n3 = 1;
                    break;
                }
                case 4: {
                    n3 = -1;
                }
            }
            Point point = map.findEdgeSquare(n2, n3, 0);
            if (point == null) continue;
            point.x += n2;
            point.y += n3;
            switch (RPG.d(7)) {
                case 1: 
                case 2: {
                    Caves.makeThinPassage(map, point.x, point.y, n2, n3, false);
                    continue block12;
                }
                case 3: {
                    Caves.makeThinPassage(map, point.x, point.y, n2, n3, true);
                    continue block12;
                }
                case 4: 
                case 5: 
                case 6: {
                    Dungeon.makeOvalRoom(map, point.x, point.y, n2, n3);
                    continue block12;
                }
                case 7: {
                    Caves.makeCrevice(map, point.x, point.y, n2, n3);
                }
            }
        }
        map.replaceTiles(0, map.wall());
        for (n = 0; n < 13; ++n) {
            map.addThing(Lib.create("rock"));
        }
        for (n = 0; n < 6; ++n) {
            map.addThing(Lib.create("stone"));
        }
        for (n = 0; n < 10; ++n) {
            map.addThing(Dungeon.createFoe(map));
        }
    }

    public static boolean makeThinPassage(Map map, int n, int n2, int n3, int n4, boolean bl) {
        int n5 = RPG.d(2, 12);
        int n6 = RPG.d(4);
        if (!map.isBlank(n + n6 * n4, n2 - n6 * n3, n - n6 * n4 + n5 * n3, n2 + n6 * n3 + n5 * n4)) {
            return false;
        }
        map.fillArea(n + n6 * n4, n2 - n6 * n3, n - n6 * n4 + n5 * n3 / 2, n2 + n6 * n3 + n5 * n4 / 2, map.wall());
        int n7 = 0;
        for (int i = 0; i <= n5; ++i) {
            map.setTile(n + i * n3 + n7 * n4, n2 + i * n4 - n7 * n3, map.floor());
            if (RPG.d(2) == 1) {
                n7 = RPG.middle(-n6, n7 + RPG.r(2) - RPG.r(2), n6);
            }
            if (bl) continue;
            map.setTile(n + i * n3 + n7 * n4, n2 + i * n4 - n7 * n3, map.floor());
        }
        return true;
    }

    private static boolean makeCrevice(Map map, int n, int n2, int n3, int n4) {
        if (!map.isBlank(n + n4, n2 - n3, n - n4, n2 + n3)) {
            return false;
        }
        map.setTile(n + n4, n2 - n3, map.wall());
        map.setTile(n - n4, n2 + n3, map.wall());
        switch (RPG.d(10)) {
            case 1: {
                map.setTile(n, n2, map.floor());
                Dungeon.makeOvalRoom(map, n + n3, n2 + n4, n3, n4);
                break;
            }
            case 2: {
                map.setTile(n, n2, map.floor());
                map.addThing(Trap.createTrap(map.getLevel()), n, n2);
                if (RPG.d(3) != 1 || map.getTile(n + n3, n2 + n4) != 0) break;
                map.setTile(n + n3, n2 + n4, map.floor());
                if (RPG.d(3) != 1) break;
                map.addThing(Lib.createItem(map.getLevel()), n + n3, n2 + n4);
                break;
            }
            case 3: {
                map.setTile(n, n2, map.floor());
                Caves.makeCrevice(map, n + n3 + (RPG.r(3) - 1) * n4, n2 + n4 - (RPG.r(3) - 1) * n3, n3, n4);
                break;
            }
            case 4: {
                Caves.makeSecretDoor(map, n, n2);
                if (RPG.d(2) == 1) {
                    Caves.makeCrevice(map, n + n3, n2 + n4, n3, n4);
                    break;
                }
                Dungeon.makeOvalRoom(map, n + n3, n2 + n4, n3, n4);
                break;
            }
            default: {
                map.setTile(n, n2, map.floor());
            }
        }
        return true;
    }

    private static void makeSecretDoor(Map map, int n, int n2) {
        map.setTile(n, n2, map.wall());
        map.addThing(Lib.create("secret door"), n, n2);
    }

    public static boolean makeTunnel(Map map, int n, int n2, int n3, int n4) {
        if (map.getTile(n, n2) == 0) {
            int n5 = n3;
            int n6 = n4;
            map.setTile(n, n2, map.floor());
            if (RPG.d(3) == 1) {
                n5 = -n4;
                n6 = n3;
            }
            if (RPG.d(4) == 1) {
                n5 = n4;
                n6 = -n3;
            }
            Caves.makeTunnel(map, n + n5, n2 + n6, n5, n6);
            return true;
        }
        return false;
    }
}

