/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import mikera.tyrant.Food;
import mikera.tyrant.Game;
import mikera.tyrant.Item;
import mikera.tyrant.Lib;
import mikera.tyrant.RPG;
import mikera.tyrant.Thing;

public class Gods {
    public static final String YANTHRALL = "Yanthrall";
    public static final String ARVALLON = "Arvallon";
    public static final String ARAMIS = "Aramis";
    public static final String DURVAL = "Durval";
    public static final String ZUROCH = "Zuroch";
    public static final String MOLKOTH = "Molkoth";
    public static final String BZAKKARATH = "B'Zakkarath";
    public static final String TROTHGAR = "Trothgar";
    public static final String NASSARRIK = "Nassarrik";
    public static final String GATHAARL = "Gathaarl";

    public static Thing get(String string) {
        Thing thing;
        HashMap hashMap = Gods.getGods();
        Thing thing2 = thing = string == null ? null : (Thing)hashMap.get(string);
        if (thing == null) {
            Game.warn("God [" + string + "] does not exist!");
        }
        return thing;
    }

    public static Thing getGod(Thing thing) {
        return Gods.get(Gods.getGodName(thing));
    }

    public static String getGodName(Thing thing) {
        return thing.getString("Religion");
    }

    public static HashMap getGods() {
        HashMap hashMap = (HashMap)Lib.instance().getObject("Gods");
        if (hashMap == null) {
            hashMap = new HashMap();
            Lib.instance().set("Gods", hashMap);
        }
        return hashMap;
    }

    public static ArrayList getPossibleGods(Thing thing) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = Gods.getGods().keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!Gods.acceptsFollower(string, thing)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public static void sacrifice(Thing thing, Thing thing2) {
        thing.incStat("APS", -100);
        thing2.remove();
        Thing thing3 = Gods.getGod(thing);
        int n = Item.value(thing2);
        Game.message(thing2.getTheName() + " " + thing2.is() + " " + thing3.getString("SacrificeDescription"));
        int n2 = thing.getLevel();
        int n3 = thing2.getLevel() - thing.getLevel();
        n3 = RPG.max(0, n3);
        n = (int)((double)n * (1.0 + 0.2 * (double)n3));
        double d = (double)n / Item.levelValue(n2);
        int n4 = 0;
        if (d > 1.0) {
            ++n4;
        }
        if (d > 10.0) {
            ++n4;
        }
        if (d > 100.0) {
            ++n4;
        }
        if (d > 1000.0) {
            ++n4;
        }
        if (d > 10000.0) {
            ++n4;
        }
        String string = thing3.getString("SacrificePreference");
        boolean bl = false;
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            if (!thing2.getFlag(stringArray[i])) continue;
            bl = true;
        }
        if (bl) {
            n4 *= 3;
        }
        if (thing2.getFlag("IsArtifact")) {
            Game.message("\"Your loyalty shall be rewarded.\"");
            thing.incStat("FatePoints", 1);
            if (!thing.getFlag("Prayer")) {
                thing.incStat("Prayer", 1);
            }
        } else if (n4 > 0) {
            Gods.impress(thing, n4);
        } else if (n4 == 0) {
            Game.message("You feel that " + thing3.name() + " is unimpressed by your pathetic offering");
        } else if (n4 < 0) {
            Gods.anger(thing, -n4);
        }
    }

    public static boolean acceptsFollower(String string, Thing thing) {
        Thing thing2 = Gods.get(string);
        boolean bl = true;
        String string2 = thing2.getString("AcceptableRaces");
        String string3 = thing.getString("Race");
        bl = string2.equals("any") || string2.indexOf(string3) >= 0 ? (bl &= true) : false;
        String string4 = thing2.getString("AcceptableProfessions");
        String string5 = thing.getString("Profession");
        bl = string4.equals("any") || string4.indexOf(string5) >= 0 ? (bl &= true) : false;
        int n = thing2.getStat("AcceptableAlignmentDifference");
        if (Math.abs(Gods.getGoodness(thing) - Gods.getGoodness(thing2)) > n) {
            bl = false;
        }
        return bl;
    }

    private static void addGod(Thing thing) {
        Gods.getGods().put(thing.name(), thing);
        Lib.add(thing);
    }

    public static int getGoodness(Thing thing) {
        String string = thing.getString("Alignment");
        char c = string.charAt(0);
        int n = 0;
        if (c == 'G') {
            n += 3;
        } else if (c == 'E') {
            n -= 3;
        }
        if (string.length() > 1) {
            char c2 = string.charAt(1);
            if (c2 == '+') {
                ++n;
            } else if (c2 == '-') {
                --n;
            }
        }
        return n;
    }

    public static String getAlignment(int n) {
        switch (n) {
            case -3: {
                return "E";
            }
            case -2: {
                return "E+";
            }
            case -1: {
                return "N-";
            }
            case 0: {
                return "N";
            }
            case 1: {
                return "N+";
            }
            case 2: {
                return "G-";
            }
            case 3: {
                return "G";
            }
        }
        if (n > 0) {
            return "G+";
        }
        return "E-";
    }

    public static boolean anger(Thing thing, int n) {
        if (n < 0) {
            n = 0;
        }
        thing.incStat("Sin", n);
        if (n > 0) {
            thing.message("You feel that " + Gods.getGodName(thing) + " is angry with you");
        }
        return n > 0;
    }

    public static boolean impress(Thing thing, int n) {
        if (n < 0) {
            return Gods.anger(thing, -n);
        }
        thing.incStat("Peity", n);
        if (n > 0) {
            thing.message("You feel that " + Gods.getGodName(thing) + " is pleased");
        }
        return n > 0;
    }

    public static void checkEat(Thing thing, Thing thing2) {
        int n;
        Thing thing3 = Gods.getGod(thing);
        if (!Food.isVegetarian(thing2) && (n = thing3.getStat("RequiresVegetarian")) > 0) {
            Gods.anger(thing, n);
        }
    }

    public static int checkTheft(Thing thing) {
        Thing thing2 = Gods.getGod(thing);
        int n = Gods.getGoodness(thing2);
        int n2 = thing2.getStat("LikesTheft");
        int n3 = 0;
        if (n >= 0) {
            n3 = -(n + 1) * (n + 2) / 2;
        } else if (n2 > 0) {
            n3 = n2;
        } else if (n <= -4) {
            n3 = 1;
        }
        Gods.impress(thing, n3);
        return n3;
    }

    public static void init() {
        Thing thing = Lib.extend("base god", "base thing");
        thing.set("AcceptableAlignmentDifference", 2);
        thing.set("SacrificeDescription", "consumed by flames");
        thing.set("SacrificePreference", null);
        thing.set("LevelMin", 1);
        Lib.add(thing);
        thing = Lib.extend(ARAMIS, "base god");
        thing.set("GodTitle", "God of Healing");
        thing.set("AcceptableRaces", "any");
        thing.set("SacrificePreference", "IsArmour,IsPotion");
        thing.set("AcceptableProfessions", "ranger,priest,shaman,healer,paladin");
        thing.set("SacrificeDescription", "consumed in a brillient light");
        thing.set("Alignment", "G+");
        thing.set("UpbringingText", "In accordance with the teachings of Aramis, you learnt to respect all living things and in particular never to eat the flesh of animals.");
        thing.set("RequiresVegetarian", 1);
        Gods.addGod(thing);
        thing = Lib.extend(DURVAL, "base god");
        thing.set("GodTitle", "God of the Mountains");
        thing.set("AcceptableRaces", "hobbit,dwarf,gnome,half troll,argonian,hawken");
        thing.set("AcceptableProfessions", "any");
        thing.set("SacrificePreference", "IsCoin,IsWeapon");
        thing.set("UpbringingText", "You learnt of the secret treasures buried in the Deep, which you should always strive to acquire to the greater glory of Durval.");
        thing.set("Alignment", "N+");
        Gods.addGod(thing);
        thing = Lib.extend(ARVALLON, "base god");
        thing.set("GodTitle", "Benevolent God of Enlightenment");
        thing.set("AcceptableRaces", "human,high elf,wood elf,pensadorian");
        thing.set("AcceptableProfessions", "any");
        thing.set("SacrificePreference", "IsScroll,IsBook");
        thing.set("SacrificeDescription", "consumed by a blinding light");
        thing.set("UpbringingText", "You learnt of how Arvallon alone was granted the key to all knowledge by the Creator, and would bestow the greatest of secrets upon His loyal followers.");
        thing.set("Alignment", "G");
        Gods.addGod(thing);
        thing = Lib.extend(YANTHRALL, "base god");
        thing.set("GodTitle", "Warrior-God of the Daedorian Empire");
        thing.set("AcceptableRaces", "human,wood elf,hobbit,dwarf,gnome");
        thing.set("AcceptableProfessions", "any");
        thing.set("SacrificePreference", "IsWeapon,IsArmour");
        thing.set("SacrificeDescription", "consumed in an awesome column of roaring fire");
        thing.set("UpbringingText", "As with all followers of Yanthrall, you came to appreciate that life is a ceaseless battle, and that victory belongs to The Strong and The Just. You dreamed of one day being initiated into the mighty ranks of the Blood Guard.");
        thing.set("Alignment", "N+");
        Gods.addGod(thing);
        thing = Lib.extend(ZUROCH, "base god");
        thing.set("GodTitle", "God of Prosperity");
        thing.set("AcceptableRaces", "any");
        thing.set("AcceptableProfessions", "any");
        thing.set("AcceptableAlignmentDifference", 3);
        thing.set("SacrificeDescription", "teleported away");
        thing.set("SacrificePreference", "IsCoin,IsFood");
        thing.set("UpbringingText", "You heeded well the command of Zuroch, that His followers should seek to find joy in the accumulation of wealth and the making of sizeable donations to temple coffers.");
        thing.set("Alignment", "N-");
        Gods.addGod(thing);
        thing = Lib.extend(MOLKOTH, "base god");
        thing.set("GodTitle", "Dark God of the Underworld");
        thing.set("AcceptableRaces", "human,gnome,dark elf,half troll,half orc,pensadorian");
        thing.set("AcceptableProfessions", "any");
        thing.set("AcceptableAlignmentDifference", 3);
        thing.set("SacrificePreference", "IsPotion,IsWeapon");
        thing.set("SacrificeDescription", "burnt away by malevolent black fire");
        thing.set("UpbringingText", "You learnt that all existence will one day be swallowed by Darkness, when Molkoth and His invincible demonic armies of destruction sweep to victory aginst the pathetic Forces of Light. Only those who serve Molkoth will be granted a place in the Afterworld, with the souls of all others destined for eternal pain.");
        thing.set("Alignment", "E-");
        Gods.addGod(thing);
        thing = Lib.extend(BZAKKARATH, "base god");
        thing.set("GodTitle", "Chaos God of The Underworld");
        thing.set("AcceptableRaces", "any");
        thing.set("AcceptableProfessions", "any");
        thing.set("SacrificePreference", "IsWeapon,IsGem");
        thing.set("UpbringingText", "You learnt to see beauty in mayhem and destruction, pleasure in pain and rejoice in the relentless spread of Chaos.");
        thing.set("Alignment", "E");
        Gods.addGod(thing);
        thing = Lib.extend(TROTHGAR, "base god");
        thing.set("GodTitle", "God of The Wild");
        thing.set("AcceptableRaces", "human,dwarf,dark elf,half orc,half troll,argonian,hawken");
        thing.set("AcceptableProfessions", "barbarian,thief,fighter,ranger,shaman");
        thing.set("SacrificePreference", "IsFood,IsPotion");
        thing.set("UpbringingText", "You learnt of the colossal power of the Spirits of Nature, and that you should offer sacrifices to Trothgar to earn His protection.");
        thing.set("Alignment", "N-");
        Gods.addGod(thing);
        thing = Lib.extend(NASSARRIK, "base god");
        thing.set("GodTitle", "God of Thieves");
        thing.set("AcceptableRaces", "any");
        thing.set("AcceptableProfessions", "barbarian,thief");
        thing.set("LikesTheft", 1);
        thing.set("SacrificePreference", "IsCoin,IsPotion");
        thing.set("UpbringingText", "You learn of the dark cults that pervade the lands of men, and how you should seek to serve them as a loyal follower of Nassarrik.");
        thing.set("Alignment", "E+");
        Gods.addGod(thing);
        thing = Lib.extend(GATHAARL, "base god");
        thing.set("GodTitle", "Goblin God of Battle");
        thing.set("AcceptableRaces", "half orc,half troll");
        thing.set("AcceptableProfessions", "any");
        thing.set("SacrificePreference", "IsFood,IsWeapon");
        thing.set("SacrificeDescription", "dissolved in a cloud of green smoke");
        thing.set("UpbringingText", "You learn to rejoice in the thrill of battle, that you should multiply to cover the earth, and that you should raise great totems to the glory of Gathaarl and the Goblin Spirits.");
        thing.set("Alignment", "N-");
        Gods.addGod(thing);
    }
}

