/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import mikera.tyrant.Game;
import mikera.tyrant.LevelMap;
import mikera.tyrant.Map;
import mikera.tyrant.TPanel;

public class LevelMapPanel
extends TPanel {
    private BufferedImage mapBuffer;
    private Map permanentMap = null;

    public LevelMapPanel() {
        super(Game.getQuestapp());
    }

    public Dimension getPreferredSize() {
        return new Dimension(200, 150);
    }

    public void setMap(Map map) {
        this.permanentMap = map;
    }

    public void paint(Graphics graphics) {
        Map map = this.permanentMap != null ? this.permanentMap : Game.hero().getMap();
        super.paint(graphics);
        if (map != null) {
            this.paintMap(graphics, map);
        }
    }

    public void paintMap(Graphics graphics, Map map) {
        int n = map.width;
        int n2 = map.height;
        int[] nArray = LevelMap.instance().getMapView(map);
        if (this.mapBuffer == null || this.mapBuffer.getHeight() != n2 || this.mapBuffer.getWidth() != n) {
            this.mapBuffer = new BufferedImage(n, n2, 1);
        }
        this.mapBuffer.setRGB(0, 0, n, n2, nArray, 0, n);
        graphics.setColor(Color.BLACK);
        int n3 = this.getWidth() / 2;
        int n4 = this.getHeight() / 2;
        int n5 = n * 2;
        int n6 = n2 * 2;
        if (n5 > n3) {
            n6 = n6 * n3 / n5;
            n5 = n5 * n3 / n5;
        }
        if (n6 > n4) {
            n5 = n5 * n4 / n6;
            n6 = n6 * n4 / n6;
        }
        try {
            graphics.drawImage(this.mapBuffer, n3 - n5, n4 - n6, n3 + n5, n4 + n6, 0, 0, n, n2, null);
        }
        catch (Throwable throwable) {
            Game.warn(throwable.toString());
        }
    }
}

