/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import mikera.tyrant.Animation;
import mikera.tyrant.Being;
import mikera.tyrant.Game;
import mikera.tyrant.GameScreen;
import mikera.tyrant.Map;
import mikera.tyrant.Point;
import mikera.tyrant.QuestApp;
import mikera.tyrant.RPG;
import mikera.tyrant.Thing;
import mikera.tyrant.Tile;
import mikera.tyrant.author.Designer;

public class MapPanel
extends Panel
implements Runnable {
    private static final long serialVersionUID = 3616728257933161270L;
    public static final int TILEWIDTH = 32;
    public static final int TILEHEIGHT = 32;
    private boolean slant = false;
    protected int width = 15;
    protected int height = 15;
    public int zoomfactor = 100;
    private int lastzoomfactor = 100;
    private Graphics buffergraphics;
    private Image buffer;
    private Graphics animationgraphics;
    private Image animationbuffer;
    public Map map = new Map(5, 5);
    protected int scrollx = 0;
    protected int scrolly = 0;
    public int curx = 0;
    public int cury = 0;
    public boolean cursor = false;
    public int currentTile = 10;
    private boolean animating = false;
    private boolean animationdone = false;
    private ArrayList animationElements = new ArrayList();

    public void run() {
        while (true) {
            try {
                while (true) {
                    if (this.animating) {
                        this.animationdone = false;
                        this.repaint();
                    }
                    Thread.sleep(50L);
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAnimation(Animation animation) {
        ArrayList arrayList = this.animationElements;
        synchronized (arrayList) {
            if (!this.animating) {
                this.animating = true;
            }
            this.animationElements.add(animation);
        }
    }

    public MapPanel(GameScreen gameScreen) {
        Thread thread = new Thread(this);
        thread.start();
        this.addKeyListener(gameScreen.questapp.keyadapter);
        this.setBackground(Color.black);
        if (!Game.instance().isDesigner()) {
            this.addMouseListener(new MyMouseListener());
        }
    }

    public void viewPosition(Map map, int n, int n2) {
        this.setPosition(map, n, n2);
        this.repaint();
    }

    public void scroll(int n, int n2) {
        this.scrollx = Math.min(Math.max(0, n + this.scrollx), this.map.width - this.width / 2);
        this.scrolly = Math.min(Math.max(0, n2 + this.scrolly), this.map.height - this.height / 2);
        this.render();
        this.repaint();
    }

    public void setPosition(Map map, int n, int n2) {
        this.map = map;
        if (this.map != null) {
            this.scrollx = RPG.middle(0, n - this.width / 2, this.map.getWidth() - this.width);
            this.scrolly = RPG.middle(0, n2 - this.height / 2, this.map.getHeight() - this.height);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width * 32, this.height * 32);
    }

    public void drawTiles(int n, int n2, int n3, int n4) {
        for (int i = n2; i <= n4; ++i) {
            for (int j = n; j <= n3; ++j) {
                this.drawTile(j, i);
            }
        }
    }

    public void drawTile(int n, int n2) {
        Thing thing = Game.hero();
        int n3 = this.map.getTile(n, n2);
        if (!this.map.isDiscovered(n, n2)) {
            n3 = 0;
        }
        Image image = this.map.isVisible(n, n2) ? QuestApp.tiles : QuestApp.greytiles;
        int n4 = n3 & 0xFFFF;
        int n5 = (n - this.scrollx) * 32;
        int n6 = (n2 - this.scrolly) * 32;
        if (this.slant) {
            n6 = n6 * 3 / 4;
        }
        switch (n4) {
            case 0: {
                this.buffergraphics.setColor(Color.black);
                this.buffergraphics.fillRect((n - this.scrollx) * 32, (n2 - this.scrolly) * 32, 32, 32);
                break;
            }
            default: {
                int n7 = this.map.isDiscovered(n, n2 + 1) && Tile.filling[this.map.getTile(n, n2 + 1) & 0xFFFF] ? Tile.imagefill[n4] : Tile.images[n4];
                int n8 = n7 % 20 * 32;
                int n9 = n7 / 20 * 32;
                int n10 = 32;
                if (this.slant && !Tile.isFilling(n4)) {
                    n10 = n10 * 3 / 4;
                    n9 += 8;
                    n6 += 8;
                }
                this.buffergraphics.drawImage(image, n5, n6, n5 + 32, n6 + n10, n8, n9, n8 + 32, n9 + n10, null);
                if (Tile.borders[n4] <= 0 || image != QuestApp.tiles) break;
                if (n > 0 && this.map.getTile(n - 1, n2) != n3) {
                    this.buffergraphics.drawImage(QuestApp.scenery, n5, n6, n5 + 32, n6 + 32, 0, 512, 32, 544, null);
                }
                if (n < this.map.width - 1 && this.map.getTile(n + 1, n2) != n3) {
                    this.buffergraphics.drawImage(QuestApp.scenery, n5, n6, n5 + 32, n6 + 32, 32, 512, 64, 544, null);
                }
                if (n2 > 0 && this.map.getTile(n, n2 - 1) != n3) {
                    this.buffergraphics.drawImage(QuestApp.scenery, n5, n6, n5 + 32, n6 + 32, 64, 512, 96, 544, null);
                }
                if (n2 >= this.map.height - 1 || this.map.getTile(n, n2 + 1) == n3) break;
                this.buffergraphics.drawImage(QuestApp.scenery, n5, n6, n5 + 32, n6 + 32, 96, 512, 128, 544, null);
            }
        }
        if (this.map.isVisible(n, n2)) {
            this.drawThings(n, n2);
        } else if (n == thing.x && n2 == thing.y) {
            this.drawThing(n, n2, thing);
        }
    }

    private void drawThing(int n, int n2, Thing thing) {
        Image image = null;
        if (Game.isDebug() || !thing.isInvisible()) {
            Image image2;
            Object object;
            int n3 = thing.getImage();
            int n4 = n3 % 20 * 32;
            int n5 = n3 / 20 * 32;
            int n6 = (n - this.scrollx) * 32;
            int n7 = (n2 - this.scrolly) * 32;
            if (this.slant) {
                n7 = n7 * 3 / 4;
            }
            image = (object = thing.get("ImageSource")) == null ? QuestApp.items : (Image)QuestApp.images.get(object);
            this.buffergraphics.drawImage(image, n6, n7, n6 + 32, n7 + 32, n4, n5, n4 + 32, n5 + 32, null);
            if (Game.instance().isDesigner() && thing.getFlag("AuthorIsTyped") && (image2 = Designer.getOverlayImage()) != null) {
                int n8 = image2.getWidth(null);
                int n9 = image2.getHeight(null);
                this.buffergraphics.drawImage(image2, n6 + 32 - n8, n7, n6 + 32, n7 + n9, 0, 0, n8, n9, null);
            }
            if (thing.getFlag("IsBeing")) {
                double d = Being.getHealth(thing);
                Color color = new Color(0, 0, 0, 64);
                this.buffergraphics.setColor(color);
                this.buffergraphics.fillRect(n6 + 20, n7 + 0, 12, 3);
                color = thing.isHostile(Game.hero()) ? Color.RED : Color.GREEN;
                color = new Color(color.getRed(), color.getGreen(), color.getBlue(), 128);
                this.buffergraphics.setColor(color);
                this.buffergraphics.fillRect(n6 + 21, n7 + 1, (int)(10.0 * d), 1);
            }
        }
    }

    private void drawThings(int n, int n2) {
        Image image;
        Thing thing = this.map.sortZ(n, n2);
        int n3 = 0;
        if (thing == null) {
            return;
        }
        do {
            this.drawThing(n, n2, thing);
            thing = thing.next;
            ++n3;
        } while (thing != null);
        if (n3 > 1 && (image = Designer.getPlusImage()) != null) {
            int n4 = (n - this.scrollx) * 32;
            int n5 = (n2 - this.scrolly) * 32;
            int n6 = image.getWidth(null);
            int n7 = image.getHeight(null);
            this.buffergraphics.drawImage(image, n4 + 32 - n6, n5, n4 + 32, n5 + n7, 0, 0, n6, n7, null);
        }
    }

    public void setCursor(int n, int n2) {
        this.cursor = true;
        this.curx = n;
        this.cury = n2;
        this.repaint();
    }

    public void clearCursor() {
        this.cursor = false;
        this.repaint();
    }

    public void drawImage(Graphics graphics, double d, double d2, int n) {
        if (!this.map.isVisible((int)Math.round(d), (int)Math.round(d2))) {
            return;
        }
        int n2 = (int)((d - (double)this.scrollx) * 32.0);
        int n3 = (int)((d2 - (double)this.scrolly) * 32.0);
        int n4 = n % 20 * 32;
        int n5 = 32 * (n / 20);
        graphics.drawImage(QuestApp.effects, n2, n3, n2 + 32, n3 + 32, n4, n5, n4 + 32, n5 + 32, null);
    }

    public void doExplosion(int n, int n2, int n3, int n4, String string) {
        Game.instance().doExplosion(n, n2, n3, 1);
        this.map.areaDamage(n, n2, 2, n4, string);
    }

    public void drawCursor(int n, int n2) {
        int n3 = (n - this.scrollx) * 32;
        int n4 = (n2 - this.scrolly) * 32;
        int n5 = 192;
        int n6 = 0;
        this.buffergraphics.drawImage(QuestApp.effects, n3, n4, n3 + 32, n4 + 32, n5, n6, n5 + 32, n6 + 32, null);
    }

    public void drawMap(Graphics graphics) {
        Image image = this.buffer;
        if (this.animating && this.animationbuffer != null) {
            image = this.animationbuffer;
        }
        Rectangle rectangle = this.getBounds();
        int n = rectangle.width;
        int n2 = rectangle.height;
        graphics.drawImage(image, (n - this.width * 32 * this.zoomfactor / 100) / 2, (n2 - this.height * 32 * this.zoomfactor / 100) / 2, this.width * 32 * this.zoomfactor / 100, this.height * 32 * this.zoomfactor / 100, null);
    }

    public void render() {
        if (this.buffer == null) {
            this.buffer = this.createImage(this.width * 32, this.height * 32);
            if (this.buffer == null) {
                return;
            }
            this.buffergraphics = this.buffer.getGraphics();
            this.animationbuffer = this.createImage(this.width * 32, this.height * 32);
            this.animationgraphics = this.animationbuffer.getGraphics();
        }
        this.drawTiles(this.scrollx, this.scrolly, this.scrollx + this.width - 1, this.scrolly + this.height - 1);
        if (this.cursor) {
            this.drawCursor(this.curx, this.cury);
        }
    }

    public void renderAnimation() {
        if (this.buffer != null) {
            this.animationgraphics.drawImage(this.buffer, 0, 0, null);
            this.drawAnimationFrame(this.animationgraphics);
        }
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle = this.getBounds();
        if (this.zoomfactor != this.lastzoomfactor) {
            int n = rectangle.width;
            int n2 = rectangle.height;
            graphics.setColor(Color.black);
            graphics.fillRect(0, 0, n, n2);
            this.lastzoomfactor = this.zoomfactor;
        }
        if (this.animating && !this.animationdone) {
            this.renderAnimation();
        }
        if (this.buffer != null) {
            this.drawMap(graphics);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawAnimationFrame(Graphics graphics) {
        ArrayList arrayList = this.animationElements;
        synchronized (arrayList) {
            Iterator iterator = this.animationElements.iterator();
            while (iterator.hasNext()) {
                Animation animation = (Animation)iterator.next();
                animation.draw(this, graphics);
                if (!animation.isExpired()) continue;
                iterator.remove();
            }
            if (this.animationElements.size() == 0) {
                this.animating = false;
            }
        }
    }

    public Point convertUICoordinatesToMap(MouseEvent mouseEvent) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = (mouseEvent.getX() - (n - this.width * 32) / 2) / 32 + this.scrollx;
        int n4 = (mouseEvent.getY() - (n2 - this.height * 32) / 2) / 32 + this.scrolly;
        return new Point(n3, n4);
    }

    private final class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Thing thing = Game.hero();
            int n = (mouseEvent.getModifiers() & 4) == 4 ? -1 : 1;
            Rectangle rectangle = MapPanel.this.getBounds();
            int n2 = rectangle.width;
            int n3 = rectangle.height;
            int n4 = (mouseEvent.getX() - (n2 - MapPanel.this.width * 32) / 2) / 32 + MapPanel.this.scrollx;
            int n5 = (mouseEvent.getY() - (n3 - MapPanel.this.height * 32) / 2) / 32 + MapPanel.this.scrolly;
            if (n == 1) {
                int n6 = n4 - thing.x;
                int n7 = n5 - thing.y;
                if (n6 == 0 && n7 == 0) {
                    return;
                }
                int n8 = -1;
                if (n7 < 2 * n6) {
                    ++n8;
                }
                if (n7 > -2 * n6) {
                    ++n8;
                }
                int n9 = -1;
                if (n6 < 2 * n7) {
                    ++n9;
                }
                if (n6 > -2 * n7) {
                    ++n9;
                }
                Game.simulateDirection(n8, n9);
            } else if (Game.isDebug()) {
                MapPanel.this.map.addThing(thing, n4, n5);
                Game.warn("Teleport to (" + n4 + "," + n5 + ")");
                MapPanel.this.map.calcVisible(thing, Being.calcViewRange(thing));
                MapPanel.this.render();
                MapPanel.this.repaint();
            }
            thing.calculateVision();
            MapPanel.this.viewPosition(MapPanel.this.map, thing.x, thing.y);
        }
    }
}

