/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import mikera.tyrant.Event;
import mikera.tyrant.Game;
import mikera.tyrant.RPG;
import mikera.tyrant.Script;
import mikera.tyrant.Thing;

public class Personality
extends Script {
    private static final long serialVersionUID = 3257001072949539128L;
    public static final int CHATTER = 1;
    public static final int TEACHER = 2;
    public static final int BLACKSMITH = 3;
    public static final int CHATTER_TOWNIE = 0;
    public static final int CHATTER_GUARD = 1;
    public static final int CHATTER_WISE = 2;
    public static final int CHATTER_PLEASANT = 3;
    public static final int CHATTER_GOODLY = 4;
    public static final int CHATTER_ADVENTURER = 5;
    public static final int CHATTER_GOBLIN = 6;
    public static final int CHATTER_ORC = 7;
    public static final int CHATTER_SHOPKEEPER = 8;
    protected static final ChatterComment[] chattercomments = new ChatterComment[]{new ChatterComment(new String[]{"Nice day, innit?", "Bugger off.", "There be evil beasties in that forest!", "Mark my words, eh?", "Arrr?", "What is you wantin'?", "You be wantin' some gruel?", "There'll be much drinkin' at the inn tonight!"}, new String[]{"Hi.", "Hi there."}, 0.3), new ChatterComment(new String[]{"You better watch yerself!", "Don't mess with me!", "They say I'm a nooligan.", "I be eatin' dragon steak for breakfast.", "I'm 'ard.", "Don't you go causin' no trouble.", "I'm the toughest guard in town", "Wanna fight?", "Ra! I'm the mightiest hero in the world!"}, new String[0], 0.0), new ChatterComment(new String[]{"Mithril is light!", "Eat mushrooms for beauty and strength!", "Don't play with fire!", "Never step on strange runes.", "Always wear tough boots!", "Don't pick herbs unless you know what you are doing!", "You will find great beauty in the darkest places"}, new String[0], 0.0), new ChatterComment(new String[]{"So what's it like being an adventurer?", "Don't go near the forest... it's dangerous!", "That shopkeeper is a real stingy villain.", "I hear that rings are in fashion...", "Meet me later at the inn."}, new String[]{"Hi.", "Hi!", "Hello.", "Hello!", "Hi there.", "Nice to meet ya."}, 0.6), new ChatterComment(new String[]{"Peace be with you!", "Seek the healing waters of Aramis!", "May the blessings of Aramis be upon you.", "Learn Healing so that you may help people recover from their wounds.", "There is great joy in learning the art of Prayer.", "Let us pray for peace in these troubled times."}, new String[]{"Greetings, my child."}, 0.7), new ChatterComment(new String[]{"Let us swap tales in the tavern, my friend.", "They say the Eastern Isles are the most wondrous of all places.", "'Tis a great day to wander wild and free!", "Improve your Defence skill and you will use armour more effectively.", "Improve your Attack skill to give yourself greater accuracy and power in combat.", "They say the forests are beautiful this time of year.", "Practice Athletics - you never know when you might need to run swiftly.", "Warriors who train in Ferocity will hit their opponents more often!", "'Tis always best to travel light and free."}, new String[]{"Greetings friend"}, 0.4), new ChatterComment(new String[]{"Is you wanting da mushrooms?", "You is fick.", "Wot is you wanting?", "Gimme da mushrooms, hooman.", "Der is gold in dem hills.", "Gargash is da tuffest.", "He He.", "Orcs are scary.", "I is tuffer dan a B'Zekroi Lord!", "Is good day for findin' mushrooms", "'oomans are yucky", "i like huntin' in da forests"}, new String[]{"Hello hooman."}, 0.5), new ChatterComment(new String[]{"'Ooman.", "**BELCH**", "You fick.", "You ugly.", "You stooopid.", "Ug.", "Want fooood. Now.", "**GROWL**"}, new String[0], 0.0), new ChatterComment(new String[]{"Best prices here!", "I've got something just for you...", "Got anything to trade?", "Let's make a deal", "Are you a Trader? Might be able to do some good business...", "Here, take a look at these trinkets"}, new String[0], 0.0)};

    public Personality(int n) {
        this.set("Type", n);
    }

    public Personality(int n, int n2) {
        this(n);
        this.set("SubType", n2);
    }

    public boolean handle(Thing thing, Event event) {
        this.talk(this.getStat("Type"), thing);
        return true;
    }

    public static Script sayLine(String string) {
        Script script = new Script(){
            private static final long serialVersionUID = 3258694307937596213L;

            public boolean handle(Thing thing, Event event) {
                String string = this.getString("Line");
                Game.message("\"" + string + "\"");
                return false;
            }
        };
        script.set("Line", string);
        return script;
    }

    private void handleChatter(int n, int n2, Thing thing) {
        ChatterComment chatterComment = chattercomments[n];
        switch (n2) {
            case 1: {
                if (chatterComment.hello.length != 0 && RPG.p(chatterComment.helloProbability)) {
                    Game.quotedMessage(RPG.pick(chatterComment.hello));
                    break;
                }
            }
            default: {
                Game.message("\"" + RPG.pick(chatterComment.comments) + "\"");
                thing.set("ChatCount", 100);
            }
        }
    }

    private void talk(int n, Thing thing) {
        int n2 = this.getStat("SubType");
        Thing thing2 = Game.hero();
        try {
            switch (n) {
                case 1: {
                    thing.incStat("ChatCount", 1);
                    this.handleChatter(n2, thing.getStat("ChatCount"), thing);
                    return;
                }
                case 2: {
                    if (thing2.getStat("SkillPoints") > 0) {
                        Game.message("\"I see you have potential\"");
                        Game.message("\"I can teach you for a small fee...\"");
                    } else {
                        Game.message("\"There is nothing more I can teach you now.\"");
                    }
                    return;
                }
                case 3: {
                    Game.message("\"I can repair your gear for a small fee...\"");
                    return;
                }
            }
            Game.message("You get no response.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Game.message("\"Mumble mumble mumble\"");
        }
    }

    protected static class ChatterComment {
        public String[] comments;
        public String[] hello;
        public double helloProbability;

        public ChatterComment(String[] stringArray, String[] stringArray2, double d) {
            this.comments = stringArray;
            this.hello = stringArray2;
            this.helloProbability = d;
        }
    }
}

