/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import java.util.ArrayList;
import mikera.tyrant.Event;
import mikera.tyrant.Item;
import mikera.tyrant.Lib;
import mikera.tyrant.Map;
import mikera.tyrant.QuestApp;
import mikera.tyrant.RPG;
import mikera.tyrant.Script;
import mikera.tyrant.Spell;
import mikera.tyrant.Thing;

public class Wand {
    private static String[] wandtypes = new String[]{"willow", "oak", "chestnut", "birch", "elm", "acacia", "eucalyptus", "metal", "ivory", "sandalwood", "crystal", "oak", "ebony", "hazelwood", "phoenix feathered", "unicorn horn", "narwhale horn", "silver plated", "gold plated", "copper plated", "brass plated", "mithral plated", "ash", "rowen", "redwood", "ironwood", "cottonwood", "pine", "treantwood", "applewood", "pearwood", "mahogany", "cherrywood", "bone", "ambre", "jade", "bamboo", "steel", "brass", "copper", "mithral", "silver", "gold", "green", "red", "blue", "black", "white", "yellow", "orange", "purple", "indigo", "rainbow"};
    private static String[] wandAdj = new String[]{"bent", "carved", "rusty", "faded", "sticky", "shiny", "dull", "cracked", "wavy", "glowing", "thin", "fat", "heavy", "light", "gem encrusted", "jewelled", "spiral", "long", "short", "feathered", "scaled"};
    private static int[] images = new int[]{288, 288, 288, 288, 288, 288, 288, 290, 288, 288, 289, 288, 290, 288, 288, 288, 288, 290, 290, 290, 290, 290, 288, 288, 288, 290, 288, 288, 288, 288, 288, 288, 288, 290, 289, 289, 288, 290, 290, 290, 290, 290, 290, 289, 289, 289, 289, 289, 289, 289, 289, 289, 289};

    private static void initWand(Thing thing) {
        int n = RPG.r(wandtypes.length);
        int n2 = RPG.r(wandAdj.length);
        Thing thing2 = Lib.extend("xxx wand", "base wand");
        String string = thing.name();
        int n3 = thing.getStat("Level");
        if (thing == null) {
            throw new Error("Can't create wand spell: " + string);
        }
        thing2.set("Image", images[n]);
        if (n3 > 9) {
            thing2.set("UName", wandAdj[n2] + " " + wandtypes[n] + " wand");
        } else {
            thing2.set("UName", wandtypes[n] + " wand");
        }
        thing2.set("Name", "wand of " + string);
        thing2.set("NamePlural", "wands of " + string);
        thing2.set("WandSpell", string);
        thing2.set("LevelMin", RPG.max(1, thing.getLevel() - 4));
        thing2.set("OnUse", new WandScript());
        thing2.set("OnDeath", new DestroyWandScript());
        Lib.add(thing2);
    }

    public static void init() {
        Thing thing = Lib.extend("base wand", "base item");
        thing.set("IsWand", 1);
        thing.set("IsMagicItem", 1);
        thing.set("Image", 288);
        thing.set("HPS", 10);
        thing.set("ItemWeight", 800);
        thing.set("ValueBase", 500);
        thing.set("Frequency", 40);
        thing.set("Charges", 3);
        thing.set("ASCII", "/");
        Lib.add(thing);
        Wand.initRandomWands();
    }

    private static void initRandomWands() {
        ArrayList arrayList = Spell.getSpellNames();
        for (int i = 0; i < arrayList.size(); ++i) {
            Thing thing = Spell.create((String)arrayList.get(i));
            Wand.initWand(thing);
        }
    }

    private static class DestroyWandScript
    extends Script {
        private static final long serialVersionUID = 6191533767727822085L;

        private DestroyWandScript() {
        }

        public boolean handle(Thing thing, Event event) {
            String string = thing.getString("WandSpell");
            Thing thing2 = Spell.create(string);
            Spell.castAtLocation(thing2, null, (Map)event.get("DeathMap"), event.getStat("DeathX"), event.getStat("DeathY"));
            return false;
        }
    }

    private static class WandScript
    extends Script {
        private static final long serialVersionUID = 8376119664408202073L;

        private WandScript() {
        }

        public boolean handle(Thing thing, Event event) {
            int n = thing.getStat("Charges");
            Thing thing2 = event.getThing("User");
            if (n > 0) {
                thing2.message("You wave " + thing.getTheName());
                Thing thing3 = Spell.create(thing.getString("WandSpell"));
                QuestApp.getInstance().getScreen().castSpell(thing2, thing3);
                Item.identify(thing);
                thing.set("Charges", n - 1);
            } else {
                thing2.message("The wand appears useless");
            }
            return false;
        }
    }
}

