/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.gui.IzPanelConstraints;
import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LayoutConstants;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.IzPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager2;
import javax.swing.JComponent;

public class LayoutHelper
implements LayoutConstants {
    JComponent parent;
    protected boolean layoutStarted = false;
    protected Object defaultConstraints;
    protected int gridxCounter = -1;
    protected int gridyCounter = -1;
    protected LayoutManager2 izPanelLayout;
    protected static int ANCHOR = -1;
    protected static int X_STRETCH_TYPE = -1;
    protected static int Y_STRETCH_TYPE = -1;
    protected static double FULL_LINE_STRETCH_DEFAULT = -1.0;
    protected static double FULL_COLUMN_STRETCH_DEFAULT = -1.0;
    protected static Double INITIAL_STRETCH_DEFAULT = 1.0;
    protected static Double DOUBLE_ZERO = 0.0;
    public static final String[] X_GAP_NAME_LOOK_UP = new String[]{"INTERNAL_USED", "labelXGap", "textXGab", "controlXGap", "paragraphXGap", "labelToTextXGap", "labelToControlXGap", "textToLabelXGap", "controlToLabelXGap", "controlToTextXGap", "textToControlXGap", "firstXGap", "INTERNAL_USED", "INTERNAL_USED", "filler1XGap", "filler2XGap", "filler3XGap", "filler4XGap", "filler5XGap"};
    public static final String[] Y_GAP_NAME_LOOK_UP = new String[]{"INTERNAL_USED", "labelYGap", "textYGab", "controlYGap", "paragraphYGap", "labelToTextYGap", "labelToControlYGap", "textToLabelYGap", "controlToLabelYGap", "controlToTextYGap", "textToControlYGap", "firstYGap", "INTERNAL_USED", "INTERNAL_USED", "filler1YGap", "filler2YGap", "filler3YGap", "filler4YGap", "filler5YGap"};
    public static final String ALL_X_GAP = "allXGap";
    public static final String ALL_Y_GAP = "allYGap";

    public LayoutHelper(JComponent parent) {
        this();
        this.parent = parent;
        this.izPanelLayout = new GridBagLayout();
        parent.setLayout(this.izPanelLayout);
        ++this.gridyCounter;
    }

    protected LayoutHelper() {
    }

    private boolean isGridBag() {
        return this.izPanelLayout instanceof GridBagLayout;
    }

    private boolean isIzPanel() {
        return this.izPanelLayout instanceof IzPanelLayout;
    }

    public void startLayout(LayoutManager2 layout) {
        if (this.layoutStarted) {
            return;
        }
        this.izPanelLayout = layout;
        if (this.isGridBag()) {
            this.startGridBagLayout();
            return;
        }
        if (this.isIzPanel()) {
            this.startIzPanelLayout();
        }
    }

    private void startIzPanelLayout() {
        IzPanelLayout.setAnchor(LayoutHelper.getAnchor());
        IzPanelLayout.setXStretchType(LayoutHelper.getXStretchType());
        IzPanelLayout.setYStretchType(LayoutHelper.getYStretchType());
        IzPanelLayout.setFullLineStretch(LayoutHelper.getFullLineStretch());
        IzPanelLayout.setFullColumnStretch(LayoutHelper.getFullColumnStretch());
        LayoutHelper.getXGap(-1);
        LayoutHelper.getYGap(-1);
        this.parent.setLayout(this.izPanelLayout);
    }

    public void completeLayout() {
        if (this.isGridBag()) {
            this.completeGridBagLayout();
        }
    }

    public Object getDefaultConstraints() {
        this.startLayout(this.izPanelLayout);
        return this.defaultConstraints;
    }

    public void setDefaultConstraints(Object constraints) {
        this.startLayout(this.izPanelLayout);
        if (this.isGridBag() && !(constraints instanceof GridBagConstraints) || this.isIzPanel() && !(constraints instanceof IzPanelConstraints)) {
            throw new IllegalArgumentException("Layout and constraints have to be from the same type.");
        }
        this.defaultConstraints = constraints;
    }

    public void resetGridCounter() {
        this.gridxCounter = -1;
        this.gridyCounter = -1;
    }

    public Object getNewConstraints(int gridx, int gridy) {
        if (this.isGridBag()) {
            GridBagConstraints retval = (GridBagConstraints)((GridBagConstraints)this.getDefaultConstraints()).clone();
            retval.gridx = gridx;
            retval.gridy = gridy;
            return retval;
        }
        if (this.isIzPanel()) {
            IzPanelConstraints retval = (IzPanelConstraints)((IzPanelConstraints)this.getDefaultConstraints()).clone();
            retval.setXPos(gridx);
            retval.setYPos(gridy);
            return retval;
        }
        return null;
    }

    public Object getNewConstraints(int gridx, int gridy, int gridwidth, int gridheight) {
        Cloneable gbc;
        Object retval = this.getNewConstraints(gridx, gridy);
        if (this.isGridBag()) {
            gbc = (GridBagConstraints)retval;
            ((GridBagConstraints)gbc).gridwidth = gridwidth;
            ((GridBagConstraints)gbc).gridheight = gridheight;
        }
        if (this.isIzPanel()) {
            gbc = (IzPanelConstraints)retval;
            ((IzPanelConstraints)gbc).setXWeight(gridwidth);
            ((IzPanelConstraints)gbc).setYWeight(gridheight);
        }
        return retval;
    }

    public Object getNextXConstraints() {
        ++this.gridxCounter;
        return this.getNewConstraints(this.gridxCounter, this.gridyCounter);
    }

    public Object getNextYConstraints() {
        ++this.gridyCounter;
        this.gridxCounter = 0;
        return this.getNewConstraints(0, this.gridyCounter);
    }

    public Object getNextYConstraints(int gridwidth, int gridheight) {
        ++this.gridyCounter;
        this.gridxCounter = 0;
        return this.getNewConstraints(0, this.gridyCounter, gridwidth, gridheight);
    }

    private void startGridBagLayout() {
        if (this.layoutStarted) {
            return;
        }
        this.layoutStarted = true;
        if (this.izPanelLayout == null || !(this.izPanelLayout instanceof GridBagLayout)) {
            this.izPanelLayout = new GridBagLayout();
        }
        GridBagConstraints dgbc = new GridBagConstraints();
        dgbc.insets = new Insets(0, 0, LayoutHelper.getYGap(-1), 0);
        dgbc.anchor = 17;
        this.defaultConstraints = dgbc;
        this.parent.setLayout(this.izPanelLayout);
        switch (LayoutHelper.getAnchor()) {
            case 5: 
            case 6: {
                IzPanel.Filler dummy = new IzPanel.Filler();
                GridBagConstraints gbConstraint = (GridBagConstraints)this.getNextYConstraints();
                gbConstraint.weighty = 1.0;
                gbConstraint.fill = 1;
                gbConstraint.anchor = 17;
                this.parent.add((Component)dummy, gbConstraint);
                break;
            }
        }
    }

    private void completeGridBagLayout() {
        switch (LayoutHelper.getAnchor()) {
            case 1: 
            case 8: {
                IzPanel.Filler dummy = new IzPanel.Filler();
                GridBagConstraints gbConstraint = (GridBagConstraints)this.getNextYConstraints();
                gbConstraint.weighty = 1.0;
                gbConstraint.fill = 1;
                gbConstraint.anchor = 17;
                this.parent.add((Component)dummy, gbConstraint);
                break;
            }
        }
    }

    public static int getAnchor() {
        if (ANCHOR >= 0) {
            return ANCHOR;
        }
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        String todo = idata instanceof InstallData && ((InstallData)idata).guiPrefs.modifier.containsKey("layoutAnchor") ? ((InstallData)idata).guiPrefs.modifier.get("layoutAnchor") : idata.getVariable("IzPanel.LayoutType");
        if (todo == null) {
            ANCHOR = 0;
        } else if ("EAST".equalsIgnoreCase(todo)) {
            ANCHOR = 3;
        } else if ("WEST".equalsIgnoreCase(todo)) {
            ANCHOR = 7;
        } else if ("TOP".equalsIgnoreCase(todo) || "NORTH".equalsIgnoreCase(todo)) {
            ANCHOR = 1;
        } else if ("BOTTOM".equalsIgnoreCase(todo) || "SOUTH".equalsIgnoreCase(todo)) {
            ANCHOR = 5;
        } else if ("SOUTHWEST".equalsIgnoreCase(todo) || "SOUTH_WEST".equalsIgnoreCase(todo)) {
            ANCHOR = 6;
        } else if ("SOUTHEAST".equalsIgnoreCase(todo) || "SOUTH_EAST".equalsIgnoreCase(todo)) {
            ANCHOR = 4;
        } else if ("NORTHWEST".equalsIgnoreCase(todo) || "NORTH_WEST".equalsIgnoreCase(todo)) {
            ANCHOR = 8;
        } else if ("NORTHEAST".equalsIgnoreCase(todo) || "NORTH_EAST".equalsIgnoreCase(todo)) {
            ANCHOR = 2;
        } else if ("CENTER".equalsIgnoreCase(todo)) {
            ANCHOR = 0;
        }
        return ANCHOR;
    }

    public static int getXGap(int gapId) {
        gapId = IzPanelLayout.verifyGapId(gapId);
        if (IzPanelLayout.getDefaultXGap(0) >= 0) {
            return IzPanelLayout.getDefaultXGap(gapId);
        }
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        if (!(idata instanceof InstallData)) {
            return IzPanelLayout.getDefaultXGap(gapId);
        }
        String var = null;
        InstallData id = (InstallData)idata;
        int commonDefault = -1;
        if (id.guiPrefs.modifier.containsKey(ALL_X_GAP)) {
            try {
                commonDefault = Integer.parseInt(id.guiPrefs.modifier.get(ALL_X_GAP));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        for (int i = 0; i < X_GAP_NAME_LOOK_UP.length; ++i) {
            int currentDefault = 0;
            if (commonDefault >= 0) {
                currentDefault = commonDefault;
            } else {
                var = id.guiPrefs.modifier.get(X_GAP_NAME_LOOK_UP[i]);
                if (var != null) {
                    try {
                        currentDefault = Integer.parseInt(var);
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
            }
            IzPanelLayout.setDefaultXGap(currentDefault, i);
        }
        IzPanelLayout.setDefaultXGap(0, 0);
        return IzPanelLayout.getDefaultXGap(gapId);
    }

    public static int getYGap(int gapId) {
        gapId = IzPanelLayout.verifyGapId(gapId);
        if (IzPanelLayout.getDefaultYGap(0) >= 0) {
            return IzPanelLayout.getDefaultYGap(gapId);
        }
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        if (!(idata instanceof InstallData)) {
            return IzPanelLayout.getDefaultYGap(gapId);
        }
        String var = null;
        InstallData id = (InstallData)idata;
        int commonDefault = -1;
        if (id.guiPrefs.modifier.containsKey(ALL_Y_GAP)) {
            try {
                commonDefault = Integer.parseInt(id.guiPrefs.modifier.get(ALL_Y_GAP));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        for (int i = 0; i < Y_GAP_NAME_LOOK_UP.length; ++i) {
            int currentDefault = 0;
            if (commonDefault >= 0) {
                currentDefault = commonDefault;
            } else {
                var = id.guiPrefs.modifier.get(Y_GAP_NAME_LOOK_UP[i]);
                if (var != null) {
                    try {
                        currentDefault = Integer.parseInt(var);
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
            }
            IzPanelLayout.setDefaultYGap(currentDefault, i);
        }
        IzPanelLayout.setDefaultYGap(0, 0);
        return IzPanelLayout.getDefaultYGap(gapId);
    }

    public static int getXStretchType() {
        if (X_STRETCH_TYPE > -1) {
            return X_STRETCH_TYPE;
        }
        X_STRETCH_TYPE = 2;
        String var = (String)LayoutHelper.getModifierValue(null, "RELATIVE_STRETCH", null, "layoutXStretchType");
        if (var != null) {
            if ("RELATIVE_STRETCH".equalsIgnoreCase(var) || "RELATIVE".equalsIgnoreCase(var)) {
                X_STRETCH_TYPE = 1;
            } else if ("ABSOLUTE_STRETCH".equalsIgnoreCase(var) || "ABSOLUTE".equalsIgnoreCase(var)) {
                X_STRETCH_TYPE = 2;
            } else if ("NO_STRETCH".equalsIgnoreCase(var) || "NO".equalsIgnoreCase(var)) {
                X_STRETCH_TYPE = 0;
            }
        }
        return X_STRETCH_TYPE;
    }

    public static int getYStretchType() {
        if (Y_STRETCH_TYPE > -1) {
            return Y_STRETCH_TYPE;
        }
        Y_STRETCH_TYPE = 2;
        String var = (String)LayoutHelper.getModifierValue(null, "RELATIVE_STRETCH", null, "layoutYStretchType");
        if (var != null) {
            if ("RELATIVE_STRETCH".equalsIgnoreCase(var) || "RELATIVE".equalsIgnoreCase(var)) {
                Y_STRETCH_TYPE = 1;
            } else if ("ABSOLUTE_STRETCH".equalsIgnoreCase(var) || "ABSOLUTE".equalsIgnoreCase(var)) {
                Y_STRETCH_TYPE = 2;
            } else if ("NO_STRETCH".equalsIgnoreCase(var) || "NO".equalsIgnoreCase(var)) {
                Y_STRETCH_TYPE = 0;
            }
        }
        return Y_STRETCH_TYPE;
    }

    public static double getFullLineStretch() {
        FULL_LINE_STRETCH_DEFAULT = (Double)LayoutHelper.getModifierValue(FULL_LINE_STRETCH_DEFAULT, INITIAL_STRETCH_DEFAULT, DOUBLE_ZERO, "layoutFullLineStretch");
        return FULL_LINE_STRETCH_DEFAULT;
    }

    public static double getFullColumnStretch() {
        FULL_COLUMN_STRETCH_DEFAULT = (Double)LayoutHelper.getModifierValue(FULL_COLUMN_STRETCH_DEFAULT, INITIAL_STRETCH_DEFAULT, DOUBLE_ZERO, "layoutFullColumnStretch");
        return FULL_COLUMN_STRETCH_DEFAULT;
    }

    private static Object getModifierValue(Object currentVal, Object defaultVal, Object readLimit, String key) {
        if (defaultVal instanceof Integer && (Integer)currentVal >= (Integer)readLimit) {
            return currentVal;
        }
        if (defaultVal instanceof Double && (Double)currentVal >= (Double)readLimit) {
            return currentVal;
        }
        Object retval = defaultVal;
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        if (!(idata instanceof InstallData)) {
            return retval;
        }
        String var = null;
        if (((InstallData)idata).guiPrefs.modifier.containsKey(key) && (var = ((InstallData)idata).guiPrefs.modifier.get(key)) != null) {
            try {
                if (defaultVal instanceof Integer) {
                    return Integer.parseInt(var);
                }
                if (defaultVal instanceof Double) {
                    return Double.parseDouble(var);
                }
                return var;
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return retval;
    }

    public LayoutManager2 getLayout() {
        return this.izPanelLayout;
    }

    public void setLayout(LayoutManager2 izPanelLayout) {
        this.izPanelLayout = izPanelLayout;
    }
}

