/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.geom.AffineTransform;
import java.util.StringTokenizer;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.ErrorConstants;
import org.apache.batik.dom.svg.LiveAttributeException;
import org.apache.batik.dom.svg.SVGOMAnimatedRect;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.parser.AWTTransformProducer;
import org.apache.batik.parser.FragmentIdentifierHandler;
import org.apache.batik.parser.FragmentIdentifierParser;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.PreserveAspectRatioHandler;
import org.apache.batik.parser.PreserveAspectRatioParser;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGAnimatedPreserveAspectRatio;
import org.w3c.dom.svg.SVGAnimatedRect;
import org.w3c.dom.svg.SVGPreserveAspectRatio;
import org.w3c.dom.svg.SVGRect;

public abstract class ViewBox
implements SVGConstants,
ErrorConstants {
    protected ViewBox() {
    }

    public static AffineTransform getViewTransform(String string, Element element, float f, float f2, BridgeContext bridgeContext) {
        Object object;
        boolean bl;
        short s;
        float[] fArray;
        Node node;
        if (string == null || string.length() == 0) {
            return ViewBox.getPreserveAspectRatioTransform(element, f, f2, bridgeContext);
        }
        ViewHandler viewHandler = new ViewHandler();
        FragmentIdentifierParser fragmentIdentifierParser = new FragmentIdentifierParser();
        fragmentIdentifierParser.setFragmentIdentifierHandler((FragmentIdentifierHandler)viewHandler);
        fragmentIdentifierParser.parse(string);
        Element element2 = element;
        if (viewHandler.hasId) {
            node = element.getOwnerDocument();
            element2 = node.getElementById(viewHandler.id);
        }
        if (element2 == null) {
            throw new BridgeException(bridgeContext, element, "uri.malformed", new Object[]{string});
        }
        if (!element2.getNamespaceURI().equals("http://www.w3.org/2000/svg") || !element2.getLocalName().equals("view")) {
            element2 = null;
        }
        node = ViewBox.getClosestAncestorSVGElement(element);
        if (viewHandler.hasViewBox) {
            fArray = viewHandler.viewBox;
        } else {
            Node node2 = DOMUtilities.isAttributeSpecifiedNS((Element)element2, null, (String)"viewBox") ? element2 : node;
            String string2 = node2.getAttributeNS(null, "viewBox");
            fArray = ViewBox.parseViewBoxAttribute((Element)node2, string2, bridgeContext);
        }
        if (viewHandler.hasPreserveAspectRatio) {
            s = viewHandler.align;
            bl = viewHandler.meet;
        } else {
            object = DOMUtilities.isAttributeSpecifiedNS((Element)element2, null, (String)"preserveAspectRatio") ? element2 : node;
            String string3 = object.getAttributeNS(null, "preserveAspectRatio");
            PreserveAspectRatioParser preserveAspectRatioParser = new PreserveAspectRatioParser();
            ViewHandler viewHandler2 = new ViewHandler();
            preserveAspectRatioParser.setPreserveAspectRatioHandler((PreserveAspectRatioHandler)viewHandler2);
            try {
                preserveAspectRatioParser.parse(string3);
            }
            catch (ParseException parseException) {
                throw new BridgeException(bridgeContext, (Element)object, (Exception)((Object)parseException), "attribute.malformed", new Object[]{"preserveAspectRatio", string3, parseException});
            }
            s = viewHandler2.align;
            bl = viewHandler2.meet;
        }
        object = ViewBox.getPreserveAspectRatioTransform(fArray, s, bl, f, f2);
        if (viewHandler.hasTransform) {
            ((AffineTransform)object).concatenate(viewHandler.getAffineTransform());
        }
        return object;
    }

    private static Element getClosestAncestorSVGElement(Element element) {
        for (Node node = element; node != null && node.getNodeType() == 1; node = node.getParentNode()) {
            Element element2 = node;
            if (!element2.getNamespaceURI().equals("http://www.w3.org/2000/svg") || !element2.getLocalName().equals("svg")) continue;
            return element2;
        }
        return null;
    }

    public static AffineTransform getPreserveAspectRatioTransform(Element element, float f, float f2) {
        return ViewBox.getPreserveAspectRatioTransform(element, f, f2, null);
    }

    public static AffineTransform getPreserveAspectRatioTransform(Element element, float f, float f2, BridgeContext bridgeContext) {
        String string = element.getAttributeNS(null, "viewBox");
        String string2 = element.getAttributeNS(null, "preserveAspectRatio");
        return ViewBox.getPreserveAspectRatioTransform(element, string, string2, f, f2, bridgeContext);
    }

    public static AffineTransform getPreserveAspectRatioTransform(Element element, String string, String string2, float f, float f2, BridgeContext bridgeContext) {
        if (string.length() == 0) {
            return new AffineTransform();
        }
        float[] fArray = ViewBox.parseViewBoxAttribute(element, string, bridgeContext);
        PreserveAspectRatioParser preserveAspectRatioParser = new PreserveAspectRatioParser();
        ViewHandler viewHandler = new ViewHandler();
        preserveAspectRatioParser.setPreserveAspectRatioHandler((PreserveAspectRatioHandler)viewHandler);
        try {
            preserveAspectRatioParser.parse(string2);
        }
        catch (ParseException parseException) {
            throw new BridgeException(bridgeContext, element, (Exception)((Object)parseException), "attribute.malformed", new Object[]{"preserveAspectRatio", string2, parseException});
        }
        return ViewBox.getPreserveAspectRatioTransform(fArray, viewHandler.align, viewHandler.meet, f, f2);
    }

    public static AffineTransform getPreserveAspectRatioTransform(Element element, float[] fArray, float f, float f2, BridgeContext bridgeContext) {
        String string = element.getAttributeNS(null, "preserveAspectRatio");
        PreserveAspectRatioParser preserveAspectRatioParser = new PreserveAspectRatioParser();
        ViewHandler viewHandler = new ViewHandler();
        preserveAspectRatioParser.setPreserveAspectRatioHandler((PreserveAspectRatioHandler)viewHandler);
        try {
            preserveAspectRatioParser.parse(string);
        }
        catch (ParseException parseException) {
            throw new BridgeException(bridgeContext, element, (Exception)((Object)parseException), "attribute.malformed", new Object[]{"preserveAspectRatio", string, parseException});
        }
        return ViewBox.getPreserveAspectRatioTransform(fArray, viewHandler.align, viewHandler.meet, f, f2);
    }

    public static AffineTransform getPreserveAspectRatioTransform(Element element, float[] fArray, float f, float f2, SVGAnimatedPreserveAspectRatio sVGAnimatedPreserveAspectRatio, BridgeContext bridgeContext) {
        try {
            SVGPreserveAspectRatio sVGPreserveAspectRatio = sVGAnimatedPreserveAspectRatio.getAnimVal();
            short s = sVGPreserveAspectRatio.getAlign();
            boolean bl = sVGPreserveAspectRatio.getMeetOrSlice() == 1;
            return ViewBox.getPreserveAspectRatioTransform(fArray, s, bl, f, f2);
        }
        catch (LiveAttributeException liveAttributeException) {
            throw new BridgeException(bridgeContext, liveAttributeException);
        }
    }

    public static AffineTransform getPreserveAspectRatioTransform(Element element, SVGAnimatedRect sVGAnimatedRect, SVGAnimatedPreserveAspectRatio sVGAnimatedPreserveAspectRatio, float f, float f2, BridgeContext bridgeContext) {
        if (!((SVGOMAnimatedRect)sVGAnimatedRect).isSpecified()) {
            return new AffineTransform();
        }
        SVGRect sVGRect = sVGAnimatedRect.getAnimVal();
        float[] fArray = new float[]{sVGRect.getX(), sVGRect.getY(), sVGRect.getWidth(), sVGRect.getHeight()};
        return ViewBox.getPreserveAspectRatioTransform(element, fArray, f, f2, sVGAnimatedPreserveAspectRatio, bridgeContext);
    }

    public static float[] parseViewBoxAttribute(Element element, String string, BridgeContext bridgeContext) {
        int n;
        if (string.length() == 0) {
            return null;
        }
        float[] fArray = new float[4];
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        try {
            for (n = 0; n < 4 && stringTokenizer.hasMoreTokens(); ++n) {
                fArray[n] = Float.parseFloat(stringTokenizer.nextToken());
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new BridgeException(bridgeContext, element, numberFormatException, "attribute.malformed", new Object[]{"viewBox", string, numberFormatException});
        }
        if (n != 4) {
            throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{"viewBox", string});
        }
        if (fArray[2] < 0.0f || fArray[3] < 0.0f) {
            throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{"viewBox", string});
        }
        if (fArray[2] == 0.0f || fArray[3] == 0.0f) {
            return null;
        }
        return fArray;
    }

    public static AffineTransform getPreserveAspectRatioTransform(float[] fArray, short s, boolean bl, float f, float f2) {
        if (fArray == null) {
            return new AffineTransform();
        }
        AffineTransform affineTransform = new AffineTransform();
        float f3 = fArray[2] / fArray[3];
        float f4 = f / f2;
        if (s == 1) {
            affineTransform.scale(f / fArray[2], f2 / fArray[3]);
            affineTransform.translate(-fArray[0], -fArray[1]);
        } else if (f3 < f4 && bl || f3 >= f4 && !bl) {
            float f5 = f2 / fArray[3];
            affineTransform.scale(f5, f5);
            switch (s) {
                case 2: 
                case 5: 
                case 8: {
                    affineTransform.translate(-fArray[0], -fArray[1]);
                    break;
                }
                case 3: 
                case 6: 
                case 9: {
                    affineTransform.translate(-fArray[0] - (fArray[2] - f * fArray[3] / f2) / 2.0f, -fArray[1]);
                    break;
                }
                default: {
                    affineTransform.translate(-fArray[0] - (fArray[2] - f * fArray[3] / f2), -fArray[1]);
                    break;
                }
            }
        } else {
            float f6 = f / fArray[2];
            affineTransform.scale(f6, f6);
            switch (s) {
                case 2: 
                case 3: 
                case 4: {
                    affineTransform.translate(-fArray[0], -fArray[1]);
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    affineTransform.translate(-fArray[0], -fArray[1] - (fArray[3] - f2 * fArray[2] / f) / 2.0f);
                    break;
                }
                default: {
                    affineTransform.translate(-fArray[0], -fArray[1] - (fArray[3] - f2 * fArray[2] / f));
                }
            }
        }
        return affineTransform;
    }

    protected static class ViewHandler
    extends AWTTransformProducer
    implements FragmentIdentifierHandler {
        public boolean hasTransform;
        public boolean hasId;
        public boolean hasViewBox;
        public boolean hasViewTargetParams;
        public boolean hasZoomAndPanParams;
        public String id;
        public float[] viewBox;
        public String viewTargetParams;
        public boolean isMagnify;
        public boolean hasPreserveAspectRatio;
        public short align;
        public boolean meet = true;

        protected ViewHandler() {
        }

        public void endTransformList() throws ParseException {
            super.endTransformList();
            this.hasTransform = true;
        }

        public void startFragmentIdentifier() throws ParseException {
        }

        public void idReference(String string) throws ParseException {
            this.id = string;
            this.hasId = true;
        }

        public void viewBox(float f, float f2, float f3, float f4) throws ParseException {
            this.hasViewBox = true;
            this.viewBox = new float[4];
            this.viewBox[0] = f;
            this.viewBox[1] = f2;
            this.viewBox[2] = f3;
            this.viewBox[3] = f4;
        }

        public void startViewTarget() throws ParseException {
        }

        public void viewTarget(String string) throws ParseException {
            this.viewTargetParams = string;
            this.hasViewTargetParams = true;
        }

        public void endViewTarget() throws ParseException {
        }

        public void zoomAndPan(boolean bl) {
            this.isMagnify = bl;
            this.hasZoomAndPanParams = true;
        }

        public void endFragmentIdentifier() throws ParseException {
        }

        public void startPreserveAspectRatio() throws ParseException {
        }

        public void none() throws ParseException {
            this.align = 1;
        }

        public void xMaxYMax() throws ParseException {
            this.align = (short)10;
        }

        public void xMaxYMid() throws ParseException {
            this.align = (short)7;
        }

        public void xMaxYMin() throws ParseException {
            this.align = (short)4;
        }

        public void xMidYMax() throws ParseException {
            this.align = (short)9;
        }

        public void xMidYMid() throws ParseException {
            this.align = (short)6;
        }

        public void xMidYMin() throws ParseException {
            this.align = (short)3;
        }

        public void xMinYMax() throws ParseException {
            this.align = (short)8;
        }

        public void xMinYMid() throws ParseException {
            this.align = (short)5;
        }

        public void xMinYMin() throws ParseException {
            this.align = (short)2;
        }

        public void meet() throws ParseException {
            this.meet = true;
        }

        public void slice() throws ParseException {
            this.meet = false;
        }

        public void endPreserveAspectRatio() throws ParseException {
            this.hasPreserveAspectRatio = true;
        }
    }
}

