/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.Builder;
import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.GameSetupStep;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.configure.Configurer;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.configure.StringEnumConfigurer;
import VASSAL.i18n.Localization;
import VASSAL.i18n.Resources;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayerRoster
extends AbstractConfigurable
implements CommandEncoder,
GameComponent,
GameSetupStep {
    public static final String BUTTON_ICON = "buttonIcon";
    public static final String BUTTON_TEXT = "buttonText";
    public static final String TOOL_TIP = "buttonToolTip";
    public static final String SIDES = "sides";
    public static final String COMMAND_PREFIX = "PLAYER\t";
    public static final String OBSERVER = "<observer>";
    protected List<PlayerInfo> players = new ArrayList<PlayerInfo>();
    protected List<String> sides = new ArrayList<String>();
    protected String[] untranslatedSides;
    protected LaunchButton retireButton;
    protected List<SideChangeListener> sideChangeListeners = new ArrayList<SideChangeListener>();
    protected String translatedObserver;
    private boolean pickedSide = false;
    protected StringEnumConfigurer sideConfig;

    public PlayerRoster() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlayerRoster.this.launch();
            }
        };
        this.retireButton = new LaunchButton(Resources.getString("PlayerRoster.retire"), TOOL_TIP, BUTTON_TEXT, null, BUTTON_ICON, actionListener);
        this.retireButton.setToolTipText(Resources.getString("PlayerRoster.allow_another"));
        this.retireButton.setVisible(false);
        this.translatedObserver = Resources.getString("PlayerRoster.observer");
    }

    @Override
    public void removeFrom(Buildable buildable) {
        GameModule.getGameModule().getGameState().removeGameComponent(this);
        GameModule.getGameModule().removeCommandEncoder(this);
    }

    @Override
    public void remove(Buildable buildable) {
    }

    @Override
    public void build(Element element) {
        if (element != null) {
            NamedNodeMap namedNodeMap = element.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                if (BUTTON_ICON.equals(attr.getName()) && "Retire".equals(attr.getValue())) {
                    try {
                        GameModule.getGameModule().getDataArchive().getInputStream("images/" + attr.getValue());
                    }
                    catch (IOException iOException) {
                        continue;
                    }
                }
                this.retireButton.setAttribute(attr.getName(), attr.getValue());
                Localization.getInstance().saveTranslatableAttribute(this, attr.getName(), attr.getValue());
            }
            NodeList nodeList = element.getElementsByTagName("*");
            this.sides.clear();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element2 = (Element)nodeList.item(i);
                this.sides.add(Builder.getText(element2));
            }
            Localization.getInstance().saveTranslatableAttribute(this, SIDES, this.getSidesAsString());
        }
    }

    @Override
    public String getConfigureName() {
        return null;
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.PlayerRoster.component_type");
    }

    @Override
    public void add(Buildable buildable) {
    }

    @Override
    public Configurable[] getConfigureComponents() {
        return new Configurable[0];
    }

    @Override
    public Element getBuildElement(Document document) {
        Element element = document.createElement(this.getClass().getName());
        String string = this.retireButton.getAttributeValueString(BUTTON_TEXT);
        if (string != null) {
            element.setAttribute(BUTTON_TEXT, string);
        }
        if ((string = this.retireButton.getAttributeValueString(BUTTON_ICON)) != null) {
            element.setAttribute(BUTTON_ICON, string);
        }
        if ((string = this.retireButton.getAttributeValueString(TOOL_TIP)) != null) {
            element.setAttribute(TOOL_TIP, string);
        }
        for (String string2 : this.sides) {
            Element element2 = document.createElement("entry");
            element2.appendChild(document.createTextNode(string2));
            element.appendChild(element2);
        }
        return element;
    }

    @Override
    public Configurer getConfigurer() {
        return new Con();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public static void addSideChangeListener(SideChangeListener sideChangeListener) {
        PlayerRoster playerRoster = PlayerRoster.getInstance();
        if (playerRoster != null) {
            playerRoster.sideChangeListeners.add(sideChangeListener);
        }
    }

    public static void removeSideChangeListener(SideChangeListener sideChangeListener) {
        PlayerRoster playerRoster = PlayerRoster.getInstance();
        if (playerRoster != null) {
            playerRoster.sideChangeListeners.remove(sideChangeListener);
        }
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GameModule.htm", "Definition_of_Player_Sides");
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public void addTo(Buildable buildable) {
        GameModule.getGameModule().getGameState().addGameComponent(this);
        GameModule.getGameModule().getGameState().addGameSetupStep(this);
        GameModule.getGameModule().addCommandEncoder(this);
        GameModule.getGameModule().getToolBar().add(this.retireButton);
    }

    protected void launch() {
        Object[] objectArray;
        String string = PlayerRoster.getMySide();
        if (string == null && this.allSidesAllocated()) {
            return;
        }
        if (this.allSidesAllocated()) {
            Object[] objectArray2 = new String[2];
            objectArray2[0] = Resources.getString("General.yes");
            objectArray = objectArray2;
            objectArray2[1] = Resources.getString("General.no");
        } else {
            String[] stringArray = new String[3];
            stringArray[0] = Resources.getString("PlayerRoster.become_observer");
            stringArray[1] = Resources.getString("PlayerRoster.join_another_side");
            objectArray = stringArray;
            stringArray[2] = Resources.getString("General.cancel");
        }
        Object[] objectArray3 = objectArray;
        int n = objectArray3.length - 1;
        int n2 = JOptionPane.showOptionDialog(GameModule.getGameModule().getFrame(), Resources.getString("PlayerRoster.give_up_position", PlayerRoster.getMyLocalizedSide()), Resources.getString("PlayerRoster.retire"), 0, 3, null, objectArray3, Resources.getString("PlayerRoster.become_observer"));
        if (n2 != n) {
            String string2;
            String string3 = PlayerRoster.getMySide();
            if (n2 == 0) {
                string2 = OBSERVER;
            } else {
                string2 = this.promptForSide();
                if (string2 == null) {
                    return;
                }
            }
            this.remove(GameModule.getUserId());
            PlayerInfo playerInfo = new PlayerInfo(GameModule.getUserId(), GlobalOptions.getInstance().getPlayerId(), string2);
            Add add = new Add(this, playerInfo.playerId, playerInfo.playerName, playerInfo.side);
            add.execute();
            GameModule.getGameModule().getServer().sendToOthers(add);
            string2 = PlayerRoster.getMySide();
            this.fireSideChange(string3, string2);
        }
    }

    protected void fireSideChange(String string, String string2) {
        for (SideChangeListener sideChangeListener : this.sideChangeListeners) {
            sideChangeListener.sideChanged(string, string2);
        }
    }

    public static boolean isActive() {
        return PlayerRoster.getInstance() != null;
    }

    protected static PlayerRoster getInstance() {
        Iterator<PlayerRoster> iterator = GameModule.getGameModule().getComponentsOf(PlayerRoster.class).iterator();
        if (iterator.hasNext()) {
            PlayerRoster playerRoster = iterator.next();
            return playerRoster;
        }
        return null;
    }

    public static String getMySide() {
        return PlayerRoster.getMySide(false);
    }

    public static String getMyLocalizedSide() {
        return PlayerRoster.getMySide(true);
    }

    protected static String getMySide(boolean bl) {
        PlayerRoster playerRoster = PlayerRoster.getInstance();
        if (playerRoster != null) {
            for (PlayerInfo playerInfo : playerRoster.getPlayers()) {
                if (!playerInfo.playerId.equals(GameModule.getUserId())) continue;
                return bl ? playerInfo.getLocalizedSide() : playerInfo.getSide();
            }
        }
        return null;
    }

    public PlayerInfo[] getPlayers() {
        return this.players.toArray(new PlayerInfo[this.players.size()]);
    }

    public void add(String string, String string2, String string3) {
        PlayerInfo playerInfo = new PlayerInfo(string, string2, string3);
        if (this.players.contains(playerInfo)) {
            this.players.set(this.players.indexOf(playerInfo), playerInfo);
        } else {
            this.players.add(playerInfo);
        }
    }

    public void remove(String string) {
        PlayerInfo playerInfo = new PlayerInfo(string, null, null);
        this.players.remove(playerInfo);
    }

    @Override
    public Command decode(String string) {
        if (string.startsWith(COMMAND_PREFIX)) {
            SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, '\t');
            decoder.nextToken();
            return new Add(this, decoder.nextToken(), decoder.nextToken(), decoder.nextToken());
        }
        return null;
    }

    @Override
    public String encode(Command command) {
        if (command instanceof Add) {
            Add add = (Add)command;
            SequenceEncoder sequenceEncoder = new SequenceEncoder('\t');
            sequenceEncoder.append(add.id).append(add.name).append(add.side);
            return COMMAND_PREFIX + sequenceEncoder.getValue();
        }
        return null;
    }

    @Override
    public Command getRestoreCommand() {
        Add add = null;
        for (PlayerInfo playerInfo : this.players) {
            Add add2 = new Add(this, playerInfo.playerId, playerInfo.playerName, playerInfo.side);
            add = add == null ? add2 : add.append(add2);
        }
        return add;
    }

    @Override
    public void setup(boolean bl) {
        if (bl) {
            PlayerInfo playerInfo = new PlayerInfo(GameModule.getUserId(), GlobalOptions.getInstance().getPlayerId(), null);
            if (this.players.contains(playerInfo)) {
                PlayerInfo playerInfo2 = this.players.get(this.players.indexOf(playerInfo));
                playerInfo2.playerName = playerInfo.playerName;
            }
        } else {
            this.players.clear();
        }
        this.retireButton.setVisible(bl && PlayerRoster.getMySide() != null);
        this.pickedSide = false;
    }

    @Override
    public void finish() {
        String string = this.untranslateSide(this.sideConfig.getValueString());
        if (string != null) {
            Add add = new Add(this, GameModule.getUserId(), GlobalOptions.getInstance().getPlayerId(), string);
            add.execute();
            GameModule.getGameModule().getServer().sendToOthers(add);
        }
        this.retireButton.setVisible(PlayerRoster.getMySide() != null);
        this.pickedSide = true;
    }

    @Override
    public Component getControls() {
        ArrayList<String> arrayList = new ArrayList<String>(this.sides);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (PlayerInfo playerInfo : this.players) {
            arrayList2.add(playerInfo.side);
        }
        arrayList.removeAll(arrayList2);
        arrayList.add(0, this.translatedObserver);
        this.sideConfig = new StringEnumConfigurer(null, Resources.getString("PlayerRoster.join_game_as"), arrayList.toArray(new String[arrayList.size()]));
        this.sideConfig.setValue(this.translatedObserver);
        return this.sideConfig.getControls();
    }

    @Override
    public String getStepTitle() {
        return Resources.getString("PlayerRoster.choose_side");
    }

    @Override
    public boolean isFinished() {
        if (this.pickedSide) {
            return true;
        }
        if (this.allSidesAllocated()) {
            return true;
        }
        PlayerInfo playerInfo = new PlayerInfo(GameModule.getUserId(), GlobalOptions.getInstance().getPlayerId(), null);
        int n = this.players.indexOf(playerInfo);
        if (n != -1) {
            return !OBSERVER.equals(this.players.get(n).getSide());
        }
        return false;
    }

    protected boolean allSidesAllocated() {
        int n = 0;
        for (PlayerInfo playerInfo : this.players) {
            if (OBSERVER.equals(playerInfo.getSide())) continue;
            ++n;
        }
        return this.sides.size() == n;
    }

    /*
     * WARNING - void declaration
     */
    protected String promptForSide() {
        void var4_7;
        ArrayList<String> arrayList = new ArrayList<String>(this.sides);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (PlayerInfo object2 : this.players) {
            arrayList2.add(object2.side);
        }
        arrayList.removeAll(arrayList2);
        arrayList.add(0, this.translatedObserver);
        GameModule gameModule = GameModule.getGameModule();
        String string = (String)JOptionPane.showInputDialog(gameModule.getFrame(), Resources.getString("PlayerRoster.join_game_as"), Resources.getString("PlayerRoster.choose_side"), 3, null, arrayList.toArray(new String[arrayList.size()]), this.translatedObserver);
        if (this.translatedObserver.equals(string)) {
            String string2 = OBSERVER;
        }
        return var4_7;
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{BUTTON_TEXT, TOOL_TIP, SIDES};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, String.class, String.class};
    }

    @Override
    public String getAttributeValueString(String string) {
        if (SIDES.equals(string)) {
            return this.getSidesAsString();
        }
        return this.retireButton.getAttributeValueString(string);
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (SIDES.equals(string)) {
            this.untranslatedSides = this.sides.toArray(new String[this.sides.size()]);
            String[] stringArray = StringArrayConfigurer.stringToArray((String)object);
            this.sides = new ArrayList<String>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                this.sides.add(stringArray[i]);
            }
        } else {
            this.retireButton.setAttribute(string, object);
        }
    }

    protected String getSidesAsString() {
        String[] stringArray = this.sides.toArray(new String[this.sides.size()]);
        return StringArrayConfigurer.arrayToString(stringArray);
    }

    protected String untranslateSide(String string) {
        if (this.translatedObserver.equals(string)) {
            return OBSERVER;
        }
        if (this.untranslatedSides != null) {
            for (int i = 0; i < this.sides.size(); ++i) {
                if (!this.sides.get(i).equals(string)) continue;
                return this.untranslatedSides[i];
            }
        }
        return string;
    }

    protected String translateSide(String string) {
        if (OBSERVER.equals(string)) {
            return this.translatedObserver;
        }
        if (this.untranslatedSides != null) {
            for (int i = 0; i < this.untranslatedSides.length; ++i) {
                if (!this.untranslatedSides[i].equals(string)) continue;
                return this.sides.get(i);
            }
        }
        return string;
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.button_text_label"), Resources.getString("Editor.tooltip_text_label"), Resources.getString("Editor.PlayerRoster.sides_label")};
    }

    public static interface SideChangeListener {
        public void sideChanged(String var1, String var2);
    }

    private class Con
    extends Configurer {
        private StringArrayConfigurer sidesConfig;
        private IconConfigurer iconConfig;
        private StringConfigurer textConfig;
        private StringConfigurer tooltipConfig;
        private JPanel controls;

        private Con() {
            super(null, null);
            this.controls = new JPanel();
            this.controls.setLayout(new BoxLayout(this.controls, 1));
            this.sidesConfig = new StringArrayConfigurer(null, Resources.getString("Editor.PlayerRoster.sides_available"), PlayerRoster.this.sides.toArray(new String[PlayerRoster.this.sides.size()]));
            this.sidesConfig.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    PlayerRoster.this.sides.clear();
                    PlayerRoster.this.sides.addAll(Arrays.asList(Con.this.sidesConfig.getStringArray()));
                }
            });
            this.controls.add(this.sidesConfig.getControls());
            this.textConfig = new StringConfigurer(PlayerRoster.BUTTON_TEXT, Resources.getString("Editor.PlayerRoster.retire_button_text"), PlayerRoster.this.retireButton.getAttributeValueString(PlayerRoster.BUTTON_TEXT));
            this.textConfig.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    PlayerRoster.this.retireButton.setAttribute(PlayerRoster.BUTTON_TEXT, Con.this.textConfig.getValueString());
                }
            });
            this.controls.add(this.textConfig.getControls());
            this.tooltipConfig = new StringConfigurer(PlayerRoster.TOOL_TIP, Resources.getString("Editor.PlayerRoster.retire_button_tooltip"), PlayerRoster.this.retireButton.getAttributeValueString(PlayerRoster.TOOL_TIP));
            this.tooltipConfig.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    PlayerRoster.this.retireButton.setAttribute(PlayerRoster.TOOL_TIP, Con.this.tooltipConfig.getValueString());
                }
            });
            this.controls.add(this.tooltipConfig.getControls());
            this.iconConfig = new IconConfigurer(PlayerRoster.BUTTON_ICON, Resources.getString("Editor.PlayerRoster.retire_button_icon"), null);
            this.iconConfig.setValue(PlayerRoster.this.retireButton.getIcon());
            this.iconConfig.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    PlayerRoster.this.retireButton.setAttribute(PlayerRoster.BUTTON_ICON, Con.this.iconConfig.getValueString());
                }
            });
            this.controls.add(this.iconConfig.getControls());
        }

        public String getValueString() {
            return null;
        }

        public void setValue(String string) {
        }

        public Component getControls() {
            return this.controls;
        }
    }

    public static class Add
    extends Command {
        private PlayerRoster roster;
        private String id;
        private String name;
        private String side;

        public Add(PlayerRoster playerRoster, String string, String string2, String string3) {
            this.roster = playerRoster;
            this.id = string;
            this.name = string2;
            this.side = string3;
        }

        protected void executeCommand() {
            this.roster.add(this.id, this.name, this.side);
        }

        protected Command myUndoCommand() {
            return null;
        }
    }

    public static class PlayerInfo {
        public String playerId;
        public String playerName;
        private String side;

        public PlayerInfo(String string, String string2, String string3) {
            if (string == null) {
                throw new NullPointerException("Player id cannot be null");
            }
            this.playerId = string;
            this.playerName = string2;
            this.side = string3;
        }

        public boolean equals(Object object) {
            if (object instanceof PlayerInfo && this.playerId != null) {
                return this.playerId.equals(((PlayerInfo)object).playerId);
            }
            return false;
        }

        public String getSide() {
            return this.side;
        }

        public String getLocalizedSide() {
            return PlayerRoster.getInstance().translateSide(this.side);
        }
    }
}

