/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.module.SpecialDiceButton;
import VASSAL.build.module.SpecialDieFace;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.configure.Configurer;
import VASSAL.configure.FormattedStringConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatableConfigurerFactory;
import VASSAL.tools.FormattedString;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecialDie
extends AbstractConfigurable {
    private static final Logger logger = LoggerFactory.getLogger(SpecialDie.class);
    private List<SpecialDieFace> dieFaceList = new ArrayList<SpecialDieFace>();
    private FormattedString format = new FormattedString("$result$");
    public static final String NAME = "name";
    public static final String FORMAT = "format";
    public static final String RESULT = "result";
    public static final String NUMERICAL_VALUE = "numericalValue";

    public void addFace(SpecialDieFace specialDieFace) {
        this.dieFaceList.add(specialDieFace);
    }

    public void removeFace(SpecialDieFace specialDieFace) {
        this.dieFaceList.remove(specialDieFace);
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.SpecialDie.component_type");
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.name_label"), Resources.getString("Editor.SpecialDie.result_format")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, ResultFormatConfig.class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, FORMAT};
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (NAME.equals(string)) {
            this.setConfigureName((String)object);
        } else if (FORMAT.equals(string)) {
            this.format.setFormat((String)object);
        }
    }

    @Override
    public String getAttributeValueString(String string) {
        if (NAME.equals(string)) {
            return this.getConfigureName();
        }
        if (FORMAT.equals(string)) {
            return this.format.getFormat();
        }
        return null;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GameModule.htm", "SpecialDiceButton");
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[]{SpecialDieFace.class};
    }

    @Override
    public void addTo(Buildable buildable) {
        ((SpecialDiceButton)buildable).addSpecialDie(this);
    }

    @Override
    public void removeFrom(Buildable buildable) {
        ((SpecialDiceButton)buildable).removeSpecialDie(this);
    }

    public int getFaceCount() {
        return this.dieFaceList.size();
    }

    public String getTextValue(int n) {
        this.format.setProperty(NAME, this.getLocalizedConfigureName());
        int n2 = this.getFaceCount();
        if (n < 0 || n >= n2) {
            this.format.setProperty(RESULT, "undefined");
            this.format.setProperty(NUMERICAL_VALUE, "0");
            logger.warn("Special Die (" + this.getConfigureName() + "): no such face " + n);
        } else {
            SpecialDieFace specialDieFace = this.dieFaceList.get(n);
            this.format.setProperty(RESULT, specialDieFace.getTextValue());
            this.format.setProperty(NUMERICAL_VALUE, specialDieFace.getIntValue() + "");
        }
        return this.format.getLocalizedText();
    }

    public int getIntValue(int n) {
        int n2 = this.getFaceCount();
        if (n < 0 || n >= n2) {
            logger.warn("Special Die (" + this.getConfigureName() + "): no such face " + n);
            return 0;
        }
        return this.dieFaceList.get(n).getIntValue();
    }

    public String getImageName(int n) {
        int n2 = this.getFaceCount();
        if (n < 0 || n >= n2) {
            logger.warn("Special Die (" + this.getConfigureName() + "): no such face " + n);
            return "";
        }
        return this.dieFaceList.get(n).getImageName();
    }

    public static class ResultFormatConfig
    implements TranslatableConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new FormattedStringConfigurer(string, string2, new String[]{SpecialDie.NAME, SpecialDie.RESULT, SpecialDie.NUMERICAL_VALUE});
        }
    }
}

