/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.gamepieceimage.ColorSwatch;
import VASSAL.build.module.gamepieceimage.FontStyle;
import VASSAL.build.module.gamepieceimage.OutlineFont;
import VASSAL.configure.Configurer;
import VASSAL.configure.SingleChildInstance;
import java.awt.GraphicsEnvironment;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontManager
extends AbstractConfigurable {
    protected static FontManager instance;
    protected Map<String, FontStyle> fontStyles = new HashMap<String, FontStyle>();
    public static final String DIALOG = "Dialog";
    public static final String SERIF = "Serif";
    public static final String SANS_SERIF = "SanSerif";
    public static final String DIALOG_INPUT = "DialogInput";
    public static final String MONOSPACED = "Monospaced";
    public static final String DEFAULT = "Default";
    public static final OutlineFont DEFAULT_FONT;
    public static final FontStyle DEFAULT_STYLE;
    public static final String[] ALLOWABLE_FONTS;

    public static FontManager getFontManager() {
        return instance;
    }

    @Override
    public void build(Element element) {
        super.build(element);
        if (this.fontStyles.get(DEFAULT) == null) {
            this.addChild(new FontStyle(DEFAULT, DEFAULT_FONT));
        }
    }

    private void addChild(Buildable buildable) {
        this.add(buildable);
        buildable.addTo(this);
    }

    protected FontStyle getFontStyle(String string) {
        FontStyle fontStyle = this.fontStyles.get(string);
        return fontStyle == null ? DEFAULT_STYLE : fontStyle;
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[0];
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[0];
    }

    @Override
    public String[] getAttributeNames() {
        return new String[0];
    }

    @Override
    public String getAttributeValueString(String string) {
        return null;
    }

    @Override
    public void setAttribute(String string, Object object) {
    }

    @Override
    public Configurer getConfigurer() {
        return null;
    }

    @Override
    public void addTo(Buildable buildable) {
        this.validator = new SingleChildInstance(GameModule.getGameModule(), this.getClass());
        instance = this;
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[]{FontStyle.class};
    }

    public static String getConfigureTypeName() {
        return "Font Styles";
    }

    @Override
    public void add(Buildable buildable) {
        super.add(buildable);
        if (buildable instanceof FontStyle) {
            FontStyle fontStyle = (FontStyle)buildable;
            this.fontStyles.put(fontStyle.getConfigureName(), fontStyle);
            fontStyle.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("name".equals(propertyChangeEvent.getPropertyName())) {
                        FontManager.this.fontStyles.remove((String)propertyChangeEvent.getOldValue());
                        FontManager.this.fontStyles.put((String)propertyChangeEvent.getNewValue(), (FontStyle)propertyChangeEvent.getSource());
                    }
                }
            });
        }
    }

    @Override
    public void remove(Buildable buildable) {
        super.remove(buildable);
        if (buildable instanceof ColorSwatch) {
            this.fontStyles.remove(((ColorSwatch)buildable).getConfigureName());
        }
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GamePieceImageDefinitions.htm", "FontStyles");
    }

    @Override
    public void removeFrom(Buildable buildable) {
    }

    public String[] getFontNames() {
        ArrayList<String> arrayList = new ArrayList<String>(this.fontStyles.size());
        for (FontStyle fontStyle : this.fontStyles.values()) {
            arrayList.add(fontStyle.getConfigureName());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    static {
        DEFAULT_FONT = new OutlineFont(DIALOG, 0, 12, false);
        DEFAULT_STYLE = new FontStyle();
        ALLOWABLE_FONTS = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    }
}

