/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.node;

import VASSAL.chat.HybridClient;
import VASSAL.chat.Room;
import VASSAL.chat.node.NodeClient;
import VASSAL.chat.node.NodeRoom;
import VASSAL.chat.ui.LockableRoomControls;
import VASSAL.i18n.Resources;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;

public class LockableNodeRoomControls
extends LockableRoomControls {
    public LockableNodeRoomControls(NodeClient nodeClient) {
        super(nodeClient);
    }

    protected void addLockRoomAction(JPopupMenu jPopupMenu, Room room) {
        NodeClient nodeClient = this.getNodeClient();
        if (nodeClient != null) {
            jPopupMenu.add(new LockRoomAction((NodeRoom)room, nodeClient));
        }
    }

    private NodeClient getNodeClient() {
        NodeClient nodeClient = null;
        if (this.client instanceof NodeClient) {
            nodeClient = (NodeClient)this.client;
        } else if (this.client instanceof HybridClient && ((HybridClient)this.client).getDelegate() instanceof NodeClient) {
            nodeClient = (NodeClient)((HybridClient)this.client).getDelegate();
        }
        return nodeClient;
    }

    protected void createRoom(String string) {
        Room room = null;
        Room[] roomArray = this.client.getAvailableRooms();
        for (int i = 0; room == null && i < roomArray.length; ++i) {
            if (!roomArray[i].getName().equals(string)) continue;
            room = roomArray[i];
        }
        NodeClient nodeClient = this.getNodeClient();
        if (room instanceof NodeRoom) {
            if (!((NodeRoom)room).isLocked()) {
                this.client.setRoom(room);
            }
        } else if (room == null && nodeClient != null) {
            NodeRoom nodeRoom = new NodeRoom(string);
            nodeRoom.setOwner(nodeClient.getMyInfo().getId());
            this.client.setRoom(nodeRoom);
            nodeClient.sendRoomInfo(nodeRoom);
        } else {
            super.createRoom(string);
        }
    }

    class LockRoomAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private NodeClient client;
        private NodeRoom target;

        public LockRoomAction(NodeRoom nodeRoom, NodeClient nodeClient) {
            super(nodeRoom.isLocked() ? Resources.getString("Chat.unlock_room") : Resources.getString("Chat.lock_room"));
            this.setEnabled(nodeClient.getMyInfo().getId().equals(nodeRoom.getOwner()) && !nodeRoom.getName().equals(nodeClient.getDefaultRoomName()));
            this.target = nodeRoom;
            this.client = nodeClient;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.client.lockRoom(this.target);
        }
    }
}

