/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.GpIdSupport;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.documentation.HelpWindow;
import VASSAL.build.module.documentation.HelpWindowExtension;
import VASSAL.build.widget.PieceSlot;
import VASSAL.counters.ActionButton;
import VASSAL.counters.AreaOfEffect;
import VASSAL.counters.BasicPiece;
import VASSAL.counters.CalculatedProperty;
import VASSAL.counters.Clone;
import VASSAL.counters.CounterGlobalKeyCommand;
import VASSAL.counters.Decorator;
import VASSAL.counters.Delete;
import VASSAL.counters.DynamicProperty;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.Embellishment;
import VASSAL.counters.Footprint;
import VASSAL.counters.FreeRotator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.GlobalHotKey;
import VASSAL.counters.Hideable;
import VASSAL.counters.Immobilized;
import VASSAL.counters.Labeler;
import VASSAL.counters.Marker;
import VASSAL.counters.MovementMarkable;
import VASSAL.counters.NonRectangular;
import VASSAL.counters.Obscurable;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.Pivot;
import VASSAL.counters.PlaceMarker;
import VASSAL.counters.PlaySound;
import VASSAL.counters.PropertySheet;
import VASSAL.counters.Replace;
import VASSAL.counters.ReportState;
import VASSAL.counters.RestrictCommands;
import VASSAL.counters.Restricted;
import VASSAL.counters.ReturnToDeck;
import VASSAL.counters.SendToLocation;
import VASSAL.counters.SetGlobalProperty;
import VASSAL.counters.SubMenu;
import VASSAL.counters.TableInfo;
import VASSAL.counters.Translate;
import VASSAL.counters.TriggerAction;
import VASSAL.counters.UsePrototype;
import VASSAL.tools.BrowserSupport;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.ReflectionUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;

public class PieceDefiner
extends JPanel
implements HelpWindowExtension {
    private static final long serialVersionUID = 1L;
    protected static DefaultListModel availableModel;
    protected DefaultListModel inUseModel;
    protected ListCellRenderer r;
    protected PieceSlot slot;
    private GamePiece piece;
    protected static TraitClipboard clipBoard;
    protected String pieceId = "";
    protected JLabel pieceIdLabel = new JLabel("");
    protected GpIdSupport gpidSupport;
    protected boolean changed;
    private JPanel availablePanel;
    private JScrollPane availableScroll;
    protected JList availableList;
    private JButton helpButton;
    private JButton importButton;
    private JPanel addRemovePanel;
    private JButton addButton;
    private JButton removeButton;
    private JPanel inUsePanel;
    private JScrollPane inUseScroll;
    private JList inUseList;
    private JButton propsButton;
    private JPanel moveUpDownPanel;
    private JButton moveUpButton;
    private JButton moveDownButton;
    protected JButton copyButton;
    protected JButton pasteButton;

    public PieceDefiner() {
        PieceDefiner.initDefinitions();
        this.inUseModel = new DefaultListModel();
        this.r = new Renderer();
        this.slot = new PieceSlot();
        this.initComponents();
        this.availableList.setSelectedIndex(0);
        this.setChanged(false);
        this.gpidSupport = GameModule.getGameModule().getGpIdSupport();
    }

    public PieceDefiner(String string, GpIdSupport gpIdSupport) {
        this();
        this.pieceId = string;
        this.pieceIdLabel.setText("Id: " + string);
        this.gpidSupport = gpIdSupport;
    }

    public PieceDefiner(GpIdSupport gpIdSupport) {
        this();
        this.gpidSupport = gpIdSupport;
    }

    protected static void initDefinitions() {
        if (availableModel == null) {
            availableModel = new DefaultListModel();
            availableModel.addElement(new BasicPiece());
            availableModel.addElement(new Delete());
            availableModel.addElement(new Clone());
            availableModel.addElement(new Embellishment());
            availableModel.addElement(new UsePrototype());
            availableModel.addElement(new Labeler());
            availableModel.addElement(new ReportState());
            availableModel.addElement(new TriggerAction());
            availableModel.addElement(new GlobalHotKey());
            availableModel.addElement(new ActionButton());
            availableModel.addElement(new FreeRotator());
            availableModel.addElement(new Pivot());
            availableModel.addElement(new Hideable());
            availableModel.addElement(new Obscurable());
            availableModel.addElement(new SendToLocation());
            availableModel.addElement(new CounterGlobalKeyCommand());
            availableModel.addElement(new Translate());
            availableModel.addElement(new ReturnToDeck());
            availableModel.addElement(new Immobilized());
            availableModel.addElement(new PropertySheet());
            availableModel.addElement(new TableInfo());
            availableModel.addElement(new PlaceMarker());
            availableModel.addElement(new Replace());
            availableModel.addElement(new NonRectangular());
            availableModel.addElement(new PlaySound());
            availableModel.addElement(new MovementMarkable());
            availableModel.addElement(new Footprint());
            availableModel.addElement(new AreaOfEffect());
            availableModel.addElement(new SubMenu());
            availableModel.addElement(new RestrictCommands());
            availableModel.addElement(new Restricted());
            availableModel.addElement(new Marker());
            availableModel.addElement(new DynamicProperty());
            availableModel.addElement(new CalculatedProperty());
            availableModel.addElement(new SetGlobalProperty());
        }
    }

    public static void addDefinition(GamePiece gamePiece) {
        PieceDefiner.initDefinitions();
        availableModel.addElement(gamePiece);
    }

    public void setPiece(GamePiece gamePiece) {
        this.inUseModel.clear();
        while (gamePiece instanceof Decorator) {
            Class<?> clazz = gamePiece.getClass();
            this.inUseModel.insertElementAt(gamePiece, 0);
            boolean bl = false;
            int n = availableModel.size();
            for (int i = 0; i < n; ++i) {
                if (!clazz.isInstance(availableModel.elementAt(i))) continue;
                bl = true;
                break;
            }
            if (!bl) {
                try {
                    availableModel.addElement(clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (Throwable throwable) {
                    ReflectionUtils.handleNewInstanceFailure(throwable, clazz);
                }
            }
            gamePiece = ((Decorator)gamePiece).piece;
        }
        if (gamePiece == null) {
            this.inUseModel.insertElementAt(new BasicPiece(), 0);
        } else {
            this.inUseModel.insertElementAt(gamePiece, 0);
        }
        this.inUseList.setSelectedIndex(0);
        this.refresh();
    }

    @Deprecated
    public void setBaseWindow(HelpWindow helpWindow) {
    }

    private void refresh() {
        this.piece = this.inUseModel.getSize() > 0 ? (GamePiece)this.inUseModel.lastElement() : null;
        this.slot.setPiece(this.piece);
        this.slot.getComponent().repaint();
    }

    public GamePiece getPiece() {
        return this.piece;
    }

    public void setChanged(boolean bl) {
        this.changed = bl;
    }

    public boolean isChanged() {
        return this.changed;
    }

    private void initComponents() {
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.slot.getComponent());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.availablePanel = new JPanel();
        this.availableScroll = new JScrollPane();
        this.availableList = new JList();
        this.helpButton = new JButton();
        this.importButton = new JButton();
        this.addRemovePanel = new JPanel();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.inUsePanel = new JPanel();
        this.inUseScroll = new JScrollPane();
        this.inUseList = new JList();
        this.propsButton = new JButton();
        this.moveUpDownPanel = new JPanel();
        this.moveUpButton = new JButton();
        this.moveDownButton = new JButton();
        this.copyButton = new JButton();
        this.pasteButton = new JButton();
        this.availablePanel.setLayout(new BoxLayout(this.availablePanel, 1));
        this.availableList.setModel(availableModel);
        this.availableList.setSelectionMode(0);
        this.availableList.setCellRenderer(this.r);
        this.availableList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                Object e = PieceDefiner.this.availableList.getSelectedValue();
                PieceDefiner.this.helpButton.setEnabled(e instanceof EditablePiece && ((EditablePiece)e).getHelpFile() != null);
                PieceDefiner.this.addButton.setEnabled(e instanceof Decorator);
            }
        });
        this.availableScroll.setViewportView(this.availableList);
        this.availableScroll.setBorder(new TitledBorder("Available Traits"));
        this.availablePanel.add(this.availableScroll);
        this.helpButton.setText("Help");
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PieceDefiner.this.showHelpForPiece();
            }
        });
        this.availablePanel.add(this.helpButton);
        this.importButton.setText("Import");
        this.importButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = JOptionPane.showInputDialog(PieceDefiner.this, (Object)"Enter fully-qualified name of Java class to import");
                PieceDefiner.this.importPiece(string);
            }
        });
        this.availablePanel.add(this.importButton);
        jPanel.add(this.availablePanel);
        this.addRemovePanel.setLayout(new BoxLayout(this.addRemovePanel, 1));
        this.addButton.setText("Add ->");
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object e = PieceDefiner.this.availableList.getSelectedValue();
                if (e instanceof Decorator) {
                    if (PieceDefiner.this.inUseModel.getSize() > 0) {
                        Decorator decorator = (Decorator)e;
                        PieceDefiner.this.addTrait(decorator);
                        if (PieceDefiner.this.inUseModel.lastElement().getClass() == decorator.getClass() && !PieceDefiner.this.edit(PieceDefiner.this.inUseModel.size() - 1) && !PieceDefiner.this.inUseModel.isEmpty()) {
                            PieceDefiner.this.removeTrait(PieceDefiner.this.inUseModel.size() - 1);
                        }
                    }
                } else if (e instanceof GamePiece && PieceDefiner.this.inUseModel.getSize() == 0) {
                    GamePiece gamePiece = null;
                    try {
                        gamePiece = (GamePiece)e.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Throwable throwable) {
                        ReflectionUtils.handleNewInstanceFailure(throwable, e.getClass());
                    }
                    if (gamePiece != null) {
                        PieceDefiner.this.setPiece(gamePiece);
                        if (PieceDefiner.this.inUseModel.getSize() > 0 && !PieceDefiner.this.edit(0)) {
                            PieceDefiner.this.removeTrait(0);
                        }
                    }
                }
            }
        });
        this.addButton.setAlignmentX(0.5f);
        this.addRemovePanel.add(this.addButton);
        this.removeButton.setText("<- Remove");
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = PieceDefiner.this.inUseList.getSelectedIndex();
                if (n >= 0) {
                    PieceDefiner.this.removeTrait(n);
                    if (PieceDefiner.this.inUseModel.getSize() > 0) {
                        PieceDefiner.this.inUseList.setSelectedIndex(Math.min(PieceDefiner.this.inUseModel.getSize() - 1, Math.max(n, 0)));
                    }
                }
            }
        });
        this.removeButton.setAlignmentX(0.5f);
        this.addRemovePanel.add(this.removeButton);
        this.pieceIdLabel.setAlignmentX(0.5f);
        this.addRemovePanel.add(this.pieceIdLabel);
        jPanel.add(this.addRemovePanel);
        this.inUsePanel.setLayout(new BoxLayout(this.inUsePanel, 1));
        this.inUseList.setModel(this.inUseModel);
        this.inUseList.setSelectionMode(0);
        this.inUseList.setCellRenderer(this.r);
        this.inUseList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                Object e = PieceDefiner.this.inUseList.getSelectedValue();
                PieceDefiner.this.propsButton.setEnabled(e instanceof EditablePiece);
                int n = PieceDefiner.this.inUseList.getSelectedIndex();
                boolean bl = PieceDefiner.this.inUseModel.size() > 0 && (n > 0 || !(PieceDefiner.this.inUseModel.getElementAt(0) instanceof BasicPiece));
                PieceDefiner.this.copyButton.setEnabled(bl);
                PieceDefiner.this.removeButton.setEnabled(bl);
                PieceDefiner.this.pasteButton.setEnabled(clipBoard != null);
                PieceDefiner.this.moveUpButton.setEnabled(n > 1);
                PieceDefiner.this.moveDownButton.setEnabled(n > 0 && n < PieceDefiner.this.inUseModel.size() - 1);
            }
        });
        this.inUseList.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                int n;
                if (mouseEvent.getClickCount() == 2 && (n = PieceDefiner.this.inUseList.locationToIndex(mouseEvent.getPoint())) >= 0) {
                    PieceDefiner.this.edit(n);
                }
            }
        });
        this.inUseScroll.setViewportView(this.inUseList);
        this.inUseScroll.setBorder(new TitledBorder("Current Traits"));
        this.inUsePanel.add(this.inUseScroll);
        this.propsButton.setText("Properties");
        this.propsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = PieceDefiner.this.inUseList.getSelectedIndex();
                if (n >= 0) {
                    PieceDefiner.this.edit(n);
                }
            }
        });
        this.inUsePanel.add(this.propsButton);
        jPanel.add(this.inUsePanel);
        this.moveUpDownPanel.setLayout(new BoxLayout(this.moveUpDownPanel, 1));
        this.moveUpButton.setText("Move Up");
        this.moveUpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = PieceDefiner.this.inUseList.getSelectedIndex();
                if (n > 1 && n < PieceDefiner.this.inUseModel.size()) {
                    PieceDefiner.this.moveDecoratorUp(n);
                }
            }
        });
        this.moveUpDownPanel.add(this.moveUpButton);
        this.moveDownButton.setText("Move Down");
        this.moveDownButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = PieceDefiner.this.inUseList.getSelectedIndex();
                if (n > 0 && n < PieceDefiner.this.inUseModel.size() - 1) {
                    PieceDefiner.this.moveDecoratorDown(n);
                }
            }
        });
        this.moveUpDownPanel.add(this.moveDownButton);
        this.copyButton.setText("Copy");
        this.copyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PieceDefiner.this.pasteButton.setEnabled(true);
                int n = PieceDefiner.this.inUseList.getSelectedIndex();
                clipBoard = new TraitClipboard((Decorator)PieceDefiner.this.inUseModel.get(n));
            }
        });
        this.moveUpDownPanel.add(this.copyButton);
        this.pasteButton.setText("Paste");
        this.pasteButton.setEnabled(clipBoard != null);
        this.pasteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (clipBoard != null) {
                    PieceDefiner.this.paste();
                }
            }
        });
        this.moveUpDownPanel.add(this.pasteButton);
        jPanel.add(this.moveUpDownPanel);
        this.add(jPanel);
    }

    protected void paste() {
        Decorator decorator = (Decorator)GameModule.getGameModule().createPiece(clipBoard.getType(), null);
        if (decorator instanceof PlaceMarker) {
            ((PlaceMarker)decorator).updateGpId(GameModule.getGameModule().getGpIdSupport());
        }
        decorator.setInner((GamePiece)this.inUseModel.lastElement());
        this.inUseModel.addElement(decorator);
        decorator.mySetState(clipBoard.getState());
        this.refresh();
    }

    protected void moveDecoratorDown(int n) {
        GamePiece gamePiece = (GamePiece)this.inUseModel.elementAt(n - 1);
        Decorator decorator = (Decorator)this.inUseModel.elementAt(n);
        Decorator decorator2 = (Decorator)this.inUseModel.elementAt(n + 1);
        Decorator decorator3 = n < this.inUseModel.size() - 2 ? (Decorator)this.inUseModel.elementAt(n + 2) : null;
        decorator2.setInner(gamePiece);
        decorator.setInner(decorator2);
        if (decorator3 != null) {
            decorator3.setInner(decorator);
        }
        this.inUseModel.setElementAt(decorator2, n);
        this.inUseModel.setElementAt(decorator, n + 1);
        ((GamePiece)this.inUseModel.lastElement()).setProperty("Outer", null);
        this.inUseList.setSelectedIndex(n + 1);
        this.refresh();
        this.setChanged(true);
    }

    protected void moveDecoratorUp(int n) {
        GamePiece gamePiece = (GamePiece)this.inUseModel.elementAt(n - 2);
        Decorator decorator = (Decorator)this.inUseModel.elementAt(n);
        Decorator decorator2 = (Decorator)this.inUseModel.elementAt(n - 1);
        Decorator decorator3 = n < this.inUseModel.size() - 1 ? (Decorator)this.inUseModel.elementAt(n + 1) : null;
        decorator.setInner(gamePiece);
        decorator2.setInner(decorator);
        if (decorator3 != null) {
            decorator3.setInner(decorator2);
        }
        this.inUseModel.setElementAt(decorator2, n);
        this.inUseModel.setElementAt(decorator, n - 1);
        ((GamePiece)this.inUseModel.lastElement()).setProperty("Outer", null);
        this.inUseList.setSelectedIndex(n - 1);
        this.refresh();
        this.setChanged(true);
    }

    protected void importPiece(String string) {
        if (string == null) {
            return;
        }
        Object var2_2 = null;
        try {
            var2_2 = GameModule.getGameModule().getDataArchive().loadClass(string).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable throwable) {
            ReflectionUtils.handleImportClassFailure(throwable, string);
        }
        if (var2_2 == null) {
            return;
        }
        if (var2_2 instanceof GamePiece) {
            availableModel.addElement(var2_2);
        } else {
            ErrorDialog.show("Error.not_a_gamepiece", string);
        }
    }

    private void showHelpForPiece() {
        Object e = this.availableList.getSelectedValue();
        if (e instanceof EditablePiece) {
            HelpFile helpFile = ((EditablePiece)e).getHelpFile();
            BrowserSupport.openURL(helpFile.getContents().toString());
        }
    }

    protected boolean edit(int n) {
        Object e = this.inUseModel.elementAt(n);
        if (!(e instanceof EditablePiece)) {
            return false;
        }
        EditablePiece editablePiece = (EditablePiece)e;
        if (editablePiece.getEditor() != null) {
            Ed ed = null;
            Window window = SwingUtilities.getWindowAncestor(this);
            ed = window instanceof Frame ? new Ed((Frame)window, editablePiece) : (window instanceof Dialog ? new Ed((Dialog)window, editablePiece) : new Ed((Frame)null, editablePiece));
            String string = editablePiece.getState();
            String string2 = editablePiece.getType();
            ed.setVisible(true);
            PieceEditor pieceEditor = ed.getEditor();
            if (pieceEditor != null) {
                editablePiece.mySetType(pieceEditor.getType());
                if (editablePiece instanceof Decorator) {
                    ((Decorator)((Object)editablePiece)).mySetState(pieceEditor.getState());
                } else {
                    editablePiece.setState(pieceEditor.getState());
                }
                if (!editablePiece.getType().equals(string2) || !editablePiece.getState().equals(string)) {
                    this.setChanged(true);
                }
                this.refresh();
                return true;
            }
        }
        return false;
    }

    protected void removeTrait(int n) {
        this.inUseModel.removeElementAt(n);
        if (n < this.inUseModel.size()) {
            ((Decorator)this.inUseModel.elementAt(n)).setInner((GamePiece)this.inUseModel.elementAt(n - 1));
        }
        this.refresh();
        this.setChanged(true);
    }

    protected void addTrait(Decorator decorator) {
        Class<?> clazz = decorator.getClass();
        Decorator decorator2 = null;
        try {
            decorator2 = (Decorator)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable throwable) {
            ReflectionUtils.handleNewInstanceFailure(throwable, clazz);
        }
        if (decorator2 != null) {
            if (decorator2 instanceof PlaceMarker) {
                ((PlaceMarker)decorator2).updateGpId(this.gpidSupport);
            }
            decorator2.setInner((GamePiece)this.inUseModel.lastElement());
            this.inUseModel.addElement(decorator2);
            this.setChanged(true);
        }
        this.refresh();
    }

    private static class TraitClipboard {
        private String type;
        private String state;

        public TraitClipboard(Decorator decorator) {
            this.type = decorator.myGetType();
            this.state = decorator.myGetState();
        }

        public String getType() {
            return this.type;
        }

        public String getState() {
            return this.state;
        }
    }

    private static class Renderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        private Renderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object instanceof EditablePiece) {
                this.setText(((EditablePiece)object).getDescription());
            } else {
                String string = object.getClass().getName();
                this.setText(string.substring(string.lastIndexOf(46) + 1));
            }
            return this;
        }
    }

    protected static class Ed
    extends JDialog {
        private static final long serialVersionUID = 1L;
        PieceEditor ed;

        private Ed(Frame frame, EditablePiece editablePiece) {
            super(frame, editablePiece.getDescription() + " properties", true);
            this.initialize(editablePiece);
        }

        private Ed(Dialog dialog, EditablePiece editablePiece) {
            super(dialog, editablePiece.getDescription() + " properties", true);
            this.initialize(editablePiece);
        }

        private void initialize(final EditablePiece editablePiece) {
            this.ed = editablePiece.getEditor();
            this.setLayout(new MigLayout("ins dialog,fill", "[]unrel[]", ""));
            this.add(this.ed.getControls(), "spanx 3,grow,push,wrap");
            JButton jButton = new JButton("Ok");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Ed.this.dispose();
                }
            });
            this.add((Component)jButton, "tag ok");
            jButton = new JButton("Cancel");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Ed.this.ed = null;
                    Ed.this.dispose();
                }
            });
            this.add((Component)jButton, "tag cancel");
            if (editablePiece.getHelpFile() != null) {
                jButton = new JButton("Help");
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        editablePiece.getHelpFile().showWindow(Ed.this);
                    }
                });
                this.add((Component)jButton, "tag help");
            }
            this.pack();
            this.setLocationRelativeTo(this.getOwner());
        }

        public PieceEditor getEditor() {
            return this.ed;
        }
    }
}

