/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.command.PlayAudioClipCommand;
import VASSAL.configure.AudioClipConfigurer;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.FormattedString;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.SequenceEncoder;
import java.applet.AudioClip;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class PlaySound
extends Decorator
implements TranslatablePiece {
    public static final String ID = "playSound;";
    protected String menuText;
    protected NamedKeyStroke stroke;
    protected boolean sendToOthers;
    protected KeyCommand command;
    protected KeyCommand[] commands;
    protected FormattedString format = new FormattedString();

    public PlaySound() {
        this(ID, null);
    }

    public PlaySound(String string, GamePiece gamePiece) {
        this.mySetType(string);
        this.setInner(gamePiece);
    }

    public void mySetState(String string) {
    }

    public String myGetState() {
        return "";
    }

    public String myGetType() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        sequenceEncoder.append(this.format.getFormat()).append(this.menuText).append(this.stroke).append(this.sendToOthers);
        return ID + sequenceEncoder.getValue();
    }

    protected KeyCommand[] myGetKeyCommands() {
        if (this.commands == null) {
            this.command = new KeyCommand(this.menuText, this.stroke, Decorator.getOutermost(this), (TranslatablePiece)this);
            this.commands = this.menuText.length() > 0 && this.stroke != null && !this.stroke.isNull() ? new KeyCommand[]{this.command} : new KeyCommand[0];
        }
        return this.commands;
    }

    public Command myKeyEvent(KeyStroke keyStroke) {
        this.myGetKeyCommands();
        PlayAudioClipCommand playAudioClipCommand = null;
        if (this.command.matches(keyStroke)) {
            String string = this.format.getText(Decorator.getOutermost(this));
            playAudioClipCommand = new PlayAudioClipCommand(string);
            try {
                AudioClip audioClip = GameModule.getGameModule().getDataArchive().getCachedAudioClip(string);
                if (audioClip != null) {
                    audioClip.play();
                }
            }
            catch (IOException iOException) {
                PlaySound.reportDataError(this, Resources.getString("Error.not_found", "Audio Clip"), "Clip=" + string, iOException);
            }
        }
        return playAudioClipCommand;
    }

    public void draw(Graphics graphics, int n, int n2, Component component, double d) {
        this.piece.draw(graphics, n, n2, component, d);
    }

    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    public Shape getShape() {
        return this.piece.getShape();
    }

    public String getName() {
        return this.piece.getName();
    }

    public String getDescription() {
        return this.format.getFormat().length() == 0 ? "Play Sound" : "Play Sound - " + this.format.getFormat();
    }

    public void mySetType(String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        decoder.nextToken();
        this.format = new FormattedString(decoder.nextToken(""));
        this.menuText = decoder.nextToken("Play Sound");
        this.stroke = decoder.nextNamedKeyStroke('P');
        this.sendToOthers = decoder.nextBoolean(false);
        this.commands = null;
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("PlaySound.htm");
    }

    public PieceEditor getEditor() {
        return new Ed(this);
    }

    public PieceI18nData getI18nData() {
        return this.getI18nData(this.menuText, "Play Sound command");
    }

    public static class Ed
    implements PieceEditor {
        private StringConfigurer menuConfig;
        private NamedHotKeyConfigurer keyConfig;
        private AudioClipConfigurer soundConfig;
        private BooleanConfigurer sendConfig;
        private JPanel panel;

        public Ed(PlaySound playSound) {
            this.menuConfig = new StringConfigurer(null, "Menu Text:  ", playSound.menuText);
            this.keyConfig = new NamedHotKeyConfigurer(null, "Keyboard Command:  ", playSound.stroke);
            this.soundConfig = new AudioClipConfigurer(null, "Sound Clip:  ", GameModule.getGameModule().getArchiveWriter());
            this.soundConfig.setValue(playSound.format.getFormat());
            this.soundConfig.setEditable(true);
            this.sendConfig = new BooleanConfigurer(null, "Send sound to other players?", playSound.sendToOthers);
            this.panel = new JPanel();
            this.panel.setLayout(new BoxLayout(this.panel, 1));
            this.panel.add(this.menuConfig.getControls());
            this.panel.add(this.keyConfig.getControls());
            this.panel.add(this.soundConfig.getControls());
            this.panel.add(this.sendConfig.getControls());
        }

        public Component getControls() {
            return this.panel;
        }

        public String getType() {
            SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
            sequenceEncoder.append(this.soundConfig.getValueString()).append(this.menuConfig.getValueString()).append(this.keyConfig.getValueString()).append(this.sendConfig.getValueString());
            return PlaySound.ID + sequenceEncoder.getValue();
        }

        public String getState() {
            return "";
        }
    }
}

