/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.script.expression;

import VASSAL.build.module.documentation.HelpFile;
import VASSAL.configure.BeanShellExpressionConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.counters.EditablePiece;
import VASSAL.script.expression.Expression;
import VASSAL.tools.BrowserSupport;
import VASSAL.tools.ButtonFactory;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class ExpressionBuilder
extends JDialog {
    private static final long serialVersionUID = 1L;
    protected BeanShellExpressionConfigurer expression;
    protected String save;
    protected Configurer target;
    protected EditablePiece pieceTarget;

    public ExpressionBuilder(Configurer configurer, JDialog jDialog) {
        this(configurer, jDialog, null);
    }

    public ExpressionBuilder(Configurer configurer, JDialog jDialog, EditablePiece editablePiece) {
        super(jDialog, "Expression Builder", true);
        this.target = configurer;
        this.pieceTarget = editablePiece;
        this.save = this.target.getValueString();
        JPanel jPanel = new JPanel(new MigLayout("wrap 1,fill"));
        String string = this.target.getValueString();
        if (string.startsWith("{") && string.endsWith("}")) {
            this.setExpression(string.substring(1, string.length() - 1));
        } else {
            this.setExpression(this.convert(string));
        }
        jPanel.add(this.expression.getControls(), "growx");
        JPanel jPanel2 = new JPanel(new MigLayout("", "[]rel[]rel[]"));
        JButton jButton = ButtonFactory.getOkButton();
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExpressionBuilder.this.save();
            }
        });
        jPanel2.add(jButton);
        JButton jButton2 = ButtonFactory.getCancelButton();
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExpressionBuilder.this.cancel();
            }
        });
        jPanel2.add(jButton2);
        JButton jButton3 = ButtonFactory.getHelpButton();
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserSupport.openURL(HelpFile.getReferenceManualPage("ExpressionBuilder.htm").getContents().toString());
            }
        });
        jPanel2.add(jButton3);
        jPanel.add((Component)jPanel2, "align center");
        this.add(jPanel);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ExpressionBuilder.this.cancel();
            }
        });
    }

    public void save() {
        String string = this.expression.getValueString().trim();
        if (string.startsWith("{") && string.endsWith("}")) {
            this.target.setValue(string);
        } else {
            this.target.setValue("{" + string + "}");
        }
        this.dispose();
    }

    public void cancel() {
        this.dispose();
    }

    public String convert(String string) {
        return Expression.createExpression(string).toBeanShellString();
    }

    public void setExpression(String string) {
        if (this.expression == null) {
            String string2 = this.target.getName().length() == 0 ? "Expression:  " : this.target.getName();
            this.expression = new BeanShellExpressionConfigurer(null, string2, string, this.pieceTarget);
        }
        this.expression.setValue(string);
    }

    public String getExpression() {
        return this.expression == null ? "" : this.expression.getValueString();
    }
}

