/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

public class CountingReadWriteLock
implements ReadWriteLock {
    protected final ReadLock r = new ReadLock();
    protected final WriteLock w = new WriteLock();
    protected final Sync sync = new Sync();

    public Lock readLock() {
        return this.r;
    }

    public Lock writeLock() {
        return this.w;
    }

    protected static class Sync
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = 1L;

        protected Sync() {
        }

        protected boolean tryAcquire(int n) {
            return this.compareAndSetState(0, -1);
        }

        protected boolean tryRelease(int n) {
            if (this.getState() != -1) {
                throw new IllegalMonitorStateException();
            }
            return this.compareAndSetState(-1, 0);
        }

        protected int tryAcquireShared(int n) {
            int n2 = this.getState();
            return n2 >= 0 && this.compareAndSetState(n2, n2 + 1) ? 1 : -1;
        }

        protected boolean tryReleaseShared(int n) {
            int n2 = this.getState();
            if (n2 < 1) {
                throw new IllegalMonitorStateException();
            }
            return this.compareAndSetState(n2, n2 - 1);
        }
    }

    protected class WriteLock
    extends BaseLock {
        protected WriteLock() {
        }

        public void lock() {
            CountingReadWriteLock.this.sync.acquire(0);
        }

        public void unlock() {
            CountingReadWriteLock.this.sync.release(0);
        }

        public boolean tryLock() {
            return CountingReadWriteLock.this.sync.tryAcquire(0);
        }

        public boolean tryLock(long l, TimeUnit timeUnit) throws InterruptedException {
            return CountingReadWriteLock.this.sync.tryAcquireNanos(0, timeUnit.toNanos(l));
        }
    }

    protected class ReadLock
    extends BaseLock {
        protected ReadLock() {
        }

        public void lock() {
            CountingReadWriteLock.this.sync.acquireShared(0);
        }

        public void unlock() {
            CountingReadWriteLock.this.sync.releaseShared(0);
        }

        public boolean tryLock() {
            return CountingReadWriteLock.this.sync.tryAcquireShared(0) >= 0;
        }

        public boolean tryLock(long l, TimeUnit timeUnit) throws InterruptedException {
            return CountingReadWriteLock.this.sync.tryAcquireSharedNanos(0, timeUnit.toNanos(l));
        }
    }

    protected abstract class BaseLock
    implements Lock {
        protected BaseLock() {
        }

        public void lockInterruptibly() {
            throw new UnsupportedOperationException();
        }

        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }
    }
}

