/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.image.tilecache;

import VASSAL.tools.image.GeneralFilter;
import VASSAL.tools.image.tilecache.ScaledTileTask;
import VASSAL.tools.image.tilecache.TileSlicer;
import VASSAL.tools.image.tilecache.TileTask;
import VASSAL.tools.image.tilecache.TileUtils;
import VASSAL.tools.lang.Callback;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TileSlicerImpl
implements TileSlicer {
    @Override
    public void slice(BufferedImage bufferedImage, String string, String string2, int n, int n2, ExecutorService executorService, Callback<Void> callback) throws IOException {
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        ArrayList<Future<Void>> arrayList = new ArrayList<Future<Void>>();
        TaskMaker taskMaker = new TaskMaker(){

            public TileTask make(BufferedImage bufferedImage, File file, int n, int n2, int n3, int n4, int n5, int n6) {
                return new TileTask(bufferedImage, file, n, n2, n3, n4, n5, n6);
            }
        };
        TileSlicerImpl.queueTileTasks(bufferedImage, string, string2, 1, n, n2, n3, n4, taskMaker, executorService, arrayList);
        TaskMaker taskMaker2 = new TaskMaker(){
            private final GeneralFilter.Filter filter = new GeneralFilter.Lanczos3Filter();

            public TileTask make(BufferedImage bufferedImage, File file, int n, int n2, int n3, int n4, int n5, int n6) {
                return new ScaledTileTask(bufferedImage, file, this.filter, n, n2, n3, n4, n5, n6);
            }
        };
        int n5 = 2;
        while (n3 / n5 > 0 && n4 / n5 > 0) {
            int n6 = n3 / n5;
            int n7 = n4 / n5;
            TileSlicerImpl.queueTileTasks(bufferedImage, string, string2, n5, n, n2, n6, n7, taskMaker2, executorService, arrayList);
            n5 <<= 1;
        }
        try {
            for (Future future : arrayList) {
                future.get();
                callback.receive(null);
            }
        }
        catch (CancellationException cancellationException) {
            throw new IllegalStateException(cancellationException);
        }
        catch (ExecutionException executionException) {
            throw (IOException)new IOException().initCause(executionException);
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalStateException(interruptedException);
        }
        finally {
            for (Future future : arrayList) {
                if (future.isDone()) continue;
                future.cancel(true);
            }
        }
    }

    protected static void queueTileTasks(BufferedImage bufferedImage, String string, String string2, int n, int n2, int n3, int n4, int n5, TaskMaker taskMaker, ExecutorService executorService, List<Future<Void>> list) {
        int n6 = (int)Math.ceil((double)n4 / (double)n2);
        int n7 = (int)Math.ceil((double)n5 / (double)n3);
        for (int i = 0; i < n6; ++i) {
            for (int j = 0; j < n7; ++j) {
                String string3 = TileUtils.tileName(string, i, j, n);
                File file = new File(string2, string3);
                TileTask tileTask = taskMaker.make(bufferedImage, file, i, j, n2, n3, n4, n5);
                list.add(executorService.submit(tileTask));
            }
        }
    }

    protected static interface TaskMaker {
        public TileTask make(BufferedImage var1, File var2, int var3, int var4, int var5, int var6, int var7, int var8);
    }
}

