/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXStatusBar;

public class JXRootPane
extends JRootPane {
    protected JXStatusBar statusBar;
    private JToolBar toolBar;
    private JButton cancelButton;

    public JXRootPane() {
        this.installKeyboardActions();
    }

    protected Container createContentPane() {
        JXPanel c = new JXPanel(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void addImpl(Component comp, Object constraints, int index) {
                Object object = this.getTreeLock();
                synchronized (object) {
                    super.addImpl(comp, constraints, index);
                    JXRootPane.this.registerStatusBar(comp);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void remove(int index) {
                Object object = this.getTreeLock();
                synchronized (object) {
                    JXRootPane.this.unregisterStatusBar(this.getComponent(index));
                    super.remove(index);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void removeAll() {
                Object object = this.getTreeLock();
                synchronized (object) {
                    for (Component c : this.getComponents()) {
                        JXRootPane.this.unregisterStatusBar(c);
                    }
                    super.removeAll();
                }
            }
        };
        c.setName(this.getName() + ".contentPane");
        c.setLayout(new BorderLayout(){

            public void addLayoutComponent(Component comp, Object constraints) {
                if (constraints == null) {
                    constraints = "Center";
                }
                super.addLayoutComponent(comp, constraints);
            }
        });
        return c;
    }

    protected LayoutManager createRootLayout() {
        return new XRootLayout();
    }

    private void installKeyboardActions() {
        AbstractAction escAction = new AbstractAction(){

            public void actionPerformed(ActionEvent evt) {
                JButton cancelButton = JXRootPane.this.getCancelButton();
                if (cancelButton != null) {
                    cancelButton.doClick(20);
                }
            }

            public boolean isEnabled() {
                return JXRootPane.this.cancelButton != null && JXRootPane.this.cancelButton.isEnabled();
            }
        };
        this.getActionMap().put("esc-action", escAction);
        InputMap im = this.getInputMap(1);
        KeyStroke key = KeyStroke.getKeyStroke(27, 0);
        im.put(key, "esc-action");
    }

    private void registerStatusBar(Component comp) {
        if (this.statusBar == null || comp == null) {
            return;
        }
        if (comp instanceof Container) {
            Component[] comps = ((Container)comp).getComponents();
            for (int i = 0; i < comps.length; ++i) {
                this.registerStatusBar(comps[i]);
            }
        }
    }

    private void unregisterStatusBar(Component comp) {
        if (this.statusBar == null || comp == null) {
            return;
        }
        if (comp instanceof Container) {
            Component[] comps = ((Container)comp).getComponents();
            for (int i = 0; i < comps.length; ++i) {
                this.unregisterStatusBar(comps[i]);
            }
        }
    }

    public void setStatusBar(JXStatusBar statusBar) {
        JXStatusBar oldStatusBar = this.statusBar;
        this.statusBar = statusBar;
        Component[] comps = this.getContentPane().getComponents();
        for (int i = 0; i < comps.length; ++i) {
            this.unregisterStatusBar(comps[i]);
            this.registerStatusBar(comps[i]);
        }
        if (oldStatusBar != null) {
            this.remove(oldStatusBar);
        }
        if (statusBar != null) {
            this.add(statusBar);
        }
        this.firePropertyChange("statusBar", oldStatusBar, this.getStatusBar());
    }

    public JXStatusBar getStatusBar() {
        return this.statusBar;
    }

    public void setToolBar(JToolBar toolBar) {
        JToolBar oldToolBar = this.getToolBar();
        this.toolBar = toolBar;
        if (oldToolBar != null) {
            this.getContentPane().remove(oldToolBar);
        }
        this.getContentPane().add("North", this.toolBar);
        this.getContentPane().validate();
        this.firePropertyChange("toolBar", oldToolBar, this.getToolBar());
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public void setJMenuBar(JMenuBar menuBar) {
        JMenuBar oldMenuBar = this.menuBar;
        super.setJMenuBar(menuBar);
    }

    public void setCancelButton(JButton cancelButton) {
        JButton old = this.cancelButton;
        if (old != cancelButton) {
            this.cancelButton = cancelButton;
            if (old != null) {
                old.repaint();
            }
            if (cancelButton != null) {
                cancelButton.repaint();
            }
        }
        this.firePropertyChange("cancelButton", old, cancelButton);
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    protected class XRootLayout
    extends JRootPane.RootLayout {
        protected XRootLayout() {
            super(JXRootPane.this);
        }

        public Dimension preferredLayoutSize(Container parent) {
            Insets i = JXRootPane.this.getInsets();
            Dimension rd = JXRootPane.this.contentPane != null ? JXRootPane.this.contentPane.getPreferredSize() : parent.getSize();
            Dimension mbd = JXRootPane.this.menuBar != null && JXRootPane.this.menuBar.isVisible() ? JXRootPane.this.menuBar.getPreferredSize() : new Dimension(0, 0);
            Dimension sbd = JXRootPane.this.statusBar != null && JXRootPane.this.statusBar.isVisible() ? JXRootPane.this.statusBar.getPreferredSize() : new Dimension(0, 0);
            return new Dimension(Math.max(rd.width, Math.max(mbd.width, sbd.width)) + i.left + i.right, rd.height + mbd.height + sbd.height + i.top + i.bottom);
        }

        public Dimension minimumLayoutSize(Container parent) {
            Insets i = JXRootPane.this.getInsets();
            Dimension rd = JXRootPane.this.contentPane != null ? JXRootPane.this.contentPane.getMinimumSize() : parent.getSize();
            Dimension mbd = JXRootPane.this.menuBar != null && JXRootPane.this.menuBar.isVisible() ? JXRootPane.this.menuBar.getMinimumSize() : new Dimension(0, 0);
            Dimension sbd = JXRootPane.this.statusBar != null && JXRootPane.this.statusBar.isVisible() ? JXRootPane.this.statusBar.getMinimumSize() : new Dimension(0, 0);
            return new Dimension(Math.max(rd.width, Math.max(mbd.width, sbd.width)) + i.left + i.right, rd.height + mbd.height + sbd.height + i.top + i.bottom);
        }

        public Dimension maximumLayoutSize(Container target) {
            Insets i = JXRootPane.this.getInsets();
            Dimension mbd = JXRootPane.this.menuBar != null && JXRootPane.this.menuBar.isVisible() ? JXRootPane.this.menuBar.getMaximumSize() : new Dimension(0, 0);
            Dimension sbd = JXRootPane.this.statusBar != null && JXRootPane.this.statusBar.isVisible() ? JXRootPane.this.statusBar.getMaximumSize() : new Dimension(0, 0);
            Dimension rd = JXRootPane.this.contentPane != null ? JXRootPane.this.contentPane.getMaximumSize() : new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE - i.top - i.bottom - mbd.height - sbd.height - 1);
            return new Dimension(Math.min(rd.width, Math.min(mbd.width, sbd.width)) + i.left + i.right, rd.height + mbd.height + sbd.height + i.top + i.bottom);
        }

        public void layoutContainer(Container parent) {
            Rectangle b = parent.getBounds();
            Insets i = JXRootPane.this.getInsets();
            int contentY = 0;
            int adjustH = 0;
            int w = b.width - i.right - i.left;
            int h = b.height - i.top - i.bottom;
            if (JXRootPane.this.layeredPane != null) {
                JXRootPane.this.layeredPane.setBounds(i.left, i.top, w, h);
            }
            if (JXRootPane.this.glassPane != null) {
                JXRootPane.this.glassPane.setBounds(i.left, i.top, w, h);
            }
            if (JXRootPane.this.menuBar != null && JXRootPane.this.menuBar.isVisible()) {
                Dimension mbd = JXRootPane.this.menuBar.getPreferredSize();
                JXRootPane.this.menuBar.setBounds(0, 0, w, mbd.height);
                contentY += mbd.height;
            }
            if (JXRootPane.this.statusBar != null && JXRootPane.this.statusBar.isVisible()) {
                Dimension sbd = JXRootPane.this.statusBar.getPreferredSize();
                JXRootPane.this.statusBar.setBounds(0, h - sbd.height, w, sbd.height);
                adjustH += sbd.height;
            }
            if (JXRootPane.this.contentPane != null) {
                JXRootPane.this.contentPane.setBounds(0, contentY, w, h - contentY - adjustH);
            }
        }
    }
}

