/*
 * Decompiled with CFR 0.152.
 */
package arcus;

import arcus.Version;
import arcus.gui.BasicGraphicsEngine;
import arcus.gui.MainFrame;
import arcus.gui.PatternStore;
import arcus.model.Preferences;
import java.io.File;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;

public class Main {
    private static MainFrame mainFrame = null;
    public static File preferences = null;
    public static File positions = null;
    public static String homepage = "http://arcus.sourceforge.net";

    private static void setPathNames() {
        File file = null;
        String string = System.getProperty("os.name");
        file = string.startsWith("Windows") ? new File(System.getenv("APPDATA") + System.getProperty("file.separator") + "Arcus") : (string.startsWith("Mac") ? new File(System.getProperty("user.home") + System.getProperty("file.separator") + "Library" + System.getProperty("file.separator") + "Application Support" + System.getProperty("file.separator") + "Arcus") : new File(System.getProperty("user.home") + System.getProperty("file.separator") + ".arcus"));
        if (!file.exists()) {
            System.out.println(file + " does not exist.");
            if (file.mkdirs()) {
                System.out.println("Creating directory " + file);
            } else {
                System.out.println("Error while creating directory " + file);
            }
        }
        preferences = new File(file + System.getProperty("file.separator") + "Preferences.xml");
        positions = new File(file + System.getProperty("file.separator") + "Positions.xml");
    }

    private static void createAndShowGUI() {
        try {
            String string = (String)Preferences.instance.get("lookAndFeel");
            UIManager.setLookAndFeel(string);
            if (Preferences.instance.getBoolean("frameDecoration")) {
                JFrame.setDefaultLookAndFeelDecorated(true);
                JDialog.setDefaultLookAndFeelDecorated(true);
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        ToolTipManager.sharedInstance().setEnabled(Preferences.instance.getBoolean("enableToolTips"));
        mainFrame = new MainFrame();
    }

    private static void parseOptions(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-version")) continue;
            System.out.println("Arcus - Rubik's Cube Simulator " + new Version() + "\n" + "(C) 2005-2006 Peter Szilagyi <peterszilagyi@users.sourceforge.net>\n" + "This is free software, and you are welcome to redistribute it\n" + "under certain conditions; see the file LICENSE for details.\n");
            System.exit(0);
        }
    }

    private static void parseFiles(String[] stringArray) {
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith("-")) continue;
            File file = new File(stringArray[i]);
            if (mainFrame.load(file, bl)) {
                if (bl) continue;
                mainFrame.setSessionFile(file);
                bl = true;
                continue;
            }
            if (PatternStore.instance.load(file, bl2)) {
                if (bl2) continue;
                PatternStore.instance.setPatternFile(file);
                PatternStore.instance.setVisible(true);
                bl2 = true;
                continue;
            }
            System.out.println("Invalid file " + file);
        }
    }

    public static void main(final String[] stringArray) {
        Main.parseOptions(stringArray);
        try {
            Main.setPathNames();
            BasicGraphicsEngine.loadPositions();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Main.createAndShowGUI();
                Main.parseFiles(stringArray);
            }
        });
    }
}

