/*
 * Decompiled with CFR 0.152.
 */
package arcus.gui;

import arcus.I18N;
import arcus.gui.BasicGraphicsEngine;
import arcus.gui.Images;
import arcus.gui.ext.XFrame;
import arcus.gui.ext.XTextField;
import arcus.model.PrefListener;
import arcus.model.Preferences;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PrefUI
extends XFrame {
    public static PrefUI instance = new PrefUI();
    private Vector<PrefListener> displayPrefListeners = new Vector();
    private Vector<PrefListener> consolePrefListeners = new Vector();
    private JTabbedPane tabbedPane = new JTabbedPane();
    JSlider blackOutSlider;
    JLabel[] colorButtons;
    JCheckBox distortionCheck;
    JCheckBox angVelocityCheck;
    JSpinner stepSpinner;
    JSpinner timeSpinner;
    MouseCaptureButton[] captureButtons;
    JTextField[] sideFields;
    JTextField[] layerFields;
    JTextField[] dirFields;
    JTextField browserField;
    JCheckBox toolTipCheck;

    public PrefUI() {
        this.setTitle(I18N.get("Preferences.title"));
        JPanel jPanel = new JPanel(new BorderLayout());
        this.setContentPane(jPanel);
        this.tabbedPane.addTab(I18N.get("Preferences.laf"), this.createLAFPanel());
        this.tabbedPane.addTab(I18N.get("Preferences.display"), this.createDisplayPanel());
        this.tabbedPane.addTab(I18N.get("Preferences.console"), this.createConsolePanel());
        this.tabbedPane.addTab(I18N.get("Preferences.misc"), this.createMiscPanel());
        this.setControls();
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton(new AbstractAction(I18N.get("Button.ok"), Images.getImageIcon("ok")){

            public void actionPerformed(ActionEvent actionEvent) {
                PrefUI.this.setVisible(false);
                Preferences.backup = (Preferences)Preferences.instance.clone();
                Preferences.instance.save();
            }
        }){
            {
                this.setToolTipText("<html>" + I18N.get("Preferences.save") + "</html>");
            }
        };
        JButton jButton2 = new JButton(new AbstractAction(I18N.get("Button.cancel"), Images.getImageIcon("cancel")){

            public void actionPerformed(ActionEvent actionEvent) {
                PrefUI.this.setVisible(false);
                Preferences.instance = (Preferences)Preferences.backup.clone();
                PrefUI.this.setControls();
                PrefUI.this.notifyDisplayListeners();
                PrefUI.this.notifyConsoleListeners();
            }
        }){
            {
                this.setToolTipText("<html>" + I18N.get("Preferences.close.without.save") + "</html>");
            }
        };
        JButton jButton3 = new JButton(new AbstractAction(null, Images.getImageIcon("restore")){

            public void actionPerformed(ActionEvent actionEvent) {
                Preferences.instance.restoreFactoryData();
                PrefUI.this.setControls();
                PrefUI.this.notifyDisplayListeners();
                PrefUI.this.notifyConsoleListeners();
            }
        }){
            {
                this.setToolTipText(I18N.get("Preferences.restore"));
            }
        };
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel2.add(new JSeparator(1));
        jPanel2.add(jButton3);
        this.add((Component)this.tabbedPane, "Center");
        this.add((Component)jPanel2, "Last");
        this.pack();
        this.setSize(new Dimension(300, this.getSize().height));
    }

    public void setSelectedTab(String string) {
        if (string.equalsIgnoreCase("misc")) {
            this.tabbedPane.setSelectedIndex(3);
        }
    }

    public void addDisplayPrefListener(PrefListener prefListener) {
        this.displayPrefListeners.addElement(prefListener);
    }

    private void notifyDisplayListeners() {
        for (int i = 0; i < this.displayPrefListeners.size(); ++i) {
            this.displayPrefListeners.get(i).displayPrefChanged();
        }
    }

    public void addConsolePrefListener(PrefListener prefListener) {
        this.consolePrefListeners.addElement(prefListener);
    }

    private void notifyConsoleListeners() {
        for (int i = 0; i < this.consolePrefListeners.size(); ++i) {
            this.consolePrefListeners.get(i).consolePrefChanged();
        }
    }

    private void setControls() {
        int n;
        this.blackOutSlider.setValue((int)(100.0 * Preferences.instance.getDouble("blackOut")));
        for (n = 0; n < this.colorButtons.length; ++n) {
            this.colorButtons[n].setBackground((Color)Preferences.instance.get("faceletColor" + n));
        }
        this.distortionCheck.setSelected(Preferences.instance.getBoolean("allowDistortion"));
        this.angVelocityCheck.setSelected(Preferences.instance.getBoolean("varyAngularVelocity"));
        this.stepSpinner.setValue(Preferences.instance.get("animationSteps"));
        this.timeSpinner.setValue(Preferences.instance.get("animationTime"));
        for (n = 0; n < this.captureButtons.length; ++n) {
            this.captureButtons[n].refresh();
        }
        block21: for (n = 0; n < this.sideFields.length; ++n) {
            switch (n) {
                case 0: {
                    this.sideFields[n].setText((String)Preferences.instance.get("F"));
                    continue block21;
                }
                case 1: {
                    this.sideFields[n].setText((String)Preferences.instance.get("B"));
                    continue block21;
                }
                case 2: {
                    this.sideFields[n].setText((String)Preferences.instance.get("R"));
                    continue block21;
                }
                case 3: {
                    this.sideFields[n].setText((String)Preferences.instance.get("L"));
                    continue block21;
                }
                case 4: {
                    this.sideFields[n].setText((String)Preferences.instance.get("U"));
                    continue block21;
                }
                case 5: {
                    this.sideFields[n].setText((String)Preferences.instance.get("D"));
                }
            }
        }
        block22: for (n = 0; n < this.layerFields.length; ++n) {
            switch (n) {
                case 0: {
                    this.layerFields[n].setText((String)Preferences.instance.get("outer"));
                    continue block22;
                }
                case 1: {
                    this.layerFields[n].setText((String)Preferences.instance.get("inner"));
                    continue block22;
                }
                case 2: {
                    this.layerFields[n].setText((String)Preferences.instance.get("par"));
                    continue block22;
                }
                case 3: {
                    this.layerFields[n].setText((String)Preferences.instance.get("all"));
                }
            }
        }
        block23: for (n = 0; n < this.dirFields.length; ++n) {
            switch (n) {
                case 0: {
                    this.dirFields[n].setText((String)Preferences.instance.get("cwise"));
                    continue block23;
                }
                case 1: {
                    this.dirFields[n].setText((String)Preferences.instance.get("ccwise"));
                    continue block23;
                }
                case 2: {
                    this.dirFields[n].setText((String)Preferences.instance.get("twice"));
                }
            }
        }
        this.browserField.setText((String)Preferences.instance.get("browser"));
        this.toolTipCheck.setSelected(Preferences.instance.getBoolean("enableToolTips"));
    }

    private JPanel createLAFPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JCheckBox jCheckBox = new JCheckBox("<html>" + I18N.get("Preferences.laf.frame.decoration") + "</html>");
        jCheckBox.setSelected(Preferences.instance.getBoolean("frameDecoration"));
        jCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    Preferences.instance.set("frameDecoration", new Boolean(true));
                } else if (itemEvent.getStateChange() == 2) {
                    Preferences.instance.set("frameDecoration", new Boolean(false));
                }
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        String string = (String)Preferences.instance.get("lookAndFeel");
        final UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < lookAndFeelInfoArray.length; ++i) {
            JRadioButton jRadioButton = new JRadioButton(lookAndFeelInfoArray[i].getName());
            final int n = i;
            jRadioButton.addActionListener(new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Preferences.instance.set("lookAndFeel", lookAndFeelInfoArray[n].getClassName());
                }
            });
            if (string.equals(lookAndFeelInfoArray[i].getClassName())) {
                jRadioButton.setSelected(true);
            }
            if (string.equals(UIManager.getCrossPlatformLookAndFeelClassName())) {
                jCheckBox.setEnabled(true);
            }
            buttonGroup.add(jRadioButton);
            jPanel.add(jRadioButton);
        }
        jPanel.add(Box.createRigidArea(new Dimension(0, 20)));
        jPanel.add(jCheckBox);
        jPanel.add(Box.createRigidArea(new Dimension(0, 20)));
        jPanel.add(new JLabel("<html>" + I18N.get("Preferences.laf.take.effect") + "</html>"));
        return jPanel;
    }

    private JPanel createDisplayPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder(I18N.get("Preferences.display.light")));
        this.blackOutSlider = new JSlider(0, 0, 100, 0);
        this.blackOutSlider.setMajorTickSpacing(100);
        this.blackOutSlider.setPaintTicks(true);
        this.blackOutSlider.setPaintLabels(true);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        hashtable.put(new Integer(0), new JLabel(I18N.get("Preferences.display.diffuse")));
        hashtable.put(new Integer(100), new JLabel(I18N.get("Preferences.display.sharp")));
        this.blackOutSlider.setLabelTable(hashtable);
        this.blackOutSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Preferences.instance.set("blackOut", new Double((double)((JSlider)changeEvent.getSource()).getValue() / 100.0));
                PrefUI.this.notifyDisplayListeners();
            }
        });
        jPanel2.add(this.blackOutSlider);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createTitledBorder(I18N.get("Preferences.display.colors")));
        this.colorButtons = new JLabel[6];
        for (int i = 0; i < 6; ++i) {
            final int n = i;
            this.colorButtons[i] = new JLabel();
            this.colorButtons[i].addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    Color color = JColorChooser.showDialog(PrefUI.this, I18N.get("Preferences.display.colors.choose"), (Color)Preferences.instance.get("faceletColor" + n));
                    if (color != null) {
                        BasicGraphicsEngine.faceletColors[n].setColor(color);
                        Preferences.instance.set("faceletColor" + n, color);
                        PrefUI.this.colorButtons[n].setBackground(color);
                        PrefUI.this.notifyDisplayListeners();
                    }
                }
            });
            this.colorButtons[i].setPreferredSize(new Dimension(32, 32));
            this.colorButtons[i].setMinimumSize(new Dimension(32, 32));
            this.colorButtons[i].setOpaque(true);
            this.colorButtons[i].setBorder(BorderFactory.createLineBorder(Color.BLACK));
            jPanel3.add(this.colorButtons[i]);
        }
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(BorderFactory.createTitledBorder(I18N.get("Preferences.display.distortion")));
        this.distortionCheck = new JCheckBox(I18N.get("Preferences.display.distortion.enable"));
        this.distortionCheck.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    Preferences.instance.set("allowDistortion", new Boolean(true));
                } else if (itemEvent.getStateChange() == 2) {
                    Preferences.instance.set("allowDistortion", new Boolean(false));
                }
                PrefUI.this.notifyDisplayListeners();
            }
        });
        jPanel4.add(this.distortionCheck);
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        jPanel5.setBorder(BorderFactory.createTitledBorder(I18N.get("Preferences.display.animation")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 22;
        jPanel5.add((Component)new JLabel(I18N.get("Preferences.display.animation.stepcount") + ":"), gridBagConstraints);
        this.stepSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 90, 1));
        this.stepSpinner.setPreferredSize(new Dimension(70, 20));
        this.stepSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Preferences.instance.set("animationSteps", (Integer)((JSpinner)changeEvent.getSource()).getValue());
            }
        });
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        jPanel5.add((Component)this.stepSpinner, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 22;
        jPanel5.add((Component)new JLabel(I18N.get("Preferences.display.animation.time") + ":"), gridBagConstraints);
        this.timeSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 5000, 100));
        this.timeSpinner.setPreferredSize(new Dimension(70, 20));
        this.timeSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Preferences.instance.set("animationTime", (Integer)((JSpinner)changeEvent.getSource()).getValue());
            }
        });
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        jPanel5.add((Component)this.timeSpinner, gridBagConstraints);
        this.angVelocityCheck = new JCheckBox(I18N.get("Preferences.display.animation.angular"));
        this.angVelocityCheck.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    Preferences.instance.set("varyAngularVelocity", new Boolean(true));
                } else if (itemEvent.getStateChange() == 2) {
                    Preferences.instance.set("varyAngularVelocity", new Boolean(false));
                }
                PrefUI.this.notifyDisplayListeners();
            }
        });
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 21;
        jPanel5.add((Component)this.angVelocityCheck, gridBagConstraints);
        JPanel jPanel6 = new JPanel(new GridBagLayout());
        jPanel6.setBorder(BorderFactory.createTitledBorder(I18N.get("Preferences.display.mouse")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.captureButtons = new MouseCaptureButton[3];
        String[] stringArray = new String[]{I18N.get("Preferences.display.mouse.xy"), I18N.get("Preferences.display.mouse.z"), I18N.get("Preferences.display.mouse.turn")};
        for (int i = 0; i < 3; ++i) {
            this.captureButtons[i] = new MouseCaptureButton(i);
            gridBagConstraints.gridx = i;
            gridBagConstraints.gridy = 0;
            jPanel6.add((Component)new JLabel(stringArray[i]), gridBagConstraints);
            gridBagConstraints.gridx = i;
            gridBagConstraints.gridy = 1;
            jPanel6.add((Component)this.captureButtons[i], gridBagConstraints);
        }
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        jPanel.add(jPanel4);
        jPanel.add(jPanel5);
        jPanel.add(jPanel6);
        return jPanel;
    }

    private JPanel createConsolePanel() {
        int n;
        int n2;
        int n3;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(I18N.get("Preferences.console.sides")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        String[] stringArray = new String[]{I18N.get("Preferences.console.front"), I18N.get("Preferences.console.back"), I18N.get("Preferences.console.right"), I18N.get("Preferences.console.left"), I18N.get("Preferences.console.up"), I18N.get("Preferences.console.down")};
        gridBagConstraints.anchor = 22;
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            gridBagConstraints.gridx = n3 % 2 * 2;
            gridBagConstraints.gridy = n3 / 2;
            jPanel2.add((Component)new JLabel(stringArray[n3] + ":"), gridBagConstraints);
        }
        gridBagConstraints.anchor = 21;
        this.sideFields = new XTextField[6];
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            this.sideFields[n3] = new XTextField(1);
            this.sideFields[n3].setPreferredSize(new Dimension(30, 30));
            final int n4 = n3;
            this.sideFields[n3].addActionListener(new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = ((JTextField)actionEvent.getSource()).getText();
                    if (string != null) {
                        switch (n4) {
                            case 0: {
                                Preferences.instance.set("F", string);
                                break;
                            }
                            case 1: {
                                Preferences.instance.set("B", string);
                                break;
                            }
                            case 2: {
                                Preferences.instance.set("R", string);
                                break;
                            }
                            case 3: {
                                Preferences.instance.set("L", string);
                                break;
                            }
                            case 4: {
                                Preferences.instance.set("U", string);
                                break;
                            }
                            case 5: {
                                Preferences.instance.set("D", string);
                            }
                        }
                    }
                    PrefUI.this.notifyConsoleListeners();
                }
            });
            gridBagConstraints.gridx = n3 % 2 * 2 + 1;
            gridBagConstraints.gridy = n3 / 2;
            jPanel2.add((Component)this.sideFields[n3], gridBagConstraints);
        }
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder(I18N.get("Preferences.console.layers")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        String[] stringArray2 = new String[]{I18N.get("Preferences.console.outer"), I18N.get("Preferences.console.inner"), I18N.get("Preferences.console.par"), I18N.get("Preferences.console.all")};
        gridBagConstraints.anchor = 22;
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            gridBagConstraints.gridx = n2 % 2 * 2;
            gridBagConstraints.gridy = n2 / 2;
            jPanel3.add((Component)new JLabel(stringArray2[n2] + ":"), gridBagConstraints);
        }
        gridBagConstraints.anchor = 21;
        this.layerFields = new XTextField[4];
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            this.layerFields[n2] = new XTextField(1);
            this.layerFields[n2].setPreferredSize(new Dimension(30, 30));
            final int n5 = n2;
            this.layerFields[n2].addActionListener(new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = ((JTextField)actionEvent.getSource()).getText();
                    if (string != null) {
                        switch (n5) {
                            case 0: {
                                Preferences.instance.set("outer", string);
                                break;
                            }
                            case 1: {
                                Preferences.instance.set("inner", string);
                                break;
                            }
                            case 2: {
                                Preferences.instance.set("par", string);
                                break;
                            }
                            case 3: {
                                Preferences.instance.set("all", string);
                            }
                        }
                    }
                    PrefUI.this.notifyConsoleListeners();
                }
            });
            gridBagConstraints.gridx = n2 % 2 * 2 + 1;
            gridBagConstraints.gridy = n2 / 2;
            jPanel3.add((Component)this.layerFields[n2], gridBagConstraints);
        }
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.setBorder(BorderFactory.createTitledBorder(I18N.get("Preferences.console.directions")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        String[] stringArray3 = new String[]{"<html>90&deg; " + I18N.get("Preferences.console.cwise") + "</html>", "<html>90&deg; " + I18N.get("Preferences.console.ccwise") + "</html>", "<html>180&deg;</html>"};
        gridBagConstraints.anchor = 22;
        for (n = 0; n < stringArray3.length; ++n) {
            gridBagConstraints.gridx = n % 2 * 2;
            gridBagConstraints.gridy = n / 2;
            jPanel4.add((Component)new JLabel(stringArray3[n] + ":"), gridBagConstraints);
        }
        gridBagConstraints.anchor = 21;
        this.dirFields = new XTextField[3];
        for (n = 0; n < stringArray3.length; ++n) {
            this.dirFields[n] = new XTextField(1);
            this.dirFields[n].setPreferredSize(new Dimension(30, 30));
            final int n6 = n;
            this.dirFields[n].addActionListener(new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = ((JTextField)actionEvent.getSource()).getText();
                    if (string != null) {
                        switch (n6) {
                            case 0: {
                                Preferences.instance.set("cwise", string);
                                break;
                            }
                            case 1: {
                                Preferences.instance.set("ccwise", string);
                                break;
                            }
                            case 2: {
                                Preferences.instance.set("twice", string);
                            }
                        }
                    }
                    PrefUI.this.notifyConsoleListeners();
                }
            });
            gridBagConstraints.gridx = n % 2 * 2 + 1;
            gridBagConstraints.gridy = n / 2;
            jPanel4.add((Component)this.dirFields[n], gridBagConstraints);
        }
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        jPanel.add(jPanel4);
        return jPanel;
    }

    private JPanel createMiscPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder(I18N.get("Preferences.misc.browser")));
        this.browserField = new XTextField();
        this.browserField.setPreferredSize(new Dimension(150, 30));
        this.browserField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Preferences.instance.set("browser", ((JTextField)actionEvent.getSource()).getText());
            }
        });
        jPanel2.add(this.browserField);
        jPanel2.add(new JButton(new AbstractAction(I18N.get("Preferences.misc.browse")){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                if (jFileChooser.showOpenDialog(PrefUI.this) == 0) {
                    String string = jFileChooser.getSelectedFile().getPath();
                    PrefUI.this.browserField.setText(string);
                    Preferences.instance.set("browser", string);
                }
            }
        }));
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createTitledBorder(I18N.get("Preferences.misc.tooltips")));
        this.toolTipCheck = new JCheckBox("<html>" + I18N.get("Preferences.misc.tooltips.enable") + "</html>");
        this.toolTipCheck.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    Preferences.instance.set("enableToolTips", new Boolean(true));
                    ToolTipManager.sharedInstance().setEnabled(true);
                } else if (itemEvent.getStateChange() == 2) {
                    Preferences.instance.set("enableToolTips", new Boolean(false));
                    ToolTipManager.sharedInstance().setEnabled(false);
                }
            }
        });
        jPanel3.add(this.toolTipCheck);
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        return jPanel;
    }

    private class MouseCaptureButton
    extends JLabel {
        public int button;
        public int index;

        public MouseCaptureButton(int n) {
            this.index = n;
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    MouseCaptureButton.this.button = mouseEvent.getButton();
                    MouseCaptureButton.this.setImage();
                    switch (MouseCaptureButton.this.index) {
                        case 0: {
                            Preferences.instance.set("mouseButtonRotXY", MouseCaptureButton.this.button);
                            break;
                        }
                        case 1: {
                            Preferences.instance.set("mouseButtonRotZ", MouseCaptureButton.this.button);
                            break;
                        }
                        case 2: {
                            Preferences.instance.set("mouseButtonTurn", MouseCaptureButton.this.button);
                        }
                    }
                }
            });
        }

        public void refresh() {
            switch (this.index) {
                case 0: {
                    this.button = Preferences.instance.getInt("mouseButtonRotXY");
                    break;
                }
                case 1: {
                    this.button = Preferences.instance.getInt("mouseButtonRotZ");
                    break;
                }
                case 2: {
                    this.button = Preferences.instance.getInt("mouseButtonTurn");
                }
            }
            this.setImage();
        }

        private void setImage() {
            switch (this.button) {
                case 1: {
                    this.setIcon(Images.getImageIcon("mousebtn1"));
                    break;
                }
                case 2: {
                    this.setIcon(Images.getImageIcon("mousebtn2"));
                    break;
                }
                case 3: {
                    this.setIcon(Images.getImageIcon("mousebtn3"));
                }
            }
        }
    }
}

